/*
 * Copyright (c) 2013, 2021, Oracle and/or its affiliates.
 * All rights reserved. Use is subject to license terms.
 *
 * This file is available and licensed under the following license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  - Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the distribution.
 *  - Neither the name of Oracle Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package ensemble.generated;
import ensemble.*;
import ensemble.playground.PlaygroundProperty;
import javafx.application.ConditionalFeature;
import java.util.HashMap;
public class Samples{
    private static final SampleInfo SAMPLE_0 = new SampleInfo("Interpolator","A sample that shows various types of interpolation between key frames in a timeline. There are five circles, each animated with a different interpolation method. The Linear interpolator is the default. Use the controls to reduce opacity to zero for some circles to compare with others, or change circle color to distinguish between individual interpolators. ","/Animation/Interpolator","/ensemble/samples/animation/interpolator","ensemble.samples.animation.interpolator.InterpolatorApp","/ensemble/samples/animation/interpolator/preview.png",new String[]{"/ensemble/samples/animation/interpolator/InterpolatorApp.java",},new String[]{"javafx.animation.Interpolator","javafx.animation.KeyFrame","javafx.animation.KeyValue","javafx.animation.Timeline","javafx.util.Duration",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Graphics 2d/Bouncing Balls","/Graphics 2d/Display Shelf","/Scenegraph/Events/Key Stroke Motion","/Graphics 3d/Xylophone",},"/ensemble/samples/animation/interpolator/InterpolatorApp.java",new PlaygroundProperty[]{new PlaygroundProperty(null,"-","name","LINEAR"),new PlaygroundProperty("circle1","opacity","min","0","max","1"),new PlaygroundProperty("circle1","fill"),new PlaygroundProperty(null,"-","name","EASE_BOTH"),new PlaygroundProperty("circle2","opacity","min","0","max","1"),new PlaygroundProperty("circle2","fill"),new PlaygroundProperty(null,"-","name","EASE_IN"),new PlaygroundProperty("circle3","opacity","min","0","max","1"),new PlaygroundProperty("circle3","fill"),new PlaygroundProperty(null,"-","name","EASE_OUT"),new PlaygroundProperty("circle4","opacity","min","0","max","1"),new PlaygroundProperty("circle4","fill"),new PlaygroundProperty(null,"-","name","SPLINE"),new PlaygroundProperty("circle5","opacity","min","0","max","1"),new PlaygroundProperty("circle5","fill"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_1 = new SampleInfo("Timeline","A sample that demonstrates the basics of timeline creation. ","/Animation/Timeline","/ensemble/samples/animation/timeline","ensemble.samples.animation.timeline.TimelineApp","/ensemble/samples/animation/timeline/preview.png",new String[]{"/ensemble/samples/animation/timeline/TimelineApp.java",},new String[]{"javafx.animation.KeyFrame","javafx.animation.KeyValue","javafx.animation.Timeline","javafx.scene.layout.HBox","javafx.scene.layout.VBox","javafx.util.Duration",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Layout/HBox","/Animation/Timeline Events","/Layout/VBox",},"/ensemble/samples/animation/timeline/TimelineApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_2 = new SampleInfo("Timeline Events","A sample that demonstrates events triggered during time line play. The circle changes its radius in a linear fashion during each key frame and randomly jumps to a new location along the x coordinate at the end of the key frame. ","/Animation/Timeline Events","/ensemble/samples/animation/timelineevents","ensemble.samples.animation.timelineevents.TimelineEventsApp","/ensemble/samples/animation/timelineevents/preview.png",new String[]{"/ensemble/samples/animation/timelineevents/TimelineEventsApp.java",},new String[]{"javafx.animation.KeyFrame","javafx.animation.KeyValue","javafx.animation.Timeline","javafx.event.ActionEvent","javafx.event.EventHandler","javafx.util.Duration",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Layout/StackPane","/Animation/Timeline",},"/ensemble/samples/animation/timelineevents/TimelineEventsApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_3 = new SampleInfo("Fade Transition","A sample in which the opacity of a node changes over a given time. ","/Animation/Transitions/Fade Transition","/ensemble/samples/animation/transitions/fadetransition","ensemble.samples.animation.transitions.fadetransition.FadeTransitionApp","/ensemble/samples/animation/transitions/fadetransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/fadetransition/FadeTransitionApp.java",},new String[]{"javafx.animation.FadeTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/fadetransition/FadeTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_4 = new SampleInfo("Fill Transition","A sample in which the filling of a shape changes over a given time. ","/Animation/Transitions/Fill Transition","/ensemble/samples/animation/transitions/filltransition","ensemble.samples.animation.transitions.filltransition.FillTransitionApp","/ensemble/samples/animation/transitions/filltransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/filltransition/FillTransitionApp.java",},new String[]{"javafx.animation.FillTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/filltransition/FillTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_5 = new SampleInfo("Parallel Transition","A sample in which various transitions are executed in parallel. ","/Animation/Transitions/Parallel Transition","/ensemble/samples/animation/transitions/paralleltransition","ensemble.samples.animation.transitions.paralleltransition.ParallelTransitionApp","/ensemble/samples/animation/transitions/paralleltransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/paralleltransition/ParallelTransitionApp.java",},new String[]{"javafx.animation.ParallelTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/paralleltransition/ParallelTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_6 = new SampleInfo("Path Transition","A sample in which a node moves along a path from end to end over a given time. ","/Animation/Transitions/Path Transition","/ensemble/samples/animation/transitions/pathtransition","ensemble.samples.animation.transitions.pathtransition.PathTransitionApp","/ensemble/samples/animation/transitions/pathtransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/pathtransition/PathTransitionApp.java",},new String[]{"javafx.animation.PathTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/pathtransition/PathTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_7 = new SampleInfo("Pause Transition","A sample in which a node pauses over a given time. ","/Animation/Transitions/Pause Transition","/ensemble/samples/animation/transitions/pausetransition","ensemble.samples.animation.transitions.pausetransition.PauseTransitionApp","/ensemble/samples/animation/transitions/pausetransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/pausetransition/PauseTransitionApp.java",},new String[]{"javafx.animation.PauseTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/pausetransition/PauseTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_8 = new SampleInfo("Rotate Transition","A sample in which a node rotates around its center over a given time. ","/Animation/Transitions/Rotate Transition","/ensemble/samples/animation/transitions/rotatetransition","ensemble.samples.animation.transitions.rotatetransition.RotateTransitionApp","/ensemble/samples/animation/transitions/rotatetransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/rotatetransition/RotateTransitionApp.java",},new String[]{"javafx.animation.RotateTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/rotatetransition/RotateTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_9 = new SampleInfo("Scale Transition","A sample in which a node scales larger and smaller over a given time. ","/Animation/Transitions/Scale Transition","/ensemble/samples/animation/transitions/scaletransition","ensemble.samples.animation.transitions.scaletransition.ScaleTransitionApp","/ensemble/samples/animation/transitions/scaletransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/scaletransition/ScaleTransitionApp.java",},new String[]{"javafx.animation.ScaleTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/scaletransition/ScaleTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_10 = new SampleInfo("Sequential Transition","A sample in which various transitions are executed sequentially. ","/Animation/Transitions/Sequential Transition","/ensemble/samples/animation/transitions/sequentialtransition","ensemble.samples.animation.transitions.sequentialtransition.SequentialTransitionApp","/ensemble/samples/animation/transitions/sequentialtransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/sequentialtransition/SequentialTransitionApp.java",},new String[]{"javafx.animation.SequentialTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Stroke Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/sequentialtransition/SequentialTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_11 = new SampleInfo("Stroke Transition","A sample in which the stroke color of a shape changes over a given time. ","/Animation/Transitions/Stroke Transition","/ensemble/samples/animation/transitions/stroketransition","ensemble.samples.animation.transitions.stroketransition.StrokeTransitionApp","/ensemble/samples/animation/transitions/stroketransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/stroketransition/StrokeTransitionApp.java",},new String[]{"javafx.animation.StrokeTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Translate Transition",},"/ensemble/samples/animation/transitions/stroketransition/StrokeTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_12 = new SampleInfo("Translate Transition","A sample in which a node moves from one location to another over a given time. ","/Animation/Transitions/Translate Transition","/ensemble/samples/animation/transitions/translatetransition","ensemble.samples.animation.transitions.translatetransition.TranslateTransitionApp","/ensemble/samples/animation/transitions/translatetransition/preview.png",new String[]{"/ensemble/samples/animation/transitions/translatetransition/TranslateTransitionApp.java",},new String[]{"javafx.animation.TranslateTransition","javafx.animation.Transition",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149","JavaFX Transitions & Animation",},new String[]{"/Animation/Transitions/Fade Transition","/Animation/Transitions/Fill Transition","/Animation/Transitions/Parallel Transition","/Animation/Transitions/Path Transition","/Animation/Transitions/Pause Transition","/Animation/Transitions/Rotate Transition","/Animation/Transitions/Scale Transition","/Animation/Transitions/Sequential Transition","/Animation/Transitions/Stroke Transition",},"/ensemble/samples/animation/transitions/translatetransition/TranslateTransitionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_13 = new SampleInfo("Bubble Chart","An advanced bubble chart with a variety of actions and settable properties. ","/Charts/Bubble Chart","/ensemble/samples/charts/bubble","ensemble.samples.charts.bubble.BubbleChartApp","/ensemble/samples/charts/bubble/preview.png",new String[]{"/ensemble/samples/charts/bubble/BubbleChartApp.java","/ensemble/samples/charts/bubble/BubbleChart.css",},new String[]{"javafx.scene.chart.BubbleChart","javafx.scene.chart.NumberAxis",},new String[]{},new String[]{"/Charts/Scatter/Scatter Chart",},"/ensemble/samples/charts/bubble/BubbleChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-100","max","100","step","1"),new PlaygroundProperty("xAxis","upperBound","min","0","max","200","step","1"),new PlaygroundProperty("xAxis","tickUnit","step","1"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-100","max","100","step","1"),new PlaygroundProperty("yAxis","upperBound","min","0","max","200","step","1"),new PlaygroundProperty("yAxis","tickUnit","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_14 = new SampleInfo("Candle Stick Chart","A custom candlestick chart. This sample shows how to extend XYChart base class to create your own two axis chart type. ","/Charts/Candle Stick Chart","/ensemble/samples/charts/candlestick","ensemble.samples.charts.candlestick.CandleStickChartApp","/ensemble/samples/charts/candlestick/preview.png",new String[]{"/ensemble/samples/charts/candlestick/Candle.java","/ensemble/samples/charts/candlestick/CandleStickChart.java","/ensemble/samples/charts/candlestick/CandleStickChartApp.java","/ensemble/samples/charts/candlestick/CandleStickExtraValues.java","/ensemble/samples/charts/candlestick/TooltipContent.java","/ensemble/samples/charts/candlestick/CandleStickChart.css",},new String[]{"javafx.scene.chart.NumberAxis","javafx.scene.chart.XYChart","javafx.scene.shape.LineTo","javafx.scene.shape.MoveTo",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Scatter/Scatter Chart","/Charts/Line/Stock Line Chart",},"/ensemble/samples/charts/candlestick/CandleStickChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-100","max","100","step","1"),new PlaygroundProperty("xAxis","upperBound","step","1"),new PlaygroundProperty("xAxis","tickUnit","step","0.5"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-100","max","30","step","1"),new PlaygroundProperty("yAxis","upperBound","step","1"),new PlaygroundProperty("yAxis","tickUnit","step","0.5"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_15 = new SampleInfo("Audio Area Chart","An area chart that shows audio spectrum of a music file being played. ","/Charts/Area/Audio Area Chart","/ensemble/samples/charts/area/audio","ensemble.samples.charts.area.audio.AudioAreaChartApp","/ensemble/samples/charts/area/audio/preview.png",new String[]{"/ensemble/samples/charts/area/audio/AudioAreaChartApp.java","/ensemble/samples/charts/area/audio/AudioAreaChart.css",},new String[]{"javafx.scene.chart.AreaChart","javafx.scene.chart.Chart","javafx.scene.chart.NumberAxis","javafx.scene.chart.XYChart","javafx.scene.media.AudioSpectrumListener","javafx.scene.media.Media","javafx.scene.media.MediaPlayer",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Bar/Audio Bar Chart",},"/ensemble/samples/charts/area/audio/AudioAreaChartApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.MEDIA,},false);
    private static final SampleInfo SAMPLE_16 = new SampleInfo("Area Chart","A chart that fills in the area between a line of data points and the axes. Good for comparing accumulated totals over time. ","/Charts/Area/Area Chart","/ensemble/samples/charts/area/chart","ensemble.samples.charts.area.chart.AreaChartApp","/ensemble/samples/charts/area/chart/preview.png",new String[]{"/ensemble/samples/charts/area/chart/AreaChartApp.java",},new String[]{"javafx.scene.chart.AreaChart","javafx.scene.chart.NumberAxis",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Audio Area Chart","/Charts/Area/Curve-Fitted Area Chart","/Charts/Line/Line Chart","/Charts/Scatter/Scatter Chart","/Charts/Area/Stacked Area Chart",},"/ensemble/samples/charts/area/chart/AreaChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-10","max","10","step","1"),new PlaygroundProperty("xAxis","upperBound","min","-10","max","10","step","1"),new PlaygroundProperty("xAxis","tickUnit","max","10","step","0.5"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-10","max","10","step","1"),new PlaygroundProperty("yAxis","upperBound","min","-10","max","10","step","1"),new PlaygroundProperty("yAxis","tickUnit","max","10","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_17 = new SampleInfo("Curve-Fitted Area Chart","An area chart that demonstrates curve fitting. Styling is done through CSS. ","/Charts/Area/Curve-Fitted Area Chart","/ensemble/samples/charts/area/curvefitted","ensemble.samples.charts.area.curvefitted.CurveFittedAreaChartApp","/ensemble/samples/charts/area/curvefitted/preview.png",new String[]{"/ensemble/samples/charts/area/curvefitted/CurveFittedAreaChart.java","/ensemble/samples/charts/area/curvefitted/CurveFittedAreaChartApp.java","/ensemble/samples/charts/area/curvefitted/CurveFittedAreaChart.css",},new String[]{"javafx.scene.chart.AreaChart","javafx.scene.chart.NumberAxis","javafx.scene.shape.CubicCurveTo","javafx.scene.shape.LineTo","javafx.scene.shape.MoveTo",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Area Chart","/Charts/Area/Audio Area Chart","/Charts/Area/Stacked Area Chart",},"/ensemble/samples/charts/area/curvefitted/CurveFittedAreaChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-10000","max","10000","step","1"),new PlaygroundProperty("xAxis","upperBound","min","-10000","max","10000","step","1"),new PlaygroundProperty("xAxis","tickUnit","max","10000","step","1"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-1000","max","1000","step","1"),new PlaygroundProperty("yAxis","upperBound","min","-1000","max","2000","step","1"),new PlaygroundProperty("yAxis","tickUnit","max","1000","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_18 = new SampleInfo("Stacked Area Chart","A sample that displays data in a stacked area chart. ","/Charts/Area/Stacked Area Chart","/ensemble/samples/charts/area/stacked","ensemble.samples.charts.area.stacked.StackedAreaChartApp","/ensemble/samples/charts/area/stacked/preview.png",new String[]{"/ensemble/samples/charts/area/stacked/StackedAreaChartApp.java",},new String[]{"javafx.scene.chart.NumberAxis","javafx.scene.chart.StackedAreaChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Area Chart","/Charts/Area/Audio Area Chart","/Charts/Area/Curve-Fitted Area Chart",},"/ensemble/samples/charts/area/stacked/StackedAreaChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-10","max","10","step","1"),new PlaygroundProperty("xAxis","upperBound","min","-10","max","10","step","1"),new PlaygroundProperty("xAxis","tickUnit","max","10"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-10","max","20","step","1"),new PlaygroundProperty("yAxis","upperBound","min","-10","max","40","step","1"),new PlaygroundProperty("yAxis","tickUnit","max","10"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_19 = new SampleInfo("Audio Bar Chart","Bar chart that shows audio spectrum of a music file being played. ","/Charts/Bar/Audio Bar Chart","/ensemble/samples/charts/bar/audio","ensemble.samples.charts.bar.audio.AudioBarChartApp","/ensemble/samples/charts/bar/audio/preview.png",new String[]{"/ensemble/samples/charts/bar/audio/AudioBarChartApp.java","/ensemble/samples/charts/bar/audio/AudioBarChart.css",},new String[]{"javafx.scene.chart.BarChart","javafx.scene.chart.CategoryAxis","javafx.scene.chart.NumberAxis","javafx.scene.chart.XYChart","javafx.scene.media.AudioSpectrumListener","javafx.scene.media.Media","javafx.scene.media.MediaPlayer",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Bar/Bar Chart","/Charts/Bar/Horizontal Bar Chart","/Charts/Bar/Image Bar Chart","/Charts/Bar/Stacked Bar Chart",},"/ensemble/samples/charts/bar/audio/AudioBarChartApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,ConditionalFeature.MEDIA,},false);
    private static final SampleInfo SAMPLE_20 = new SampleInfo("Bar Chart","A chart that displays rectangular bars with heights indicating data values for categories. Used for displaying information when at least one axis has discontinuous or discrete data. ","/Charts/Bar/Bar Chart","/ensemble/samples/charts/bar/chart","ensemble.samples.charts.bar.chart.BarChartApp","/ensemble/samples/charts/bar/chart/preview.png",new String[]{"/ensemble/samples/charts/bar/chart/BarChartApp.java",},new String[]{"javafx.scene.chart.BarChart","javafx.scene.chart.CategoryAxis","javafx.scene.chart.NumberAxis",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Area Chart","/Charts/Bar/Audio Bar Chart","/Charts/Bar/Horizontal Bar Chart","/Charts/Bar/Image Bar Chart","/Charts/Line/Line Chart","/Charts/Scatter/Scatter Chart","/Charts/Bar/Stacked Bar Chart",},"/ensemble/samples/charts/bar/chart/BarChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","gapStartAndEnd"),new PlaygroundProperty("xAxis","startMargin"),new PlaygroundProperty("xAxis","endMargin"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-1000","max","3000","step","1"),new PlaygroundProperty("yAxis","upperBound","max","4000","step","1"),new PlaygroundProperty("yAxis","tickUnit","max","3000","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_21 = new SampleInfo("Horizontal Bar Chart","Horizontal bar chart with a variety of actions and settable properties for experimenting with the charts features. ","/Charts/Bar/Horizontal Bar Chart","/ensemble/samples/charts/bar/horizontal","ensemble.samples.charts.bar.horizontal.HorizontalBarChartApp","/ensemble/samples/charts/bar/horizontal/preview.png",new String[]{"/ensemble/samples/charts/bar/horizontal/HorizontalBarChartApp.java",},new String[]{"javafx.scene.chart.BarChart","javafx.scene.chart.CategoryAxis","javafx.scene.chart.NumberAxis",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Bar/Audio Bar Chart","/Charts/Bar/Bar Chart","/Charts/Bar/Image Bar Chart","/Charts/Bar/Stacked Bar Chart",},"/ensemble/samples/charts/bar/horizontal/HorizontalBarChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-1000","max","3000","step","1"),new PlaygroundProperty("xAxis","upperBound","max","4000","step","1"),new PlaygroundProperty("xAxis","tickUnit","max","3000","step","1"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","gapStartAndEnd"),new PlaygroundProperty("yAxis","startMargin"),new PlaygroundProperty("yAxis","endMargin"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_22 = new SampleInfo("Image Bar Chart","A bar chart that uses CSS to display stacks of car images to indicate data values for categories. ","/Charts/Bar/Image Bar Chart","/ensemble/samples/charts/bar/image","ensemble.samples.charts.bar.image.ImageBarChartApp","/ensemble/samples/charts/bar/image/preview.png",new String[]{"/ensemble/samples/charts/bar/image/ImageBarChartApp.java","/ensemble/samples/charts/bar/image/ImageBarChart.css","/ensemble/samples/charts/bar/image/sedan-s.png","/ensemble/samples/charts/bar/image/suv-s.png","/ensemble/samples/charts/bar/image/truck-s.png","/ensemble/samples/charts/bar/image/van-s.png",},new String[]{"javafx.scene.chart.BarChart","javafx.scene.chart.CategoryAxis","javafx.scene.chart.NumberAxis",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Bar/Audio Bar Chart","/Charts/Bar/Bar Chart","/Charts/Bar/Horizontal Bar Chart","/Charts/Bar/Stacked Bar Chart",},"/ensemble/samples/charts/bar/image/ImageBarChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","gapStartAndEnd"),new PlaygroundProperty("xAxis","startMargin"),new PlaygroundProperty("xAxis","endMargin"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-100","max","0","step","1"),new PlaygroundProperty("yAxis","upperBound","max","200","step","1"),new PlaygroundProperty("yAxis","tickUnit","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_23 = new SampleInfo("Stacked Bar Chart","A sample that displays data in a stacked bar chart. ","/Charts/Bar/Stacked Bar Chart","/ensemble/samples/charts/bar/stacked","ensemble.samples.charts.bar.stacked.StackedBarChartApp","/ensemble/samples/charts/bar/stacked/preview.png",new String[]{"/ensemble/samples/charts/bar/stacked/StackedBarChartApp.java",},new String[]{"javafx.scene.chart.CategoryAxis","javafx.scene.chart.NumberAxis","javafx.scene.chart.StackedBarChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Bar/Audio Bar Chart","/Charts/Bar/Bar Chart","/Charts/Bar/Horizontal Bar Chart","/Charts/Bar/Image Bar Chart",},"/ensemble/samples/charts/bar/stacked/StackedBarChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","gapStartAndEnd"),new PlaygroundProperty("xAxis","startMargin"),new PlaygroundProperty("xAxis","endMargin"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-3000","max","0","step","1"),new PlaygroundProperty("yAxis","upperBound","min","0","max","8000","step","1"),new PlaygroundProperty("yAxis","tickUnit","max","5000","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_24 = new SampleInfo("Category Line Chart","A line chart demonstrating a CategoryAxis implementation. ","/Charts/Line/Category Line Chart","/ensemble/samples/charts/line/category","ensemble.samples.charts.line.category.CategoryLineChartApp","/ensemble/samples/charts/line/category/preview.png",new String[]{"/ensemble/samples/charts/line/category/CategoryLineChartApp.java",},new String[]{"javafx.scene.chart.CategoryAxis","javafx.scene.chart.LineChart","javafx.scene.chart.NumberAxis",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Line/Line Chart","/Charts/Line/Stock Line Chart",},"/ensemble/samples/charts/line/category/CategoryLineChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","gapStartAndEnd"),new PlaygroundProperty("xAxis","startMargin"),new PlaygroundProperty("xAxis","endMargin"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-100","step","1"),new PlaygroundProperty("yAxis","upperBound","max","200","step","1"),new PlaygroundProperty("yAxis","tickUnit","step","1"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_25 = new SampleInfo("Line Chart","A chart in which lines connect a series of data points. Useful for viewing data trends over time. ","/Charts/Line/Line Chart","/ensemble/samples/charts/line/chart","ensemble.samples.charts.line.chart.LineChartApp","/ensemble/samples/charts/line/chart/preview.png",new String[]{"/ensemble/samples/charts/line/chart/LineChartApp.java",},new String[]{"javafx.scene.chart.LineChart","javafx.scene.chart.NumberAxis","javafx.scene.chart.XYChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Area Chart","/Charts/Line/Category Line Chart","/Charts/Scatter/Scatter Chart","/Charts/Line/Stock Line Chart",},"/ensemble/samples/charts/line/chart/LineChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-10","max","10","step","0.2"),new PlaygroundProperty("xAxis","upperBound","max","10","step","0.2"),new PlaygroundProperty("xAxis","tickUnit","max","3","step","0.2"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-5","max","5","step","0.2"),new PlaygroundProperty("yAxis","upperBound","max","10","step","0.2"),new PlaygroundProperty("yAxis","tickUnit","max","3","step","0.2"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_26 = new SampleInfo("Stock Line Chart","A simulated stock line chart. ","/Charts/Line/Stock Line Chart","/ensemble/samples/charts/line/stock","ensemble.samples.charts.line.stock.StockLineChartApp","/ensemble/samples/charts/line/stock/preview.png",new String[]{"/ensemble/samples/charts/line/stock/StockLineChartApp.java","/ensemble/samples/charts/line/stock/StockLineChart.css",},new String[]{"javafx.scene.chart.LineChart","javafx.scene.chart.NumberAxis","javafx.scene.chart.XYChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Area Chart","/Charts/Line/Category Line Chart","/Charts/Line/Line Chart","/Charts/Scatter/Scatter Chart",},"/ensemble/samples/charts/line/stock/StockLineChartApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_27 = new SampleInfo("Pie Chart","A circular chart divided into segments. The value of each segment represents a proportion of the total. ","/Charts/Pie/Pie Chart","/ensemble/samples/charts/pie/chart","ensemble.samples.charts.pie.chart.PieChartApp","/ensemble/samples/charts/pie/chart/preview.png",new String[]{"/ensemble/samples/charts/pie/chart/PieChartApp.java",},new String[]{"javafx.scene.chart.PieChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Pie/Drilldown Pie Chart",},"/ensemble/samples/charts/pie/chart/PieChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty("chart","clockwise"),new PlaygroundProperty("chart","labelLineLength"),new PlaygroundProperty("chart","labelsVisible"),new PlaygroundProperty("chart","startAngle","max","360"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_28 = new SampleInfo("Drilldown Pie Chart","A pie chart that provides the ability to drill down through data. Selecting a segment in the initial pie chart causes the pie chart to display detailed data for the selected segment. ","/Charts/Pie/Drilldown Pie Chart","/ensemble/samples/charts/pie/drilldown","ensemble.samples.charts.pie.drilldown.DrilldownPieChartApp","/ensemble/samples/charts/pie/drilldown/preview.png",new String[]{"/ensemble/samples/charts/pie/drilldown/DrilldownPieChartApp.java","/ensemble/samples/charts/pie/drilldown/DrilldownChart.css",},new String[]{"javafx.scene.chart.PieChart","javafx.scene.input.MouseEvent",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Pie/Drilldown Pie Chart",},"/ensemble/samples/charts/pie/drilldown/DrilldownPieChartApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_29 = new SampleInfo("Live Scatter Chart","A live scatter chart. ","/Charts/Scatter/Live Scatter Chart","/ensemble/samples/charts/scatter/animated","ensemble.samples.charts.scatter.animated.LiveScatterChartApp","/ensemble/samples/charts/scatter/animated/preview.png",new String[]{"/ensemble/samples/charts/scatter/animated/LiveScatterChartApp.java","/ensemble/samples/charts/scatter/animated/LiveScatterChart.css",},new String[]{"javafx.animation.SequentialTransition","javafx.animation.Timeline","javafx.scene.chart.NumberAxis","javafx.scene.chart.ScatterChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Scatter/Scatter Chart",},"/ensemble/samples/charts/scatter/animated/LiveScatterChartApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_30 = new SampleInfo("Scatter Chart","A chart that displays plotted symbols for a series of data points. Useful for viewing the distribution of data to see if there is any pattern, indicating a correlation. ","/Charts/Scatter/Scatter Chart","/ensemble/samples/charts/scatter/chart","ensemble.samples.charts.scatter.chart.ScatterChartApp","/ensemble/samples/charts/scatter/chart/preview.png",new String[]{"/ensemble/samples/charts/scatter/chart/ScatterChartApp.java","/ensemble/samples/charts/scatter/chart/ScatterChartApp.java.orig",},new String[]{"javafx.scene.chart.NumberAxis","javafx.scene.chart.ScatterChart","javafx.scene.chart.XYChart",},new String[]{"https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm","Using JavaFX Charts Tutorial",},new String[]{"/Charts/Area/Area Chart","/Charts/Line/Line Chart",},"/ensemble/samples/charts/scatter/chart/ScatterChartApp.java",new PlaygroundProperty[]{new PlaygroundProperty("chart","data"),new PlaygroundProperty(null,"-","name","xAxis"),new PlaygroundProperty("xAxis","autoRanging"),new PlaygroundProperty("xAxis","forceZeroInRange"),new PlaygroundProperty("xAxis","lowerBound","min","-10","max","10","step","0.25"),new PlaygroundProperty("xAxis","upperBound","max","20","step","0.25"),new PlaygroundProperty("xAxis","tickUnit","max","10","step","0.25"),new PlaygroundProperty("xAxis","minorTickCount","max","16"),new PlaygroundProperty("xAxis","minorTickLength","max","15"),new PlaygroundProperty("xAxis","minorTickVisible"),new PlaygroundProperty("xAxis","animated"),new PlaygroundProperty("xAxis","label"),new PlaygroundProperty("xAxis","side"),new PlaygroundProperty("xAxis","tickLabelFill"),new PlaygroundProperty("xAxis","tickLabelGap"),new PlaygroundProperty("xAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("xAxis","tickLabelsVisible"),new PlaygroundProperty("xAxis","tickLength"),new PlaygroundProperty("xAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","yAxis"),new PlaygroundProperty("yAxis","autoRanging"),new PlaygroundProperty("yAxis","forceZeroInRange"),new PlaygroundProperty("yAxis","lowerBound","min","-5","max","5","step","0.25"),new PlaygroundProperty("yAxis","upperBound","max","10","step","0.25"),new PlaygroundProperty("yAxis","tickUnit","max","10","step","0.25"),new PlaygroundProperty("yAxis","minorTickCount","max","16"),new PlaygroundProperty("yAxis","minorTickLength","max","15"),new PlaygroundProperty("yAxis","minorTickVisible"),new PlaygroundProperty("yAxis","animated"),new PlaygroundProperty("yAxis","label"),new PlaygroundProperty("yAxis","side"),new PlaygroundProperty("yAxis","tickLabelFill"),new PlaygroundProperty("yAxis","tickLabelGap"),new PlaygroundProperty("yAxis","tickLabelRotation","min","-180","max","180","step","1"),new PlaygroundProperty("yAxis","tickLabelsVisible"),new PlaygroundProperty("yAxis","tickLength"),new PlaygroundProperty("yAxis","tickMarkVisible"),new PlaygroundProperty(null,"-","name","chart"),new PlaygroundProperty("chart","horizontalGridLinesVisible"),new PlaygroundProperty("chart","horizontalZeroLineVisible"),new PlaygroundProperty("chart","verticalGridLinesVisible"),new PlaygroundProperty("chart","verticalZeroLineVisible"),new PlaygroundProperty("chart","animated"),new PlaygroundProperty("chart","legendSide"),new PlaygroundProperty("chart","legendVisible"),new PlaygroundProperty("chart","title"),new PlaygroundProperty("chart","titleSide"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_31 = new SampleInfo("Accordion","An example of an accordion control. You can use accordion controls to define individual panes and  display them one at a time. ","/Controls/Accordion","/ensemble/samples/controls/accordion","ensemble.samples.controls.accordion.AccordionApp","/ensemble/samples/controls/accordion/preview.png",new String[]{"/ensemble/samples/controls/accordion/AccordionApp.java",},new String[]{"javafx.scene.control.Accordion","javafx.scene.control.Button","javafx.scene.control.TitledPane","javafx.scene.shape.Rectangle",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Toggle Button","/Controls/Toolbar/Tool Bar",},"/ensemble/samples/controls/accordion/AccordionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_32 = new SampleInfo("Check Box","An example of CheckBoxes in various states. ","/Controls/Check Box","/ensemble/samples/controls/checkbox","ensemble.samples.controls.checkbox.CheckBoxApp","/ensemble/samples/controls/checkbox/preview.png",new String[]{"/ensemble/samples/controls/checkbox/CheckBoxApp.java",},new String[]{"javafx.scene.control.CheckBox","javafx.scene.layout.VBox",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Radio Button","/Animation/Timeline","/Layout/VBox",},"/ensemble/samples/controls/checkbox/CheckBoxApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_33 = new SampleInfo("ChoiceBox","An example of a ChoiceBox with several options. The ChoiceBox control displays a default or current selection, with an icon to click that expands the list for a selection. ","/Controls/ChoiceBox","/ensemble/samples/controls/choicebox","ensemble.samples.controls.choicebox.ChoiceBoxApp","/ensemble/samples/controls/choicebox/preview.png",new String[]{"/ensemble/samples/controls/choicebox/ChoiceBoxApp.java",},new String[]{"javafx.scene.control.ChoiceBox",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Radio Button",},"/ensemble/samples/controls/choicebox/ChoiceBoxApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_34 = new SampleInfo("ColorPicker","A sample that demonstrates the ColorPicker. ","/Controls/ColorPicker","/ensemble/samples/controls/colorpicker","ensemble.samples.controls.colorpicker.ColorPickerApp","/ensemble/samples/controls/colorpicker/preview.png",new String[]{"/ensemble/samples/controls/colorpicker/ColorPickerApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.ColorPicker","javafx.scene.control.Label",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/DatePicker",},"/ensemble/samples/controls/colorpicker/ColorPickerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_35 = new SampleInfo("DatePicker","A sample that demonstrates the DatePicker. There is an option to switch locales and see how DatePicker control picks it up. ","/Controls/DatePicker","/ensemble/samples/controls/datepicker","ensemble.samples.controls.datepicker.DatePickerApp","/ensemble/samples/controls/datepicker/preview.png",new String[]{"/ensemble/samples/controls/datepicker/DatePickerApp.java",},new String[]{"javafx.scene.control.CheckMenuItem","javafx.scene.control.DateCell","javafx.scene.control.DatePicker","javafx.scene.control.MenuBar","javafx.scene.control.RadioMenuItem","javafx.scene.control.ToggleGroup",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/ColorPicker","/Controls/Menu",},"/ensemble/samples/controls/datepicker/DatePickerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_36 = new SampleInfo("DialogApp","A sample that demonstrates the Dialog control. ","/Controls/DialogApp","/ensemble/samples/controls/dialog","ensemble.samples.controls.dialog.DialogApp","/ensemble/samples/controls/dialog/preview.png",new String[]{"/ensemble/samples/controls/dialog/DialogApp.java",},new String[]{"javafx.scene.control.Dialog","javafx.scene.control.TextArea",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Language/FXML Login Demo","/Controls/SpinnerApp",},"/ensemble/samples/controls/dialog/DialogApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_37 = new SampleInfo("HTML Editor","A sample that demonstrates the HTML Editor. You can make changes to the example text, and the resulting generated HTML is displayed. ","/Controls/HTML Editor","/ensemble/samples/controls/htmleditor","ensemble.samples.controls.htmleditor.HTMLEditorApp","/ensemble/samples/controls/htmleditor/preview.png",new String[]{"/ensemble/samples/controls/htmleditor/HTMLEditorApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.Label","javafx.scene.control.ScrollPane","javafx.scene.layout.VBox","javafx.scene.web.HTMLEditor",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Graphics2d/Colorful Circles","/Controls/Text/Simple Label","/Controls/WebView",},"/ensemble/samples/controls/htmleditor/HTMLEditorApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,},false);
    private static final SampleInfo SAMPLE_38 = new SampleInfo("HyperLink","A sample that shows a simple hyperlink and a hyperlink with an image. ","/Controls/HyperLink","/ensemble/samples/controls/hyperlink","ensemble.samples.controls.hyperlink.HyperLinkApp","/ensemble/samples/controls/hyperlink/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/controls/hyperlink/HyperLinkApp.java",},new String[]{"javafx.scene.control.Hyperlink","javafx.scene.image.ImageView",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Language/FXML Login Demo","/Graphics 2d/Images/Image Creation","/Controls/WebView",},"/ensemble/samples/controls/hyperlink/HyperLinkApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_39 = new SampleInfo("Menu","An example of a menu bar. The example includes use of the system bar, if the current platform supports a system bar. ","/Controls/Menu","/ensemble/samples/controls/menu","ensemble.samples.controls.menu.MenuApp","/ensemble/samples/controls/menu/preview.png",new String[]{"/ensemble/samples/shared-resources/menuInfo.png","/ensemble/samples/controls/menu/MenuApp.java",},new String[]{"javafx.scene.control.Menu","javafx.scene.control.MenuBar","javafx.scene.control.MenuItem","javafx.scene.input.KeyCombination",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/DatePicker","/Graphics 2d/Images/Image Creation",},"/ensemble/samples/controls/menu/MenuApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_40 = new SampleInfo("Pagination","A sample that demonstrates pagination. ","/Controls/Pagination","/ensemble/samples/controls/pagination","ensemble.samples.controls.pagination.PaginationApp","/ensemble/samples/controls/pagination/preview.png",new String[]{"/ensemble/samples/shared-resources/Animal1.jpg","/ensemble/samples/shared-resources/Animal2.jpg","/ensemble/samples/shared-resources/Animal3.jpg","/ensemble/samples/shared-resources/Animal4.jpg","/ensemble/samples/shared-resources/Animal5.jpg","/ensemble/samples/shared-resources/Animal6.jpg","/ensemble/samples/shared-resources/Animal7.jpg","/ensemble/samples/controls/pagination/PaginationApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.Pagination","javafx.scene.image.ImageView",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Graphics 2d/Display Shelf","/Graphics 2d/Images/Image Creation","/Controls/Button/Pill Button",},"/ensemble/samples/controls/pagination/PaginationApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_41 = new SampleInfo("Progress Bar","A sample that demonstrates the ProgressBar control. ","/Controls/Progress Bar","/ensemble/samples/controls/progressbar","ensemble.samples.controls.progressbar.ProgressBarApp","/ensemble/samples/controls/progressbar/preview.png",new String[]{"/ensemble/samples/controls/progressbar/ProgressBarApp.java",},new String[]{"javafx.scene.control.ProgressBar","javafx.scene.control.ProgressIndicator",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Progress Indicator","/Language/Concurrency/Service","/Language/Concurrency/Task",},"/ensemble/samples/controls/progressbar/ProgressBarApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_42 = new SampleInfo("Progress Indicator","A sample that demonstrates the Progress Indicator control in various modes. ","/Controls/Progress Indicator","/ensemble/samples/controls/progressindicator","ensemble.samples.controls.progressindicator.ProgressIndicatorApp","/ensemble/samples/controls/progressindicator/preview.png",new String[]{"/ensemble/samples/controls/progressindicator/ProgressIndicatorApp.java",},new String[]{"javafx.scene.control.ProgressIndicator","javafx.scene.layout.GridPane",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Layout/GridPane","/Controls/Progress Bar",},"/ensemble/samples/controls/progressindicator/ProgressIndicatorApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_43 = new SampleInfo("Radio Button","An example of radio buttons in various states. ","/Controls/Radio Button","/ensemble/samples/controls/radiobutton","ensemble.samples.controls.radiobutton.RadioButtonApp","/ensemble/samples/controls/radiobutton/preview.png",new String[]{"/ensemble/samples/controls/radiobutton/RadioButtonApp.java",},new String[]{"javafx.scene.control.RadioButton",},new String[]{},new String[]{"/Controls/Check Box",},"/ensemble/samples/controls/radiobutton/RadioButtonApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_44 = new SampleInfo("ScrollBar","A sample showing horizontal and vertical scroll bars. ","/Controls/ScrollBar","/ensemble/samples/controls/scrollbar","ensemble.samples.controls.scrollbar.ScrollBarApp","/ensemble/samples/controls/scrollbar/preview.png",new String[]{"/ensemble/samples/controls/scrollbar/ScrollBarApp.java",},new String[]{"javafx.scene.control.ScrollBar","javafx.scene.shape.Circle","javafx.scene.shape.Rectangle",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Graphics 2d/Display Shelf","/Controls/HTML Editor",},"/ensemble/samples/controls/scrollbar/ScrollBarApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_45 = new SampleInfo("SpinnerApp","A sample that demonstrates the Spinner control. ","/Controls/SpinnerApp","/ensemble/samples/controls/spinner","ensemble.samples.controls.spinner.SpinnerApp","/ensemble/samples/controls/spinner/preview.png",new String[]{"/ensemble/samples/controls/spinner/SpinnerApp.java",},new String[]{"javafx.scene.control.Spinner",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/DialogApp",},"/ensemble/samples/controls/spinner/SpinnerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_46 = new SampleInfo("Hidden SplitPane","A sample that demonstrates styling a hidden split pane with CSS. ","/Controls/Hidden SplitPane","/ensemble/samples/controls/splitpane","ensemble.samples.controls.splitpane.HiddenSplitPaneApp","/ensemble/samples/controls/splitpane/preview.png",new String[]{"/ensemble/samples/controls/splitpane/HiddenSplitPaneApp.java","/ensemble/samples/controls/splitpane/HiddenSplitPane.css",},new String[]{"javafx.scene.control.SplitPane","javafx.scene.layout.Region",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Language/SwingInterop","/Language/Concurrency/Task",},"/ensemble/samples/controls/splitpane/HiddenSplitPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_47 = new SampleInfo("TabPane","Some implementations of tabs using the TabPane class. ","/Controls/TabPane","/ensemble/samples/controls/tab","ensemble.samples.controls.tab.TabPaneApp","/ensemble/samples/controls/tab/preview.png",new String[]{"/ensemble/samples/controls/tab/TabPaneApp.java","/ensemble/samples/controls/tab/tab_16.png",},new String[]{"javafx.scene.control.Tab","javafx.scene.control.TabPane","javafx.scene.control.ToggleGroup","javafx.scene.control.Tooltip",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/DatePicker","/Graphics 2d/Images/Image Creation",},"/ensemble/samples/controls/tab/TabPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_48 = new SampleInfo("TableCellFactory","A simple table that uses cell factories to enable editing of boolean and String values in the table. ","/Controls/TableCellFactory","/ensemble/samples/controls/tablecellfactory","ensemble.samples.controls.tablecellfactory.TableCellFactoryApp","/ensemble/samples/controls/tablecellfactory/preview.png",new String[]{"/ensemble/samples/controls/tablecellfactory/Person.java","/ensemble/samples/controls/tablecellfactory/TableCellFactoryApp.java",},new String[]{"javafx.beans.property.BooleanProperty","javafx.beans.property.StringProperty","javafx.scene.control.TableColumn","javafx.scene.control.TableView","javafx.scene.control.cell.CheckBoxTableCell","javafx.scene.control.cell.PropertyValueFactory","javafx.scene.control.cell.TextFieldTableCell",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Language/Concurrency/Service","/Controls/TableView","/Language/Concurrency/Task","/Controls/TreeTableView",},"/ensemble/samples/controls/tablecellfactory/TableCellFactoryApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_49 = new SampleInfo("TableView","A simple table with a header row. ","/Controls/TableView","/ensemble/samples/controls/tableview","ensemble.samples.controls.tableview.TableViewApp","/ensemble/samples/controls/tableview/preview.png",new String[]{"/ensemble/samples/controls/tableview/Person.java","/ensemble/samples/controls/tableview/TableViewApp.java",},new String[]{"javafx.scene.control.TableColumn","javafx.scene.control.TablePosition","javafx.scene.control.TableRow","javafx.scene.control.TableView","javafx.scene.control.cell.PropertyValueFactory",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/TableCellFactory","/Controls/TreeTableView",},"/ensemble/samples/controls/tableview/TableViewApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_50 = new SampleInfo("Toggle Button","Toggle buttons in a toggle group. ","/Controls/Toggle Button","/ensemble/samples/controls/togglebutton","ensemble.samples.controls.togglebutton.ToggleButtonApp","/ensemble/samples/controls/togglebutton/preview.png",new String[]{"/ensemble/samples/controls/togglebutton/ToggleButtonApp.java",},new String[]{"javafx.scene.control.Label","javafx.scene.control.Toggle","javafx.scene.control.ToggleButton","javafx.scene.control.ToggleGroup","javafx.scene.layout.GridPane",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/ChoiceBox","/Controls/Accordion","/Controls/Toolbar/Tool Bar",},"/ensemble/samples/controls/togglebutton/ToggleButtonApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_51 = new SampleInfo("TreeTableView","A simple implementation of TreeTableView. The Notes column is editable. ","/Controls/TreeTableView","/ensemble/samples/controls/treetableview","ensemble.samples.controls.treetableview.TreeTableViewApp","/ensemble/samples/controls/treetableview/preview.png",new String[]{"/ensemble/samples/controls/treetableview/Data.java","/ensemble/samples/controls/treetableview/Inventory.java","/ensemble/samples/controls/treetableview/TreeTableViewApp.java",},new String[]{"javafx.scene.control.TreeItem","javafx.scene.control.TreeTableCell","javafx.scene.control.TreeTableColumn","javafx.scene.control.TreeTableView","javafx.scene.control.cell.TextFieldTreeTableCell","javafx.scene.control.cell.TreeItemPropertyValueFactory",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/TableView","/Controls/TreeView",},"/ensemble/samples/controls/treetableview/TreeTableViewApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_52 = new SampleInfo("TreeView","An implementation of the TreeView control displaying an expandable tree root node. ","/Controls/TreeView","/ensemble/samples/controls/treeview","ensemble.samples.controls.treeview.TreeViewApp","/ensemble/samples/controls/treeview/preview.png",new String[]{"/ensemble/samples/controls/treeview/TreeViewApp.java",},new String[]{"javafx.scene.control.TreeItem","javafx.scene.control.TreeView",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/TreeTableView",},"/ensemble/samples/controls/treeview/TreeViewApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_53 = new SampleInfo("WebView","A sample that demonstrates a WebView object accessing a web page. ","/Controls/WebView","/ensemble/samples/controls/webview","ensemble.samples.controls.webview.WebViewApp","/ensemble/samples/controls/webview/preview.png",new String[]{"/ensemble/samples/controls/webview/WebViewApp.java",},new String[]{"javafx.scene.web.WebView","javafx.scene.web.WebEngine",},new String[]{"http://docs.oracle.com/javase/8/javafx/embedded-browser-tutorial/overview.htm#JFXWV135","Using JavaFX WebView Component",},new String[]{"/Controls/HTML Editor","/Language/SwingInterop",},"/ensemble/samples/controls/webview/WebViewApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,},false);
    private static final SampleInfo SAMPLE_54 = new SampleInfo("Colored Buttons","An example of Buttons with different background colors. ","/Controls/Button/Colored Buttons","/ensemble/samples/controls/button/colorbutton","ensemble.samples.controls.button.colorbutton.ColorButtonApp","/ensemble/samples/controls/button/colorbutton/preview.png",new String[]{"/ensemble/samples/controls/button/colorbutton/ColorButtonApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.paint.Color",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Button/Graphic Button","/Controls/Button/Pill Button",},"/ensemble/samples/controls/button/colorbutton/ColorButtonApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_55 = new SampleInfo("Graphic Button","A button with an embedded image. ","/Controls/Button/Graphic Button","/ensemble/samples/controls/button/graphicbutton","ensemble.samples.controls.button.graphicbutton.GraphicButtonApp","/ensemble/samples/controls/button/graphicbutton/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/controls/button/graphicbutton/GraphicButtonApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.image.ImageView",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Button/Colored Buttons","/Controls/Button/Pill Button",},"/ensemble/samples/controls/button/graphicbutton/GraphicButtonApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_56 = new SampleInfo("Pill Button","This sample demonstrates styling toggle buttons with CSS. ","/Controls/Button/Pill Button","/ensemble/samples/controls/button/pillbutton","ensemble.samples.controls.button.pillbutton.PillButtonApp","/ensemble/samples/controls/button/pillbutton/preview.png",new String[]{"/ensemble/samples/controls/button/pillbutton/PillButtonApp.java","/ensemble/samples/controls/button/pillbutton/PillButton.css",},new String[]{"javafx.scene.control.ToggleButton","javafx.scene.control.ToggleGroup",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/DatePicker","/Controls/Toggle Button",},"/ensemble/samples/controls/button/pillbutton/PillButtonApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_57 = new SampleInfo("HorizontalListView","A sample showing an implementation of the ListView control, in which a list of items is displayed in a horizontal row. ListView is a powerful multi-row control, in which each of a virtually unlimited number of horizontal or vertical rows is defined as a cell. The control also supports dynamically variable non-homogenous row heights. ","/Controls/Listview/HorizontalListView","/ensemble/samples/controls/listview/horizontallistview","ensemble.samples.controls.listview.horizontallistview.HorizontalListViewApp","/ensemble/samples/controls/listview/horizontallistview/preview.png",new String[]{"/ensemble/samples/controls/listview/horizontallistview/HorizontalListViewApp.java",},new String[]{"javafx.scene.control.ListView","javafx.scene.control.SelectionModel",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Listview/ListViewCellFactory","/Controls/Listview/Simple ListView",},"/ensemble/samples/controls/listview/horizontallistview/HorizontalListViewApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_58 = new SampleInfo("ListViewCellFactory","A simple implementation of the ListView control that uses a CellFactory to customize the ListView cell contents. Positive values in the list are green, and negative values are red and enclosed in parentheses. Zero values are black. ","/Controls/Listview/ListViewCellFactory","/ensemble/samples/controls/listview/listviewcellfactory","ensemble.samples.controls.listview.listviewcellfactory.ListViewCellFactoryApp","/ensemble/samples/controls/listview/listviewcellfactory/preview.png",new String[]{"/ensemble/samples/controls/listview/listviewcellfactory/ListViewCellFactoryApp.java","/ensemble/samples/controls/listview/listviewcellfactory/MoneyFormatCell.java",},new String[]{"javafx.scene.control.ListView","javafx.scene.control.SelectionModel",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Listview/HorizontalListView","/Controls/Listview/Simple ListView",},"/ensemble/samples/controls/listview/listviewcellfactory/ListViewCellFactoryApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_59 = new SampleInfo("Simple ListView","A simple implementation of the ListView control, in which a list of items is displayed vertically.  ListView is a powerful multirow control, in which each of a virtually unlimited number of horizontal or vertical rows is defined as a cell. The control also supports dynamically variable nonhomogenous row heights. ","/Controls/Listview/Simple ListView","/ensemble/samples/controls/listview/simplelistview","ensemble.samples.controls.listview.simplelistview.SimpleListViewApp","/ensemble/samples/controls/listview/simplelistview/preview.png",new String[]{"/ensemble/samples/controls/listview/simplelistview/SimpleListViewApp.java",},new String[]{"javafx.scene.control.ListView","javafx.scene.control.SelectionModel",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Controls/Listview/HorizontalListView","/Controls/Listview/ListViewCellFactory",},"/ensemble/samples/controls/listview/simplelistview/SimpleListViewApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_60 = new SampleInfo("Advanced Label","Several Label controls, displayed in various alignments with respect to an image. ","/Controls/Text/Advanced Label","/ensemble/samples/controls/text/advancedlabel","ensemble.samples.controls.text.advancedlabel.AdvancedLabelApp","/ensemble/samples/controls/text/advancedlabel/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/controls/text/advancedlabel/AdvancedLabelApp.java",},new String[]{"javafx.scene.control.ContentDisplay","javafx.scene.control.Label","javafx.scene.image.Image","javafx.scene.image.ImageView","javafx.scene.layout.VBox",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Bidi","/Controls/Text/Inset Text","/Controls/Button/Graphic Button","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/Text Field","/Controls/Text/TextFlow","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/advancedlabel/AdvancedLabelApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_61 = new SampleInfo("Bidi","Demonstrates bi-directional text. ","/Controls/Text/Bidi","/ensemble/samples/controls/text/bidi","ensemble.samples.controls.text.bidi.BidiApp","/ensemble/samples/controls/text/bidi/preview.png",new String[]{"/ensemble/samples/controls/text/bidi/BidiApp.java",},new String[]{"javafx.scene.text.Text","javafx.scene.text.TextFlow",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Inset Text","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/Text Field","/Controls/Text/TextFlow","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/bidi/BidiApp.java",new PlaygroundProperty[]{new PlaygroundProperty("text1","strikethrough","name","He said... strikethrough"),new PlaygroundProperty("text1","underline","name","He said... underline"),new PlaygroundProperty("text1","fill","name","He said... fill"),new PlaygroundProperty("text1","rotate","min","-180","max","180","name","He said... rotate"),new PlaygroundProperty("text1","translateX","name","He said... translateX"),new PlaygroundProperty("text1","translateY","name","He said... translateY"),new PlaygroundProperty("text2","strikethrough","name","He said... strikethrough"),new PlaygroundProperty("text2","underline","name","...to me. underline"),new PlaygroundProperty("text2","fill","name","...to me. fill"),new PlaygroundProperty("text2","rotate","min","-180","max","180","name","...to me. rotate"),new PlaygroundProperty("text2","translateX","name","...to me. translateX"),new PlaygroundProperty("text2","translateY","name","...to me. translateY"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_62 = new SampleInfo("Inset Text","A sample that shows styling of text through CSS. ","/Controls/Text/Inset Text","/ensemble/samples/controls/text/insettext","ensemble.samples.controls.text.insettext.InsetTextApp","/ensemble/samples/controls/text/insettext/preview.png",new String[]{"/ensemble/samples/controls/text/insettext/InsetTextApp.java","/ensemble/samples/controls/text/insettext/InsetText.css",},new String[]{"javafx.scene.control.Label",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Bidi","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/Text Field","/Controls/Text/TextFlow","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/insettext/InsetTextApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_63 = new SampleInfo("Search Box","A sample that demonstrates use of CSS to create a search box. ","/Controls/Text/Search Box","/ensemble/samples/controls/text/searchbox","ensemble.samples.controls.text.searchbox.SearchBoxApp","/ensemble/samples/controls/text/searchbox/preview.png",new String[]{"/ensemble/samples/controls/text/searchbox/SearchBox.java","/ensemble/samples/controls/text/searchbox/SearchBoxApp.java","/ensemble/samples/controls/text/searchbox/SearchBox.css",},new String[]{"javafx.scene.control.Button","javafx.scene.control.TextField","javafx.scene.layout.VBox",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Bidi","/Controls/Text/Inset Text","/Controls/Text/Simple Label","/Controls/Text/Text Field","/Controls/Text/TextFlow","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/searchbox/SearchBoxApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_64 = new SampleInfo("Simple Label","A simple implementation of the Label control, with an image to the left of the label. ","/Controls/Text/Simple Label","/ensemble/samples/controls/text/simplelabel","ensemble.samples.controls.text.simplelabel.SimpleLabelApp","/ensemble/samples/controls/text/simplelabel/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/controls/text/simplelabel/SimpleLabelApp.java",},new String[]{"javafx.scene.control.Label","javafx.scene.image.Image","javafx.scene.image.ImageView",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Button/Graphic Button","/Controls/Text/Inset Text","/Controls/Text/Inset Text","/Controls/Text/Search Box","/Controls/Text/Text Field","/Controls/Text/TextFlow","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/simplelabel/SimpleLabelApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_65 = new SampleInfo("Text Field","Demonstrates a TextField control that allows you to enter text. ","/Controls/Text/Text Field","/ensemble/samples/controls/text/textfield","ensemble.samples.controls.text.textfield.TextFieldApp","/ensemble/samples/controls/text/textfield/preview.png",new String[]{"/ensemble/samples/controls/text/textfield/TextFieldApp.java",},new String[]{"javafx.scene.control.TextField",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Bidi","/Controls/Text/Inset Text","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/TextFlow","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/textfield/TextFieldApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_66 = new SampleInfo("TextFlow","Demonstrates some simple uses of rich text and TextFlow.The first example shows use of text with different fonts in a TextFlow. Use the Playground to experiment with different Text properties. The second example shows TextFlow and embedded objects. ","/Controls/Text/TextFlow","/ensemble/samples/controls/text/textflow","ensemble.samples.controls.text.textflow.TextFlowApp","/ensemble/samples/controls/text/textflow/preview.png",new String[]{"/ensemble/samples/shared-resources/oracle.png","/ensemble/samples/controls/text/textflow/TextFlowApp.java",},new String[]{"javafx.scene.text.Font","javafx.scene.text.FontPosture","javafx.scene.text.Text","javafx.scene.text.TextFlow",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Bidi","/Controls/Text/Inset Text","/Controls/Button/Graphic Button","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/Text Field","/Controls/Text/Text Formatter","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/textflow/TextFlowApp.java",new PlaygroundProperty[]{new PlaygroundProperty("textHello","strikethrough","name","Hello strikethrough"),new PlaygroundProperty("textHello","underline","name","Hello underline"),new PlaygroundProperty("textHello","fill","name","Hello fill"),new PlaygroundProperty("textHello","rotate","min","-180","max","180","name","Hello rotate"),new PlaygroundProperty("textHello","translateX","name","Hello translateX"),new PlaygroundProperty("textHello","translateY","name","Hello translateY"),new PlaygroundProperty("textBold","strikethrough","name","Bold strikethrough"),new PlaygroundProperty("textBold","underline","name","Bold underline"),new PlaygroundProperty("textBold","fill","name","Bold fill"),new PlaygroundProperty("textBold","rotate","min","-180","max","180","name","Bold rotate"),new PlaygroundProperty("textBold","translateX","name","Bold translateX"),new PlaygroundProperty("textBold","translateY","name","Bold translateY"),new PlaygroundProperty("textWorld","strikethrough","name","World strikethrough"),new PlaygroundProperty("textWorld","underline","name","World underline"),new PlaygroundProperty("textWorld","fill","name","World fill"),new PlaygroundProperty("textWorld","rotate","min","-180","max","180","name","World rotate"),new PlaygroundProperty("textWorld","translateX","name","World translateX"),new PlaygroundProperty("textWorld","translateY","name","World translateY"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_67 = new SampleInfo("Text Formatter","Demonstrates a TextField control with a TextFormatter that filters and formats the content. ","/Controls/Text/Text Formatter","/ensemble/samples/controls/text/textformatter","ensemble.samples.controls.text.textformatter.TextFormatterApp","/ensemble/samples/controls/text/textformatter/preview.png",new String[]{"/ensemble/samples/controls/text/textformatter/TextFormatterApp.java",},new String[]{"javafx.scene.control.TextFormatter","javafx.scene.control.TextField","javafx.scene.control.TextInputControl","javafx.util.converter.FormatStringConverter",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Bidi","/Controls/Text/Inset Text","/Controls/Button/Graphic Button","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/Text Field","/Controls/Text/TextFlow","/Controls/Text/Text Validator",},"/ensemble/samples/controls/text/textformatter/TextFormatterApp.java",new PlaygroundProperty[]{new PlaygroundProperty(null,"price","min","0","max","10000"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_68 = new SampleInfo("Text Validator","A sample that demonstrates text validation. If the value in the TextField is a small number, the field becomes yellow. If the value in the TextField is not a number, the field becomes red. ","/Controls/Text/Text Validator","/ensemble/samples/controls/text/textvalidator","ensemble.samples.controls.text.textvalidator.TextValidatorApp","/ensemble/samples/controls/text/textvalidator/preview.png",new String[]{"/ensemble/samples/controls/text/textvalidator/TextInputValidatorPane.java","/ensemble/samples/controls/text/textvalidator/TextValidatorApp.java","/ensemble/samples/controls/text/textvalidator/ValidationEvent.java","/ensemble/samples/controls/text/textvalidator/ValidationResult.java","/ensemble/samples/controls/text/textvalidator/Validator.java","/ensemble/samples/controls/text/textvalidator/ValidatorPane.java","/ensemble/samples/controls/text/textvalidator/Validators.css",},new String[]{"javafx.scene.control.TextField",},new String[]{"http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734","Using JavaFX Text",},new String[]{"/Controls/Text/Advanced Label","/Controls/Text/Bidi","/Controls/Text/Inset Text","/Controls/Text/Search Box","/Controls/Text/Simple Label","/Controls/Text/TextFlow","/Controls/Text/Text Field","/Controls/Text/Text Formatter",},"/ensemble/samples/controls/text/textvalidator/TextValidatorApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_69 = new SampleInfo("Styled Tool Bar","A sample that shows three ToolBars, two of which are styled specifically with a separate CSS style sheet. ","/Controls/Toolbar/Styled Tool Bar","/ensemble/samples/controls/toolbar/styledtoolbar","ensemble.samples.controls.toolbar.styledtoolbar.StyledToolBarApp","/ensemble/samples/controls/toolbar/styledtoolbar/preview.png",new String[]{"/ensemble/samples/controls/toolbar/styledtoolbar/StyledToolBarApp.java","/ensemble/samples/controls/toolbar/styledtoolbar/StyledToolBar.css",},new String[]{"javafx.scene.control.Button","javafx.scene.control.Slider","javafx.scene.control.ToolBar",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Media/Advanced Media","/Controls/Toolbar/Tool Bar",},"/ensemble/samples/controls/toolbar/styledtoolbar/StyledToolBarApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_70 = new SampleInfo("Tool Bar","A toolbar with three buttons. ","/Controls/Toolbar/Tool Bar","/ensemble/samples/controls/toolbar/toolbar","ensemble.samples.controls.toolbar.toolbar.ToolBarApp","/ensemble/samples/controls/toolbar/toolbar/preview.png",new String[]{"/ensemble/samples/controls/toolbar/toolbar/ToolBarApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.ToolBar",},new String[]{"http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336","Using JavaFX UI Controls",},new String[]{"/Media/Advanced Media","/Layout/BorderPane","/Controls/Toolbar/Styled Tool Bar",},"/ensemble/samples/controls/toolbar/toolbar/ToolBarApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_71 = new SampleInfo("Bouncing Balls","A sample that shows animated bouncing balls. Select a ball to start or stop the animation. Select the reset button to stop all the balls. ","/Graphics 2d/Bouncing Balls","/ensemble/samples/graphics2d/bouncingballs","ensemble.samples.graphics2d.bouncingballs.BouncingBallsApp","/ensemble/samples/graphics2d/bouncingballs/preview.png",new String[]{"/ensemble/samples/graphics2d/bouncingballs/Ball.java","/ensemble/samples/graphics2d/bouncingballs/BallsPane.java","/ensemble/samples/graphics2d/bouncingballs/BallsScreen.java","/ensemble/samples/graphics2d/bouncingballs/BouncingBallsApp.java","/ensemble/samples/graphics2d/bouncingballs/Constants.java",},new String[]{"javafx.animation.Animation.Status","javafx.animation.Interpolator","javafx.animation.Timeline","javafx.scene.effect.Reflection","javafx.scene.shape.Circle","javafx.scene.shape.Line","javafx.scene.paint.Color","javafx.scene.paint.CycleMethod","javafx.scene.paint.RadialGradient","javafx.scene.paint.Stop",},new String[]{},new String[]{"/Graphics 2d/Effects/Reflection","/Graphics 2d/Shapes/Circle","/Animation/Interpolator",},"/ensemble/samples/graphics2d/bouncingballs/BouncingBallsApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_72 = new SampleInfo("Brick Breaker","The main purpose of the game is to break all the bricks and not drop the ball. ","/Graphics 2d/Brick Breaker","/ensemble/samples/graphics2d/brickbreaker","ensemble.samples.graphics2d.brickbreaker.BrickBreakerApp","/ensemble/samples/graphics2d/brickbreaker/preview.png",new String[]{"/ensemble/samples/graphics2d/brickbreaker/Ball.java","/ensemble/samples/graphics2d/brickbreaker/Bat.java","/ensemble/samples/graphics2d/brickbreaker/Bonus.java","/ensemble/samples/graphics2d/brickbreaker/Brick.java","/ensemble/samples/graphics2d/brickbreaker/BrickBreakerApp.java","/ensemble/samples/shared-resources/brickImages/background.png","/ensemble/samples/shared-resources/brickImages/bat/left.png","/ensemble/samples/shared-resources/brickImages/bat/center.png","/ensemble/samples/shared-resources/brickImages/bat/right.png","/ensemble/samples/shared-resources/brickImages/ball/ball0.png","/ensemble/samples/shared-resources/brickImages/ball/ball1.png","/ensemble/samples/shared-resources/brickImages/ball/ball2.png","/ensemble/samples/shared-resources/brickImages/ball/ball3.png","/ensemble/samples/shared-resources/brickImages/ball/ball4.png","/ensemble/samples/shared-resources/brickImages/ball/ball5.png","/ensemble/samples/shared-resources/brickImages/logo.png","/ensemble/samples/shared-resources/brickImages/splash/brick.png","/ensemble/samples/shared-resources/brickImages/splash/brickshadow.png","/ensemble/samples/shared-resources/brickImages/splash/breaker.png","/ensemble/samples/shared-resources/brickImages/splash/breakershadow.png","/ensemble/samples/shared-resources/brickImages/splash/pressanykey.png","/ensemble/samples/shared-resources/brickImages/splash/pressanykeyshadow.png","/ensemble/samples/shared-resources/brickImages/splash/strike.png","/ensemble/samples/shared-resources/brickImages/splash/strikeshadow.png","/ensemble/samples/shared-resources/brickImages/splash/sun.png","/ensemble/samples/shared-resources/brickImages/ready.png","/ensemble/samples/shared-resources/brickImages/gameover.png","/ensemble/samples/shared-resources/brickImages/brick/blue.png","/ensemble/samples/shared-resources/brickImages/brick/broken1.png","/ensemble/samples/shared-resources/brickImages/brick/broken2.png","/ensemble/samples/shared-resources/brickImages/brick/brown.png","/ensemble/samples/shared-resources/brickImages/brick/cyan.png","/ensemble/samples/shared-resources/brickImages/brick/green.png","/ensemble/samples/shared-resources/brickImages/brick/grey.png","/ensemble/samples/shared-resources/brickImages/brick/magenta.png","/ensemble/samples/shared-resources/brickImages/brick/orange.png","/ensemble/samples/shared-resources/brickImages/brick/red.png","/ensemble/samples/shared-resources/brickImages/brick/violet.png","/ensemble/samples/shared-resources/brickImages/brick/white.png","/ensemble/samples/shared-resources/brickImages/brick/yellow.png","/ensemble/samples/shared-resources/brickImages/bonus/ballslow.png","/ensemble/samples/shared-resources/brickImages/bonus/ballfast.png","/ensemble/samples/shared-resources/brickImages/bonus/catch.png","/ensemble/samples/shared-resources/brickImages/bonus/batgrow.png","/ensemble/samples/shared-resources/brickImages/bonus/batreduce.png","/ensemble/samples/shared-resources/brickImages/bonus/ballgrow.png","/ensemble/samples/shared-resources/brickImages/bonus/ballreduce.png","/ensemble/samples/shared-resources/brickImages/bonus/strike.png","/ensemble/samples/shared-resources/brickImages/bonus/extralife.png","/ensemble/samples/graphics2d/brickbreaker/Config.java","/ensemble/samples/shared-resources/brickImages/vline.png","/ensemble/samples/graphics2d/brickbreaker/Level.java","/ensemble/samples/graphics2d/brickbreaker/LevelData.java","/ensemble/samples/graphics2d/brickbreaker/Splash.java","/ensemble/samples/graphics2d/brickbreaker/Utils.java",},new String[]{"javafx.animation.KeyFrame","javafx.animation.KeyValue","javafx.animation.Timeline","javafx.collections.ObservableList","javafx.geometry.Rectangle2D","javafx.geometry.VPos","javafx.scene.image.Image","javafx.scene.image.ImageView","javafx.util.Duration",},new String[]{},new String[]{"/Graphics 2d/Images/Image Creation",},"/ensemble/samples/graphics2d/brickbreaker/BrickBreakerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_73 = new SampleInfo("Calculator","A calculator that performs simple math exercises. ","/Graphics 2d/Calculator","/ensemble/samples/graphics2d/calc","ensemble.samples.graphics2d.calc.CalculatorApp","/ensemble/samples/graphics2d/calc/preview.png",new String[]{"/ensemble/samples/graphics2d/calc/Calculator.java","/ensemble/samples/graphics2d/calc/CalculatorApp.java","/ensemble/samples/graphics2d/calc/Key.java","/ensemble/samples/graphics2d/calc/Util.java",},new String[]{"javafx.scene.input.KeyEvent","javafx.scene.input.MouseEvent","javafx.scene.paint.Color","javafx.scene.paint.CycleMethod","javafx.scene.paint.LinearGradient","javafx.scene.paint.Stop","javafx.scene.shape.Rectangle","javafx.scene.text.Font","javafx.scene.text.Text",},new String[]{},new String[]{"/Graphics 2d/Brick Breaker","/Graphics 2d/Paints/Linear Gradient",},"/ensemble/samples/graphics2d/calc/CalculatorApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_74 = new SampleInfo("Canvas Fireworks","A sample that demonstrates how to draw and paint shapes, apply visual effects, blend colors in overlapping objects, and animate objects. ","/Graphics 2d/Canvas Fireworks","/ensemble/samples/graphics2d/canvas","ensemble.samples.graphics2d.canvas.FireworksApp","/ensemble/samples/graphics2d/canvas/preview.png",new String[]{"/ensemble/samples/graphics2d/canvas/FireworksApp.java","/ensemble/samples/graphics2d/canvas/Particle.java","/ensemble/samples/shared-resources/sf.jpg","/ensemble/samples/graphics2d/canvas/SanFranciscoFireworks.java",},new String[]{"javafx.scene.canvas.Canvas","javafx.scene.canvas.GraphicsContext","javafx.scene.effect.BlendMode","javafx.scene.effect.Reflection","javafx.scene.image.ImageView","javafx.scene.paint.Color","javafx.scene.paint.CycleMethod","javafx.scene.paint.Paint","javafx.scene.paint.RadialGradient",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/canvas.htm#JFXGR214","Using JavaFX Canvas",},new String[]{"/Graphics 2d/Colorful Circles",},"/ensemble/samples/graphics2d/canvas/FireworksApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_75 = new SampleInfo("Colorful Circles","A sample that demonstrates how to draw and paint shapes, apply visual effects, blend colors in overlapping objects, and animate objects. ","/Graphics 2d/Colorful Circles","/ensemble/samples/graphics2d/colorfulcircles","ensemble.samples.graphics2d.colorfulcircles.ColorfulCirclesApp","/ensemble/samples/graphics2d/colorfulcircles/preview.png",new String[]{"/ensemble/samples/graphics2d/colorfulcircles/ColorfulCirclesApp.java",},new String[]{"javafx.animation.Timeline","javafx.scene.Group","javafx.scene.effect.BlendMode","javafx.scene.effect.BoxBlur","javafx.scene.paint.Color","javafx.scene.paint.CycleMethod","javafx.scene.paint.LinearGradient","javafx.scene.shape.Circle",},new String[]{},new String[]{"/Graphics 2d/Canvas Fireworks","/Graphics 2d/Effects/Gaussian Blur",},"/ensemble/samples/graphics2d/colorfulcircles/ColorfulCirclesApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_76 = new SampleInfo("Digital Clock","A digital clock application that demonstrates JavaFX animation, images, and effects. ","/Graphics 2d/Digital Clock","/ensemble/samples/graphics2d/digitalclock","ensemble.samples.graphics2d.digitalclock.DigitalClockApp","/ensemble/samples/graphics2d/digitalclock/preview.png",new String[]{"/ensemble/samples/graphics2d/digitalclock/Clock.java","/ensemble/samples/graphics2d/digitalclock/Digit.java","/ensemble/samples/shared-resources/DigitalClock-background.png","/ensemble/samples/graphics2d/digitalclock/DigitalClockApp.java",},new String[]{"javafx.scene.effect.Glow","javafx.scene.effect.InnerShadow","javafx.scene.shape.Polygon","javafx.scene.transform.Shear",},new String[]{},new String[]{"/Graphics 2d/Effects/Gaussian Blur","/Graphics 2d/Effects/Inner Shadow",},"/ensemble/samples/graphics2d/digitalclock/DigitalClockApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_77 = new SampleInfo("Display Shelf","A display shelf of images using the PerspectiveTransform effect. ","/Graphics 2d/Display Shelf","/ensemble/samples/graphics2d/displayshelf","ensemble.samples.graphics2d.displayshelf.DisplayShelfApp","/ensemble/samples/graphics2d/displayshelf/preview.png",new String[]{"/ensemble/samples/graphics2d/displayshelf/DisplayShelf.java","/ensemble/samples/shared-resources/Animal1.jpg","/ensemble/samples/shared-resources/Animal2.jpg","/ensemble/samples/shared-resources/Animal3.jpg","/ensemble/samples/shared-resources/Animal4.jpg","/ensemble/samples/shared-resources/Animal5.jpg","/ensemble/samples/shared-resources/Animal6.jpg","/ensemble/samples/shared-resources/Animal7.jpg","/ensemble/samples/shared-resources/Animal8.jpg","/ensemble/samples/shared-resources/Animal9.jpg","/ensemble/samples/shared-resources/Animal10.jpg","/ensemble/samples/shared-resources/Animal11.jpg","/ensemble/samples/shared-resources/Animal12.jpg","/ensemble/samples/shared-resources/Animal13.jpg","/ensemble/samples/shared-resources/Animal14.jpg","/ensemble/samples/graphics2d/displayshelf/DisplayShelfApp.java","/ensemble/samples/graphics2d/displayshelf/PerspectiveImage.java","/ensemble/samples/graphics2d/displayshelf/DisplayShelf.css",},new String[]{"javafx.scene.control.ScrollBar","javafx.scene.effect.PerspectiveTransform","javafx.scene.effect.Reflection","javafx.scene.input.KeyEvent","javafx.scene.input.MouseEvent",},new String[]{},new String[]{"/Graphics 2d/Bouncing Balls","/Graphics 2d/Effects/Reflection",},"/ensemble/samples/graphics2d/displayshelf/DisplayShelfApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_78 = new SampleInfo("Speed Gauge","A sample that demonstrates a simple gauge. ","/Graphics 2d/Speed Gauge","/ensemble/samples/graphics2d/gauge","ensemble.samples.graphics2d.gauge.SpeedGaugeApp","/ensemble/samples/graphics2d/gauge/preview.png",new String[]{"/ensemble/samples/shared-resources/gaugeBackground.png","/ensemble/samples/shared-resources/needle.png","/ensemble/samples/graphics2d/gauge/SpeedGaugeApp.java",},new String[]{"javafx.scene.image.Image","javafx.scene.image.ImageView",},new String[]{},new String[]{},"/ensemble/samples/graphics2d/gauge/SpeedGaugeApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_79 = new SampleInfo("Puzzle Pieces","A sample in which an image is broken into pieces to create a jigsaw puzzle. ","/Graphics 2d/Puzzle Pieces","/ensemble/samples/graphics2d/puzzle","ensemble.samples.graphics2d.puzzle.PuzzlePiecesApp","/ensemble/samples/graphics2d/puzzle/preview.png",new String[]{"/ensemble/samples/graphics2d/puzzle/Desk.java","/ensemble/samples/graphics2d/puzzle/Piece.java","/ensemble/samples/shared-resources/PuzzlePieces-picture.jpg","/ensemble/samples/graphics2d/puzzle/PuzzlePiecesApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.effect.DropShadow","javafx.scene.image.Image","javafx.scene.image.ImageView","javafx.scene.layout.Pane","javafx.scene.shape.Path",},new String[]{},new String[]{"/Graphics 2d/Effects/Drop Shadow","/Scenegraph/Events/Key Stroke Motion","/Scenegraph/Events/Multi-Touch","/Graphics 2d/Stopwatch",},"/ensemble/samples/graphics2d/puzzle/PuzzlePiecesApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_80 = new SampleInfo("Stopwatch","An animated stopwatch. Click the green button to start the stopwatch and click the red button to stop it. ","/Graphics 2d/Stopwatch","/ensemble/samples/graphics2d/stopwatch","ensemble.samples.graphics2d.stopwatch.StopWatchApp","/ensemble/samples/graphics2d/stopwatch/preview.png",new String[]{"/ensemble/samples/graphics2d/stopwatch/Dial.java","/ensemble/samples/graphics2d/stopwatch/DigitalClock.java","/ensemble/samples/graphics2d/stopwatch/StopWatchApp.java","/ensemble/samples/graphics2d/stopwatch/StopWatchButton.java","/ensemble/samples/shared-resources/stopwatch.png","/ensemble/samples/graphics2d/stopwatch/Watch.java",},new String[]{"javafx.scene.effect.DropShadow","javafx.scene.effect.GaussianBlur","javafx.scene.effect.Lighting","javafx.scene.image.ImageView","javafx.scene.shape.Circle","javafx.scene.shape.Ellipse","javafx.scene.text.Text","javafx.scene.text.TextAlignment","javafx.scene.text.TextBoundsType","javafx.scene.transform.Rotate",},new String[]{},new String[]{"/Scenegraph/Advanced Stage","/Graphics 2d/Shapes/Circle","/Graphics 2d/Effects/Drop Shadow","/Graphics 2d/Effects/Gaussian Blur","/Animation/Timeline","/Graphics 3d/Xylophone","/Graphics 3d/3D Sphere",},"/ensemble/samples/graphics2d/stopwatch/StopWatchApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_81 = new SampleInfo("Drop Shadow","A sample that demonstrates how a drop shadow effect is affected by various settings. ","/Graphics 2d/Effects/Drop Shadow","/ensemble/samples/graphics2d/effects/dropshadow","ensemble.samples.graphics2d.effects.dropshadow.DropShadowApp","/ensemble/samples/graphics2d/effects/dropshadow/preview.png",new String[]{"/ensemble/samples/graphics2d/effects/dropshadow/DropShadowApp.java",},new String[]{"javafx.scene.effect.DropShadow","javafx.scene.effect.Effect","javafx.scene.layout.StackPane",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/visual_effects.htm#JFXTE191","JavaFX Visual Effects",},new String[]{"/Graphics 2d/Effects/Gaussian Blur","/Graphics 2d/Effects/Inner Shadow","/Graphics 2d/Effects/Reflection","/Graphics 2d/Effects/Sepia Tone",},"/ensemble/samples/graphics2d/effects/dropshadow/DropShadowApp.java",new PlaygroundProperty[]{new PlaygroundProperty("dropShadow","radius","min","0","max","20","name","Drop Shadow Radius"),new PlaygroundProperty("dropShadow","offsetX","min","-10","max","10","name","Drop Shadow Offset X"),new PlaygroundProperty("dropShadow","offsetY","min","-10","max","10","name","Drop Shadow Offset Y"),new PlaygroundProperty("dropShadow","spread","min","0","max","1","name","Drop Shadow Spread"),new PlaygroundProperty("dropShadow","color","name","Drop Shadow Color"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_82 = new SampleInfo("Gaussian Blur","A sample that demonstrates a Gaussian blur effect on an image, with varying degrees of blurriness. ","/Graphics 2d/Effects/Gaussian Blur","/ensemble/samples/graphics2d/effects/gaussianblur","ensemble.samples.graphics2d.effects.gaussianblur.GaussianBlurApp","/ensemble/samples/graphics2d/effects/gaussianblur/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/graphics2d/effects/gaussianblur/GaussianBlurApp.java",},new String[]{"javafx.scene.effect.GaussianBlur","javafx.scene.effect.Effect",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/visual_effects.htm#JFXTE191","JavaFX Visual Effects",},new String[]{"/Graphics 2d/Effects/Drop Shadow","/Graphics 2d/Effects/Inner Shadow","/Graphics 2d/Effects/Reflection","/Graphics 2d/Effects/Sepia Tone",},"/ensemble/samples/graphics2d/effects/gaussianblur/GaussianBlurApp.java",new PlaygroundProperty[]{new PlaygroundProperty("gaussianBlur","radius","min","0","max","15","name","Gaussian Blur Level"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_83 = new SampleInfo("Inner Shadow","A sample that demonstrates how an inner shadow effect is affected by various settings. ","/Graphics 2d/Effects/Inner Shadow","/ensemble/samples/graphics2d/effects/innershadow","ensemble.samples.graphics2d.effects.innershadow.InnerShadowApp","/ensemble/samples/graphics2d/effects/innershadow/preview.png",new String[]{"/ensemble/samples/graphics2d/effects/innershadow/InnerShadowApp.java",},new String[]{"javafx.scene.effect.InnerShadow","javafx.scene.effect.Effect","javafx.scene.layout.StackPane",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/visual_effects.htm#JFXTE191","JavaFX Visual Effects",},new String[]{"/Graphics 2d/Digital Clock","/Graphics 2d/Effects/Drop Shadow","/Graphics 2d/Effects/Gaussian Blur","/Graphics 2d/Effects/Reflection","/Graphics 2d/Effects/Sepia Tone",},"/ensemble/samples/graphics2d/effects/innershadow/InnerShadowApp.java",new PlaygroundProperty[]{new PlaygroundProperty("sample","fill","name","Text Fill"),new PlaygroundProperty("innerShadow","radius","min","0","max","20","name","Inner Shadow Radius"),new PlaygroundProperty("innerShadow","offsetX","min","-10","max","10","name","Inner Shadow Offset X"),new PlaygroundProperty("innerShadow","offsetY","min","-10","max","10","name","Inner Shadow Offset Y"),new PlaygroundProperty("innerShadow","color","name","Inner Shadow Color"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_84 = new SampleInfo("Reflection","A sample that demonstrates how a reflection effect is affected by various settings. ","/Graphics 2d/Effects/Reflection","/ensemble/samples/graphics2d/effects/reflection","ensemble.samples.graphics2d.effects.reflection.ReflectionApp","/ensemble/samples/graphics2d/effects/reflection/preview.png",new String[]{"/ensemble/samples/shared-resources/boat.jpg","/ensemble/samples/graphics2d/effects/reflection/ReflectionApp.java",},new String[]{"javafx.scene.effect.Reflection","javafx.scene.effect.Effect",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/visual_effects.htm#JFXTE191","JavaFX Visual Effects",},new String[]{"/Graphics 2d/Bouncing Balls","/Graphics 2d/Canvas Fireworks","/Graphics 2d/Display Shelf","/Graphics 2d/Effects/Drop Shadow","/Graphics 2d/Effects/Gaussian Blur","/Graphics 2d/Effects/Inner Shadow","/Graphics 2d/Effects/Sepia Tone",},"/ensemble/samples/graphics2d/effects/reflection/ReflectionApp.java",new PlaygroundProperty[]{new PlaygroundProperty("reflection","bottomOpacity","min","0","max","1","name","Reflection Bottom Opacity"),new PlaygroundProperty("reflection","topOpacity","min","0","max","1","name","Reflection Top Opacity"),new PlaygroundProperty("reflection","fraction","min","0","max","1","name","Reflection Fraction"),new PlaygroundProperty("reflection","topOffset","min","-10","max","10","name","Reflection Top Offset"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_85 = new SampleInfo("Sepia Tone","A sample that demonstrates varying degrees of a sepia tone effect. ","/Graphics 2d/Effects/Sepia Tone","/ensemble/samples/graphics2d/effects/sepiatone","ensemble.samples.graphics2d.effects.sepiatone.SepiaToneApp","/ensemble/samples/graphics2d/effects/sepiatone/preview.png",new String[]{"/ensemble/samples/shared-resources/boat.jpg","/ensemble/samples/graphics2d/effects/sepiatone/SepiaToneApp.java",},new String[]{"javafx.scene.effect.SepiaTone","javafx.scene.effect.Effect",},new String[]{"http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/visual_effects.htm#JFXTE191","JavaFX Visual Effects",},new String[]{"/Graphics 2d/Effects/Drop Shadow","/Graphics 2d/Effects/Gaussian Blur","/Graphics 2d/Effects/Inner Shadow","/Graphics 2d/Effects/Reflection",},"/ensemble/samples/graphics2d/effects/sepiatone/SepiaToneApp.java",new PlaygroundProperty[]{new PlaygroundProperty("sepiaTone","level","min","0","max","1","name","SepiaTone Level"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_86 = new SampleInfo("Image Creation","A sample that demonstrates the use of two different constructors in the Image class. ","/Graphics 2d/Images/Image Creation","/ensemble/samples/graphics2d/images/imagecreation","ensemble.samples.graphics2d.images.imagecreation.ImageCreationApp","/ensemble/samples/graphics2d/images/imagecreation/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/graphics2d/images/imagecreation/ImageCreationApp.java",},new String[]{"javafx.scene.image.Image","javafx.scene.image.ImageView",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/image_ops.htm#JFXGR238","JavaFX Image Operations",},new String[]{"/Graphics 2d/Images/Image Operation","/Graphics 2d/Images/Image Properties",},"/ensemble/samples/graphics2d/images/imagecreation/ImageCreationApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_87 = new SampleInfo("Image Operation","A sample that demonstrates the use of two different constructors in the Image class. ","/Graphics 2d/Images/Image Operation","/ensemble/samples/graphics2d/images/imageoperator","ensemble.samples.graphics2d.images.imageoperator.ImageOperationApp","/ensemble/samples/graphics2d/images/imageoperator/preview.png",new String[]{"/ensemble/samples/graphics2d/images/imageoperator/ImageOperationApp.java",},new String[]{"javafx.scene.image.Image","javafx.scene.image.ImageView","javafx.scene.image.PixelWriter","javafx.scene.image.WritableImage",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/image_ops.htm#JFXGR238","JavaFX Image Operations",},new String[]{"/Graphics 2d/Images/Image Creation","/Graphics 2d/Images/Image Properties",},"/ensemble/samples/graphics2d/images/imageoperator/ImageOperationApp.java",new PlaygroundProperty[]{new PlaygroundProperty(null,"gridSize","min","0","max","10","name","Grid Size"),new PlaygroundProperty(null,"hueFactor","min","0","max","32","name","Hue Factor"),new PlaygroundProperty(null,"hueOffset","min","0","max","360","name","Hue Offset"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_88 = new SampleInfo("Image Properties","A sample that demonstrates how to resize images and use the Viewport property. ","/Graphics 2d/Images/Image Properties","/ensemble/samples/graphics2d/images/imageproperties","ensemble.samples.graphics2d.images.imageproperties.ImagePropertiesApp","/ensemble/samples/graphics2d/images/imageproperties/preview.png",new String[]{"/ensemble/samples/shared-resources/sanfran.jpg","/ensemble/samples/graphics2d/images/imageproperties/ImagePropertiesApp.java",},new String[]{"javafx.scene.image.Image","javafx.scene.image.ImageView",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/image_ops.htm#JFXGR238","JavaFX Image Operations",},new String[]{"/Graphics 2d/Images/Image Creation","/Graphics 2d/Images/Image Operation",},"/ensemble/samples/graphics2d/images/imageproperties/ImagePropertiesApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_89 = new SampleInfo("Color","Rectangles filled with colors. ","/Graphics 2d/Paints/Color","/ensemble/samples/graphics2d/paints/color","ensemble.samples.graphics2d.paints.color.ColorApp","/ensemble/samples/graphics2d/paints/color/preview.png",new String[]{"/ensemble/samples/graphics2d/paints/color/ColorApp.java",},new String[]{"javafx.scene.paint.Color","javafx.scene.paint.Paint","javafx.scene.shape.Shape",},new String[]{},new String[]{"/Graphics 2d/Paints/Linear Gradient","/Graphics 2d/Paints/Radial Gradient",},"/ensemble/samples/graphics2d/paints/color/ColorApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_90 = new SampleInfo("Linear Gradient","A sample with two rectangles, one filled with a simple linear gradient and one filled with a more complex gradient using the reflection cycle method. ","/Graphics 2d/Paints/Linear Gradient","/ensemble/samples/graphics2d/paints/lineargradient","ensemble.samples.graphics2d.paints.lineargradient.LinearGradientApp","/ensemble/samples/graphics2d/paints/lineargradient/preview.png",new String[]{"/ensemble/samples/graphics2d/paints/lineargradient/LinearGradientApp.java",},new String[]{"javafx.scene.paint.Color","javafx.scene.paint.LinearGradient","javafx.scene.paint.Paint","javafx.scene.shape.Shape",},new String[]{},new String[]{"/Graphics 2d/Paints/Color","/Graphics 2d/Paints/Radial Gradient",},"/ensemble/samples/graphics2d/paints/lineargradient/LinearGradientApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_91 = new SampleInfo("Radial Gradient","A sample that demonstrates two circles, one filled with a simple radial gradient and one filled with a more complex radial gradient. ","/Graphics 2d/Paints/Radial Gradient","/ensemble/samples/graphics2d/paints/radialgradient","ensemble.samples.graphics2d.paints.radialgradient.RadialGradientApp","/ensemble/samples/graphics2d/paints/radialgradient/preview.png",new String[]{"/ensemble/samples/graphics2d/paints/radialgradient/RadialGradientApp.java",},new String[]{"javafx.scene.paint.Color","javafx.scene.paint.Paint","javafx.scene.paint.RadialGradient","javafx.scene.shape.Shape",},new String[]{},new String[]{"/Graphics 2d/Paints/Color","/Graphics 2d/Paints/Linear Gradient",},"/ensemble/samples/graphics2d/paints/radialgradient/RadialGradientApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_92 = new SampleInfo("Arc","A sample that demonstrates how various settings affect a line shape. ","/Graphics 2d/Shapes/Arc","/ensemble/samples/graphics2d/shapes/arc","ensemble.samples.graphics2d.shapes.arc.ArcApp","/ensemble/samples/graphics2d/shapes/arc/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/arc/ArcApp.java",},new String[]{"javafx.scene.shape.Arc","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/arc/ArcApp.java",new PlaygroundProperty[]{new PlaygroundProperty("arc1","fill","name","Arc1 Fill"),new PlaygroundProperty("arc1","startAngle","min","0","max","360","name","Arc 1 Start Angle"),new PlaygroundProperty("arc1","length","min","0","max","360","name","Arc 1 Length"),new PlaygroundProperty("arc2","stroke","name","Arc 2 Stroke"),new PlaygroundProperty("arc2","strokeWidth","min","0","max","5","name","Arc 2 Stroke Width"),new PlaygroundProperty("arc2","radiusX","min","0","max","50","name","Arc 2 Radius X"),new PlaygroundProperty("arc2","radiusY","min","0","max","50","name","Arc 2 Radius Y"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_93 = new SampleInfo("Circle","A sample showing two circles with controls to change fill, stroke, and radius. ","/Graphics 2d/Shapes/Circle","/ensemble/samples/graphics2d/shapes/circle","ensemble.samples.graphics2d.shapes.circle.CircleApp","/ensemble/samples/graphics2d/shapes/circle/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/circle/CircleApp.java",},new String[]{"javafx.scene.shape.Circle","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/circle/CircleApp.java",new PlaygroundProperty[]{new PlaygroundProperty("circle1","fill","name","Circle 1 Fill"),new PlaygroundProperty("circle1","radius","min","10","max","40","name","Circle 1 Radius"),new PlaygroundProperty("circle2","stroke","name","Circle 1 Stroke"),new PlaygroundProperty("circle2","strokeWidth","min","1","max","5","name","Circle 2 Stroke Width"),new PlaygroundProperty("circle2","radius","min","10","max","40","name","Circle 2 Radius"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_94 = new SampleInfo("Cubic Curve","A sample showing how various settings change a cubic Bézier parametric curve. ","/Graphics 2d/Shapes/Cubic Curve","/ensemble/samples/graphics2d/shapes/cubiccurve","ensemble.samples.graphics2d.shapes.cubiccurve.CubicCurveApp","/ensemble/samples/graphics2d/shapes/cubiccurve/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/cubiccurve/CubicCurveApp.java",},new String[]{"javafx.scene.shape.CubicCurve","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/cubiccurve/CubicCurveApp.java",new PlaygroundProperty[]{new PlaygroundProperty("cubicCurve","fill","name","Cubic Curve Fill"),new PlaygroundProperty("cubicCurve","stroke","name","Cubic Curve Stroke"),new PlaygroundProperty("cubicCurve","startX","min","0","max","170","name","Cubic Curve Start X"),new PlaygroundProperty("cubicCurve","startY","min","10","max","80","name","Cubic Curve Start Y"),new PlaygroundProperty("cubicCurve","controlX1","min","0","max","180","name","Cubic Curve Control X1"),new PlaygroundProperty("cubicCurve","controlY1","min","0","max","90","name","Cubic Curve Control Y1"),new PlaygroundProperty("cubicCurve","controlX2","min","0","max","180","name","Cubic Curve Control X2"),new PlaygroundProperty("cubicCurve","controlY2","min","0","max","90","name","Cubic Curve Control Y2"),new PlaygroundProperty("cubicCurve","endX","min","10","max","180","name","Cubic Curve End X"),new PlaygroundProperty("cubicCurve","endY","min","0","max","80","name","Cubic Curve End Y"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_95 = new SampleInfo("Ellipse","A sample that demonstrates how various settings affect two elliptical shapes. ","/Graphics 2d/Shapes/Ellipse","/ensemble/samples/graphics2d/shapes/ellipse","ensemble.samples.graphics2d.shapes.ellipse.EllipseApp","/ensemble/samples/graphics2d/shapes/ellipse/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/ellipse/EllipseApp.java",},new String[]{"javafx.scene.shape.Ellipse","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/ellipse/EllipseApp.java",new PlaygroundProperty[]{new PlaygroundProperty("ellipse1","fill","name","Ellipse 1 Fill"),new PlaygroundProperty("ellipse1","radiusX","min","10","max","40","name","Ellipse 1 Width"),new PlaygroundProperty("ellipse1","radiusY","min","10","max","45","name","Ellipse 1 Height"),new PlaygroundProperty("ellipse2","stroke","name","Ellipse 2 Stroke"),new PlaygroundProperty("ellipse2","strokeWidth","min","1","max","5","name","Ellipse 2 Stroke Width"),new PlaygroundProperty("ellipse2","radiusX","min","10","max","40","name","Ellipse 2 Width"),new PlaygroundProperty("ellipse2","radiusY","min","10","max","45","name","Ellipse 2 Height"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_96 = new SampleInfo("Line","A sample that demonstrates how various settings affect a line shape. ","/Graphics 2d/Shapes/Line","/ensemble/samples/graphics2d/shapes/line","ensemble.samples.graphics2d.shapes.line.LineApp","/ensemble/samples/graphics2d/shapes/line/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/line/LineApp.java",},new String[]{"javafx.scene.shape.Line","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/line/LineApp.java",new PlaygroundProperty[]{new PlaygroundProperty("exampleLine","startX","min","50","max","550"),new PlaygroundProperty("exampleLine","startY","min","50","max","350"),new PlaygroundProperty("exampleLine","endX","min","50","max","550"),new PlaygroundProperty("exampleLine","endY","min","50","max","350"),new PlaygroundProperty("exampleLine","stroke"),new PlaygroundProperty("exampleLine","strokeWidth","min","0.1","max","50"),new PlaygroundProperty("exampleLine","strokeLineCap"),new PlaygroundProperty("exampleLine","getStrokeDashArray"),new PlaygroundProperty("exampleLine","strokeDashOffset","min","0","max","500"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_97 = new SampleInfo("Path","A sample that demonstrates two path shapes. ","/Graphics 2d/Shapes/Path","/ensemble/samples/graphics2d/shapes/path","ensemble.samples.graphics2d.shapes.path.PathApp","/ensemble/samples/graphics2d/shapes/path/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/path/PathApp.java",},new String[]{"javafx.scene.shape.ArcTo","javafx.scene.shape.ClosePath","javafx.scene.shape.CubicCurveTo","javafx.scene.shape.HLineTo","javafx.scene.shape.LineTo","javafx.scene.shape.MoveTo","javafx.scene.shape.QuadCurveTo","javafx.scene.shape.VLineTo","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/path/PathApp.java",new PlaygroundProperty[]{new PlaygroundProperty("path1","stroke","name","Path 1 Stroke"),new PlaygroundProperty("path2","stroke","name","Path 2 Stroke"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_98 = new SampleInfo("Polygon","A sample that demonstrates polygon construction. ","/Graphics 2d/Shapes/Polygon","/ensemble/samples/graphics2d/shapes/polygon","ensemble.samples.graphics2d.shapes.polygon.PolygonApp","/ensemble/samples/graphics2d/shapes/polygon/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/polygon/PolygonApp.java",},new String[]{"javafx.scene.shape.Polygon","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/polygon/PolygonApp.java",new PlaygroundProperty[]{new PlaygroundProperty("polygon1","fill","name","Polygon 1 Fill"),new PlaygroundProperty("polygon2","stroke","name","Polygon 2 Stroke"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_99 = new SampleInfo("Polyline","A sample that demonstrates polyline construction with stroke and fill. ","/Graphics 2d/Shapes/Polyline","/ensemble/samples/graphics2d/shapes/polyline","ensemble.samples.graphics2d.shapes.polyline.PolylineApp","/ensemble/samples/graphics2d/shapes/polyline/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/polyline/PolylineApp.java",},new String[]{"javafx.scene.shape.Polyline","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Quad Curve","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/polyline/PolylineApp.java",new PlaygroundProperty[]{new PlaygroundProperty("polyline1","fill","name","Polyline 1 Fill"),new PlaygroundProperty("polyline1","stroke","name","Polyline 1 Stroke"),new PlaygroundProperty("polyline2","stroke","name","Polyline 2 Stroke"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_100 = new SampleInfo("Quad Curve","An example of how various settings affect a quadratic Bézier parametric curve. ","/Graphics 2d/Shapes/Quad Curve","/ensemble/samples/graphics2d/shapes/quadcurve","ensemble.samples.graphics2d.shapes.quadcurve.QuadCurveApp","/ensemble/samples/graphics2d/shapes/quadcurve/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/quadcurve/QuadCurveApp.java",},new String[]{"javafx.scene.layout.Region","javafx.scene.shape.QuadCurve","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Rectangle",},"/ensemble/samples/graphics2d/shapes/quadcurve/QuadCurveApp.java",new PlaygroundProperty[]{new PlaygroundProperty("quadCurve","fill","name","Quad Curve Fill"),new PlaygroundProperty("quadCurve","stroke","name","Quad Curve Stroke"),new PlaygroundProperty("quadCurve","startX","min","0","max","170","name","Quad Curve Start X"),new PlaygroundProperty("quadCurve","startY","min","10","max","80","name","Quad Curve Start Y"),new PlaygroundProperty("quadCurve","controlX","min","0","max","180","name","Quad Curve Control X"),new PlaygroundProperty("quadCurve","controlY","min","0","max","90","name","Quad Curve Control Y"),new PlaygroundProperty("quadCurve","endX","min","10","max","180","name","Quad Curve End X"),new PlaygroundProperty("quadCurve","endY","min","10","max","80","name","Quad Curve End Y"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_101 = new SampleInfo("Rectangle","A sample showing how various settings effect two rectangles. ","/Graphics 2d/Shapes/Rectangle","/ensemble/samples/graphics2d/shapes/rectangle","ensemble.samples.graphics2d.shapes.rectangle.RectangleApp","/ensemble/samples/graphics2d/shapes/rectangle/preview.png",new String[]{"/ensemble/samples/graphics2d/shapes/rectangle/RectangleApp.java",},new String[]{"javafx.scene.shape.Rectangle","javafx.scene.shape.Shape","javafx.scene.paint.Color",},new String[]{},new String[]{"/Graphics 2d/Shapes/Arc","/Graphics 2d/Shapes/Circle","/Graphics 2d/Shapes/Cubic Curve","/Graphics 2d/Shapes/Ellipse","/Graphics 2d/Shapes/Line","/Graphics 2d/Shapes/Path","/Graphics 2d/Shapes/Polygon","/Graphics 2d/Shapes/Polyline","/Graphics 2d/Shapes/Quad Curve",},"/ensemble/samples/graphics2d/shapes/rectangle/RectangleApp.java",new PlaygroundProperty[]{new PlaygroundProperty("rect1","fill","name","Rectangle 1 Fill"),new PlaygroundProperty("rect1","width","min","10","max","50","name","Rectangle 1 Width"),new PlaygroundProperty("rect1","height","min","10","max","50","name","Rectangle 1 Height"),new PlaygroundProperty("rect1","arcWidth","min","0","max","50","name","Rectangle 1 Arc Width"),new PlaygroundProperty("rect1","arcHeight","min","0","max","50","name","Rectangle 1 Arc Height"),new PlaygroundProperty("rect2","stroke","name","Rectangle 2 Stroke"),new PlaygroundProperty("rect2","strokeWidth","min","1","max","5","name","Rectangle 2 Stroke Width"),new PlaygroundProperty("rect2","width","min","10","max","50","name","Rectangle 2 Width"),new PlaygroundProperty("rect2","height","min","10","max","50","name","Rectangle 2 Height"),new PlaygroundProperty("rect2","arcWidth","min","0","max","50","name","Rectangle 2 Arc Width"),new PlaygroundProperty("rect2","arcHeight","min","0","max","50","name","Rectangle 2 Arc Height"),},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_102 = new SampleInfo("3D Cubes","A sample that demonstrates an animated rotation of 3D cubes. ","/Graphics 3d/3D Cubes","/ensemble/samples/graphics3d/cube","ensemble.samples.graphics3d.cube.CubeApp","/ensemble/samples/graphics3d/cube/preview.png",new String[]{"/ensemble/samples/graphics3d/cube/Cube.java","/ensemble/samples/graphics3d/cube/CubeApp.java",},new String[]{"javafx.scene.PerspectiveCamera","javafx.scene.SubScene","javafx.scene.SceneAntialiasing","javafx.scene.paint.Color","javafx.scene.paint.PhongMaterial","javafx.scene.shape.Box","javafx.scene.transform.Rotate","javafx.scene.transform.Translate",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/javafx-3d-graphics.htm#JFXGR256","JavaFX 3D Graphics",},new String[]{"/Graphics 3d/Xylophone","/Graphics 3d/3D Box","/Graphics 3d/3D Sphere","/Graphics 3d/3D Sphere System",},"/ensemble/samples/graphics3d/cube/CubeApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.SCENE3D,},false);
    private static final SampleInfo SAMPLE_103 = new SampleInfo("3D Sphere System","A sample that demonstrates an animated rotation of 3D spheres. ","/Graphics 3d/3D Sphere System","/ensemble/samples/graphics3d/cubesystem","ensemble.samples.graphics3d.cubesystem.SphereSystemApp","/ensemble/samples/graphics3d/cubesystem/preview.png",new String[]{"/ensemble/samples/graphics3d/cubesystem/Cube.java","/ensemble/samples/graphics3d/cubesystem/SphereSystemApp.java","/ensemble/samples/graphics3d/cubesystem/Xform.java","/ensemble/samples/graphics3d/cubesystem/Xsphere.java",},new String[]{"javafx.animation.KeyFrame","javafx.animation.Timeline","javafx.scene.PerspectiveCamera","javafx.scene.SceneAntialiasing","javafx.scene.paint.Color","javafx.scene.paint.PhongMaterial","javafx.scene.shape.Sphere","javafx.scene.transform.Rotate","javafx.scene.transform.Translate",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/javafx-3d-graphics.htm#JFXGR256","JavaFX 3D Graphics",},new String[]{"/Graphics 3d/Xylophone","/Graphics 3d/3D Box","/Graphics 3d/3D Cubes","/Graphics 3d/3D Sphere",},"/ensemble/samples/graphics3d/cubesystem/SphereSystemApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.SCENE3D,},false);
    private static final SampleInfo SAMPLE_104 = new SampleInfo("3D Box","A sample that shows a 3D box and uses a perspective camera for rendering the scene. Explore: Switch to Line draw mode to see how cullFace property works. ","/Graphics 3d/3D Box","/ensemble/samples/graphics3d/simple3dbox","ensemble.samples.graphics3d.simple3dbox.Simple3DBoxApp","/ensemble/samples/graphics3d/simple3dbox/preview.png",new String[]{"/ensemble/samples/graphics3d/simple3dbox/Simple3DBoxApp.java",},new String[]{"javafx.scene.PerspectiveCamera","javafx.scene.SceneAntialiasing","javafx.scene.SubScene","javafx.scene.paint.Color","javafx.scene.paint.PhongMaterial","javafx.scene.shape.Box","javafx.scene.transform.Rotate","javafx.scene.transform.Translate",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/javafx-3d-graphics.htm#JFXGR256","JavaFX 3D Graphics",},new String[]{"/Graphics 3d/Xylophone","/Graphics 3d/3D Cubes","/Graphics 3d/3D Sphere","/Graphics 3d/3D Sphere System",},"/ensemble/samples/graphics3d/simple3dbox/Simple3DBoxApp.java",new PlaygroundProperty[]{new PlaygroundProperty("testBox","drawMode"),new PlaygroundProperty("testBox","cullFace"),new PlaygroundProperty("material","diffuseColor"),},new ConditionalFeature[]{ConditionalFeature.SCENE3D,},false);
    private static final SampleInfo SAMPLE_105 = new SampleInfo("3D Sphere","A sample that demonstrates features of PhongMaterial applied to a 3D Sphere. Provided is a playground to exercise the following properties of material: diffuse map and color, specular map, color and power, bump map, self illumination map. ","/Graphics 3d/3D Sphere","/ensemble/samples/graphics3d/sphere","ensemble.samples.graphics3d.sphere.Simple3DSphereApp","/ensemble/samples/graphics3d/sphere/preview.png",new String[]{"/ensemble/samples/graphics3d/sphere/Simple3DSphereApp.java","/ensemble/samples/graphics3d/sphere/earth-d.jpg","/ensemble/samples/graphics3d/sphere/earth-l.jpg","/ensemble/samples/graphics3d/sphere/earth-n.jpg","/ensemble/samples/graphics3d/sphere/earth-s.jpg",},new String[]{"javafx.scene.AmbientLight","javafx.scene.PerspectiveCamera","javafx.scene.PointLight","javafx.scene.SceneAntialiasing","javafx.scene.paint.PhongMaterial","javafx.scene.shape.Sphere","javafx.scene.transform.Rotate",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/javafx-3d-graphics.htm#JFXGR256","JavaFX 3D Graphics",},new String[]{"/Graphics 3d/Xylophone","/Graphics 3d/3D Box","/Graphics 3d/3D Cubes","/Graphics 3d/3D Sphere System",},"/ensemble/samples/graphics3d/sphere/Simple3DSphereApp.java",new PlaygroundProperty[]{new PlaygroundProperty(null,"-","name","Material"),new PlaygroundProperty("material","diffuseColor"),new PlaygroundProperty(null,"diffuseMap"),new PlaygroundProperty("material","specularColor"),new PlaygroundProperty(null,"specularMap"),new PlaygroundProperty("material","specularPower","min","0","max","64"),new PlaygroundProperty(null,"bumpMap"),new PlaygroundProperty(null,"selfIlluminationMap"),new PlaygroundProperty(null,"-","name","Light"),new PlaygroundProperty("sun","color"),new PlaygroundProperty(null,"sunLight"),new PlaygroundProperty(null,"sunDistance","min","5","max","150"),new PlaygroundProperty(null,"-","name","Sphere"),new PlaygroundProperty("earth","drawMode"),new PlaygroundProperty("earth","cullFace"),},new ConditionalFeature[]{ConditionalFeature.SCENE3D,},false);
    private static final SampleInfo SAMPLE_106 = new SampleInfo("Xylophone","A sample that demonstrates a xylophone made of 3D cubes. It is animated and plays sounds when clicked. ","/Graphics 3d/Xylophone","/ensemble/samples/graphics3d/xylophone","ensemble.samples.graphics3d.xylophone.XylophoneApp","/ensemble/samples/graphics3d/xylophone/preview.png",new String[]{"/ensemble/samples/graphics3d/xylophone/Xform.java","/ensemble/samples/shared-resources/Note1.wav","/ensemble/samples/shared-resources/Note2.wav","/ensemble/samples/shared-resources/Note3.wav","/ensemble/samples/shared-resources/Note4.wav","/ensemble/samples/shared-resources/Note5.wav","/ensemble/samples/shared-resources/Note6.wav","/ensemble/samples/shared-resources/Note7.wav","/ensemble/samples/shared-resources/Note8.wav","/ensemble/samples/graphics3d/xylophone/XylophoneApp.java",},new String[]{"javafx.scene.PerspectiveCamera","javafx.scene.SceneAntialiasing","javafx.scene.SubScene","javafx.scene.input.MouseEvent","javafx.scene.media.AudioClip","javafx.scene.paint.PhongMaterial","javafx.scene.shape.Box","javafx.scene.transform.Rotate","javafx.scene.transform.Scale",},new String[]{"http://docs.oracle.com/javase/8/javafx/graphics-tutorial/javafx-3d-graphics.htm#JFXGR256","JavaFX 3D Graphics",},new String[]{"/Graphics 3d/3D Box","/Graphics 3d/3D Cubes","/Graphics 3d/3D Sphere","/Graphics 3d/3D Sphere System",},"/ensemble/samples/graphics3d/xylophone/XylophoneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.SCENE3D,},false);
    private static final SampleInfo SAMPLE_107 = new SampleInfo("ChangeListener","A sample that demonstrates how to add or remove a change listener on a node (for example, a Rectangle node) for some property (for example, Rectangle.hover). Once you add a listener, the text field  shows the hover property change. ","/Language/ChangeListener","/ensemble/samples/language/changelistener","ensemble.samples.language.changelistener.ChangeListenerApp","/ensemble/samples/language/changelistener/preview.png",new String[]{"/ensemble/samples/language/changelistener/ChangeListenerApp.java",},new String[]{"javafx.beans.InvalidationListener","javafx.beans.value.ChangeListener","javafx.beans.value.ObservableValue",},new String[]{},new String[]{"/Scenegraph/Advanced Stage","/Animation/Interpolator","/Graphics 2d/Stopwatch",},"/ensemble/samples/language/changelistener/ChangeListenerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_108 = new SampleInfo("FXML Login Demo","FXML-based Login screen sample ","/Language/FXML Login Demo","/ensemble/samples/language/fxml","ensemble.samples.language.fxml.FXMLLoginDemoApp","/ensemble/samples/language/fxml/preview.png",new String[]{"/ensemble/samples/language/fxml/Authenticator.java","/ensemble/samples/language/fxml/FXMLLoginDemoApp.java","/ensemble/samples/language/fxml/LoginController.java","/ensemble/samples/language/fxml/ProfileController.java","/ensemble/samples/language/fxml/User.java","/ensemble/samples/language/fxml/Login.css","/ensemble/samples/language/fxml/Login.fxml","/ensemble/samples/language/fxml/Profile.fxml",},new String[]{"javafx.fxml.FXML","javafx.fxml.FXMLLoader","javafx.fxml.Initializable","javafx.fxml.JavaFXBuilderFactory",},new String[]{"http://docs.oracle.com/javase/8/javafx/fxml-tutorial/why_use_fxml.htm#JFXMG137","JavaFX UI with FXML",},new String[]{"/Language/String Binding",},"/ensemble/samples/language/fxml/FXMLLoginDemoApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_109 = new SampleInfo("ObservableList","A sample that demonstrates the ObservableList interface, which extends the java.util.List interface. Click the button to change an integer to a new random number in a random position in the list. Once you add a listener, the index of the changed number is displayed above the buttons. ","/Language/ObservableList","/ensemble/samples/language/observablelist","ensemble.samples.language.observablelist.ObservableListApp","/ensemble/samples/language/observablelist/preview.png",new String[]{"/ensemble/samples/language/observablelist/ObservableListApp.java",},new String[]{"javafx.beans.value.ChangeListener","javafx.collections.FXCollections","javafx.collections.ListChangeListener","javafx.collections.ObservableList",},new String[]{},new String[]{"/Controls/Button/Colored Buttons","/Scenegraph/Events/KeyEvent",},"/ensemble/samples/language/observablelist/ObservableListApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_110 = new SampleInfo("String Binding","A sample that demonstrates how to bind text properties so the value of the bound property is updated automatically when the value of the original property is changed. ","/Language/String Binding","/ensemble/samples/language/stringbinding","ensemble.samples.language.stringbinding.StringBindingApp","/ensemble/samples/language/stringbinding/preview.png",new String[]{"/ensemble/samples/language/stringbinding/StringBindingApp.java",},new String[]{"javafx.beans.binding.StringBinding","javafx.scene.control.TextField","javafx.scene.control.Label",},new String[]{"http://docs.oracle.com/javase/8/javafx/properties-binding-tutorial/binding.htm#JFXBD107","JavaFX Properties and Binding",},new String[]{"/Controls/Progress Indicator","/Language/SwingInterop",},"/ensemble/samples/language/stringbinding/StringBindingApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_111 = new SampleInfo("SwingInterop","A sample that invokes SwingInterop to run in a separate JVM.  SwingInterop shows how to embed JavaFX components, like Chart and WebView components, in a Swing application. ","/Language/SwingInterop","/ensemble/samples/language/swing","ensemble.samples.language.swing.SwingInteropApp","/ensemble/samples/language/swing/preview.png",new String[]{"/ensemble/samples/language/swing/SampleTableModel.java","/ensemble/samples/language/swing/SwingInterop.java","/ensemble/samples/language/swing/SwingInteropApp.java","/ensemble/samples/language/swing/SwingInteropService.java","/ensemble/samples/language/swing/SwingInteropTask.java",},new String[]{"javafx.scene.chart.BarChart","javafx.scene.chart.CategoryAxis","javafx.scene.chart.Chart","javafx.scene.chart.NumberAxis","javafx.scene.chart.XYChart","javafx.scene.web.WebEngine","javafx.scene.web.WebView",},new String[]{"http://docs.oracle.com/javase/8/javafx/interoperability-tutorial/fx_swing.htm#JFXIP561","JavaFX-Swing Interoperability",},new String[]{"/Charts/Scatter/Scatter Chart","/Charts/Bar/Stacked Bar Chart","/Language/String Binding","/Controls/WebView",},"/ensemble/samples/language/swing/SwingInteropApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.SWING,},false);
    private static final SampleInfo SAMPLE_112 = new SampleInfo("Service","A sample showing use of a Service to retrieve data in a background thread. Selecting the Refresh button restarts the Service. ","/Language/Concurrency/Service","/ensemble/samples/language/concurrency/service","ensemble.samples.language.concurrency.service.ServiceApp","/ensemble/samples/language/concurrency/service/preview.png",new String[]{"/ensemble/samples/language/concurrency/service/DailySales.java","/ensemble/samples/language/concurrency/service/GetDailySalesService.java","/ensemble/samples/language/concurrency/service/GetDailySalesTask.java","/ensemble/samples/language/concurrency/service/ServiceApp.java",},new String[]{"javafx.collections.FXCollections","javafx.concurrent.Service","javafx.concurrent.Task","javafx.scene.control.ProgressIndicator","javafx.scene.control.TableColumn","javafx.scene.control.TableView",},new String[]{"http://docs.oracle.com/javase/8/javafx/interoperability-tutorial/concurrency.htm#JFXIP546","Concurrency in JavaFX",},new String[]{"/Controls/Progress Indicator","/Controls/TableView","/Language/Concurrency/Task",},"/ensemble/samples/language/concurrency/service/ServiceApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_113 = new SampleInfo("Task","A sample showing use of an an asynchronous Task to populate a table. ","/Language/Concurrency/Task","/ensemble/samples/language/concurrency/task","ensemble.samples.language.concurrency.task.TaskApp","/ensemble/samples/language/concurrency/task/preview.png",new String[]{"/ensemble/samples/language/concurrency/task/DailySales.java","/ensemble/samples/language/concurrency/task/GetDailySalesTask.java","/ensemble/samples/language/concurrency/task/TaskApp.java",},new String[]{"javafx.collections.FXCollections","javafx.concurrent.Task","javafx.scene.control.ProgressIndicator","javafx.scene.control.TableColumn","javafx.scene.control.TableView",},new String[]{"http://docs.oracle.com/javase/8/javafx/interoperability-tutorial/concurrency.htm#JFXIP546","Concurrency in JavaFX",},new String[]{"/Controls/Progress Indicator","/Controls/TableView","/Language/Concurrency/Service",},"/ensemble/samples/language/concurrency/task/TaskApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_114 = new SampleInfo("AnchorPane","A simple example of an AnchorPane layout. ","/Layout/AnchorPane","/ensemble/samples/layout/anchorpane","ensemble.samples.layout.anchorpane.AnchorPaneApp","/ensemble/samples/layout/anchorpane/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/layout/anchorpane/AnchorPaneApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.Label","javafx.scene.layout.AnchorPane","javafx.scene.image.ImageView",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/BorderPane","/Layout/FlowPane","/Layout/GridPane","/Layout/HBox","/Graphics 2d/Images/Image Creation","/Controls/Text/Simple Label","/Layout/StackPane","/Layout/TilePane","/Layout/VBox",},"/ensemble/samples/layout/anchorpane/AnchorPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_115 = new SampleInfo("BorderPane","An example of  a BorderPane layout, with placement of children in the top, left, center, right, and bottom positions. ","/Layout/BorderPane","/ensemble/samples/layout/borderpane","ensemble.samples.layout.borderpane.BorderPaneApp","/ensemble/samples/layout/borderpane/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/layout/borderpane/BorderPaneApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.Label","javafx.scene.control.ToolBar","javafx.scene.image.ImageView","javafx.scene.layout.BorderPane",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/FlowPane","/Layout/GridPane","/Layout/HBox","/Graphics 2d/Images/Image Creation","/Controls/Text/Simple Label","/Layout/StackPane","/Layout/TilePane","/Layout/VBox",},"/ensemble/samples/layout/borderpane/BorderPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_116 = new SampleInfo("FlowPane","A simple example of a FlowPane layout. ","/Layout/FlowPane","/ensemble/samples/layout/flowpane","ensemble.samples.layout.flowpane.FlowPaneApp","/ensemble/samples/layout/flowpane/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/shared-resources/icon-68x68.png","/ensemble/samples/shared-resources/icon-88x88.png","/ensemble/samples/layout/flowpane/FlowPaneApp.java",},new String[]{"javafx.scene.image.ImageView","javafx.scene.layout.FlowPane",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/BorderPane","/Layout/GridPane","/Layout/HBox","/Graphics 2d/Images/Image Creation","/Layout/StackPane","/Layout/TilePane","/Layout/VBox",},"/ensemble/samples/layout/flowpane/FlowPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_117 = new SampleInfo("GridPane","An example of a GridPane layout. There is more than one approach to using a GridPane. The code can specify which rows and/or columns should contain the content. Alternatively, the code can alter the constraints of the rows and/or columns themselves, either by specifying the preferred minimum or  maximum heights or widths, or by specifying the percentage of the GridPane that belongs to certain rows or columns.  Note that grid lines can be made visible to help in debugging. ","/Layout/GridPane","/ensemble/samples/layout/gridpane","ensemble.samples.layout.gridpane.GridPaneApp","/ensemble/samples/layout/gridpane/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/layout/gridpane/GridPaneApp.java",},new String[]{"javafx.scene.control.Label","javafx.scene.layout.ColumnConstraints","javafx.scene.layout.GridPane","javafx.scene.layout.RowConstraints",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/BorderPane","/Layout/FlowPane","/Layout/HBox","/Controls/Text/Simple Label","/Layout/StackPane","/Layout/TilePane","/Layout/VBox",},"/ensemble/samples/layout/gridpane/GridPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_118 = new SampleInfo("HBox","A simple example of an HBox layout. ","/Layout/HBox","/ensemble/samples/layout/hbox","ensemble.samples.layout.hbox.HBoxApp","/ensemble/samples/layout/hbox/preview.png",new String[]{"/ensemble/samples/layout/hbox/HBoxApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.control.Label","javafx.scene.control.TextField","javafx.scene.layout.HBox",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/BorderPane","/Layout/FlowPane","/Layout/GridPane","/Layout/StackPane","/Controls/Text/Text Field","/Layout/TilePane","/Layout/VBox",},"/ensemble/samples/layout/hbox/HBoxApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_119 = new SampleInfo("StackPane","A simple example of a StackPane layout. ","/Layout/StackPane","/ensemble/samples/layout/stackpane","ensemble.samples.layout.stackpane.StackPaneApp","/ensemble/samples/layout/stackpane/preview.png",new String[]{"/ensemble/samples/layout/stackpane/StackPaneApp.java",},new String[]{"javafx.scene.layout.StackPane","javafx.scene.shape.Ellipse","javafx.scene.shape.Rectangle",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/BorderPane","/Layout/FlowPane","/Layout/GridPane","/Layout/HBox","/Layout/TilePane","/Layout/VBox",},"/ensemble/samples/layout/stackpane/StackPaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_120 = new SampleInfo("TilePane","An example of a TilePane layout. ","/Layout/TilePane","/ensemble/samples/layout/tilepane","ensemble.samples.layout.tilepane.TilePaneApp","/ensemble/samples/layout/tilepane/preview.png",new String[]{"/ensemble/samples/shared-resources/icon-48x48.png","/ensemble/samples/layout/tilepane/TilePaneApp.java",},new String[]{"javafx.scene.control.Button","javafx.scene.image.ImageView","javafx.scene.layout.TilePane",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/BorderPane","/Layout/FlowPane","/Layout/GridPane","/Layout/HBox","/Graphics 2d/Images/Image Creation","/Layout/StackPane","/Layout/VBox",},"/ensemble/samples/layout/tilepane/TilePaneApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_121 = new SampleInfo("VBox","A simple example of a VBox layout. ","/Layout/VBox","/ensemble/samples/layout/vbox","ensemble.samples.layout.vbox.VBoxApp","/ensemble/samples/layout/vbox/preview.png",new String[]{"/ensemble/samples/layout/vbox/VBoxApp.java",},new String[]{"javafx.scene.control.CheckBox","javafx.scene.control.Label","javafx.scene.layout.VBox",},new String[]{"http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html","JavaFX Layouts",},new String[]{"/Layout/AnchorPane","/Layout/BorderPane","/Layout/FlowPane","/Layout/GridPane","/Layout/HBox","/Layout/StackPane","/Layout/TilePane",},"/ensemble/samples/layout/vbox/VBoxApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_122 = new SampleInfo("Advanced Media","An advanced media player with controls for play/pause, seek, and volume. ","/Media/Advanced Media","/ensemble/samples/media/advancedmedia","ensemble.samples.media.advancedmedia.AdvancedMediaApp","/ensemble/samples/media/advancedmedia/preview.png",new String[]{"/ensemble/samples/media/advancedmedia/AdvancedMediaApp.java","/ensemble/samples/shared-resources/playbutton.png","/ensemble/samples/shared-resources/pausebutton.png","/ensemble/samples/media/advancedmedia/MediaControl.java",},new String[]{"javafx.scene.media.Media","javafx.scene.media.MediaPlayer",},new String[]{"http://docs.oracle.com/javase/8/javafx/media-tutorial/overview.htm#JFXMD101","Using JavaFX Media",},new String[]{"/Media/Alpha Media Player","/Media/Overlay Media Player","/Media/Streaming Media Player",},"/ensemble/samples/media/advancedmedia/AdvancedMediaApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,ConditionalFeature.MEDIA,},false);
    private static final SampleInfo SAMPLE_124 = new SampleInfo("Audio Clip","A sample that demonstrates the basics of AudioClips. ","/Media/Audio Clip","/ensemble/samples/media/audioclip","ensemble.samples.media.audioclip.AudioClipApp","/ensemble/samples/media/audioclip/preview.png",new String[]{"/ensemble/samples/shared-resources/Note1.wav","/ensemble/samples/shared-resources/Note2.wav","/ensemble/samples/shared-resources/Note3.wav","/ensemble/samples/shared-resources/Note4.wav","/ensemble/samples/shared-resources/Note5.wav","/ensemble/samples/shared-resources/Note6.wav","/ensemble/samples/shared-resources/Note7.wav","/ensemble/samples/shared-resources/Note8.wav","/ensemble/samples/media/audioclip/AudioClipApp.java",},new String[]{"javafx.scene.layout.StackPane","javafx.scene.media.AudioClip",},new String[]{"http://docs.oracle.com/javase/8/javafx/media-tutorial/overview.htm#JFXMD101","Using JavaFX Media",},new String[]{"/Media/Alpha Media Player","/Media/Overlay Media Player","/Media/Streaming Media Player","/Graphics 3d/Xylophone",},"/ensemble/samples/media/audioclip/AudioClipApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,ConditionalFeature.MEDIA,},false);
    private static final SampleInfo SAMPLE_125 = new SampleInfo("Overlay Media Player","A media player with controls for play, pause, stop, seek, and volume. This media player also demonstrates overlaying the player controls on top of the media. ","/Media/Overlay Media Player","/ensemble/samples/media/overlaymediaplayer","ensemble.samples.media.overlaymediaplayer.OverlayMediaPlayerApp","/ensemble/samples/media/overlaymediaplayer/preview.png",new String[]{"/ensemble/samples/media/overlaymediaplayer/OverlayMediaPlayerApp.java","/ensemble/samples/media/overlaymediaplayer/PlayerPane.java","/ensemble/samples/media/overlaymediaplayer/OverlayMediaPlayer.css",},new String[]{"javafx.scene.media.MediaPlayer","javafx.scene.media.Media",},new String[]{"http://docs.oracle.com/javase/8/javafx/media-tutorial/overview.htm#JFXMD101","Using JavaFX Media",},new String[]{"/Media/Alpha Media Player","/Media/Overlay Media Player","/Media/Streaming Media Player",},"/ensemble/samples/media/overlaymediaplayer/OverlayMediaPlayerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,ConditionalFeature.MEDIA,},false);
    private static final SampleInfo SAMPLE_126 = new SampleInfo("Streaming Media Player","A media player with controls for play, pause, stop, seek, and volume. This media player is playing media via HTTP Live Streaming, also known as HLS. ","/Media/Streaming Media Player","/ensemble/samples/media/streamingmediaplayer","ensemble.samples.media.streamingmediaplayer.StreamingMediaPlayerApp","/ensemble/samples/media/streamingmediaplayer/preview.png",new String[]{"/ensemble/samples/media/streamingmediaplayer/PlayerPane.java","/ensemble/samples/media/streamingmediaplayer/StreamingMediaPlayerApp.java","/ensemble/samples/media/streamingmediaplayer/StreamingMediaPlayer.css",},new String[]{"javafx.scene.media.MediaPlayer","javafx.scene.media.Media",},new String[]{"http://docs.oracle.com/javase/8/javafx/media-tutorial/overview.htm#JFXMD101","Using JavaFX Media",},new String[]{"/Media/Advanced Media","/Media/Alpha Media Player","/Media/Overlay Media Player",},"/ensemble/samples/media/streamingmediaplayer/StreamingMediaPlayerApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{ConditionalFeature.WEB,ConditionalFeature.MEDIA,},false);
    private static final SampleInfo SAMPLE_127 = new SampleInfo("Advanced Stage","A sample with a control that creates a transparent stage that is centered on your desktop. You can drag the stage with your mouse or use the scene controls to minimize or close it. With a transparent stage, you must add your own event handlers to perform these actions. ","/Scenegraph/Advanced Stage","/ensemble/samples/scenegraph/advancedstage","ensemble.samples.scenegraph.advancedstage.AdvancedStageApp","/ensemble/samples/scenegraph/advancedstage/preview.png",new String[]{"/ensemble/samples/scenegraph/advancedstage/AdvancedStageApp.java",},new String[]{"javafx.scene.paint.Color","javafx.scene.paint.RadialGradient","javafx.stage.StageStyle",},new String[]{},new String[]{"/Animation/Interpolator","/Graphics 2d/Paints/Radial Gradient","/Scenegraph/Stage",},"/ensemble/samples/scenegraph/advancedstage/AdvancedStageApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_128 = new SampleInfo("Custom Node","A sample that demonstrates how to create a custom node by extending the Parent class. ","/Scenegraph/Custom Node","/ensemble/samples/scenegraph/customnode","ensemble.samples.scenegraph.customnode.CustomNodeApp","/ensemble/samples/scenegraph/customnode/preview.png",new String[]{"/ensemble/samples/scenegraph/customnode/CustomNodeApp.java","/ensemble/samples/scenegraph/customnode/MyNode.java",},new String[]{"javafx.scene.Group","javafx.scene.Parent","javafx.scene.shape.Polygon",},new String[]{},new String[]{"/Scenegraph/Events/Key Stroke Motion","/Scenegraph/Node Properties","/Graphics 2d/Shapes/Polygon","/Scenegraph/Stage",},"/ensemble/samples/scenegraph/customnode/CustomNodeApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_129 = new SampleInfo("Node Properties","A sample that demonstrates some properties of nodes. Use the controls to change opacity or horizontal position. ","/Scenegraph/Node Properties","/ensemble/samples/scenegraph/nodeproperties","ensemble.samples.scenegraph.nodeproperties.NodePropertiesApp","/ensemble/samples/scenegraph/nodeproperties/preview.png",new String[]{"/ensemble/samples/scenegraph/nodeproperties/NodePropertiesApp.java",},new String[]{"javafx.scene.Node","javafx.scene.layout.Pane","javafx.scene.paint.Color","javafx.scene.shape.Rectangle",},new String[]{},new String[]{"/Scenegraph/Custom Node","/Graphics 2d/Shapes/Rectangle","/Scenegraph/Stage",},"/ensemble/samples/scenegraph/nodeproperties/NodePropertiesApp.java",new PlaygroundProperty[]{new PlaygroundProperty("rectA","translateX","min","0","max","50","name","Rectangle A translate X"),new PlaygroundProperty("rectB","translateX","min","0","max","50","name","Rectangle B translate X"),new PlaygroundProperty("rectC","translateX","min","0","max","50","name","Rectangle C translate X"),new PlaygroundProperty("rectA","opacity","min","0","max","1","name","Rectangle A Opacity"),new PlaygroundProperty("rectB","opacity","min","0","max","1","name","Rectangle B Opacity"),new PlaygroundProperty("rectC","opacity","min","0","max","1","name","Rectangle C Opacity"),},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_130 = new SampleInfo("Stage","A sample with a control that creates a decorated stage that is centered on your desktop. ","/Scenegraph/Stage","/ensemble/samples/scenegraph/stage","ensemble.samples.scenegraph.stage.StageApp","/ensemble/samples/scenegraph/stage/preview.png",new String[]{"/ensemble/samples/scenegraph/stage/StageApp.java",},new String[]{"javafx.scene.Scene","javafx.scene.control.Button","javafx.scene.effect.Lighting","javafx.stage.Stage",},new String[]{},new String[]{"/Scenegraph/Advanced Stage","/Scenegraph/Custom Node","/Controls/Button/Graphic Button",},"/ensemble/samples/scenegraph/stage/StageApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_131 = new SampleInfo("Cursor","A sample that demonstrates changing the cursor icon. ","/Scenegraph/Events/Cursor","/ensemble/samples/scenegraph/events/cursor","ensemble.samples.scenegraph.events.cursor.CursorApp","/ensemble/samples/scenegraph/events/cursor/preview.png",new String[]{"/ensemble/samples/scenegraph/events/cursor/CursorApp.java",},new String[]{"javafx.scene.Cursor","javafx.scene.control.Label","javafx.scene.layout.TilePane",},new String[]{},new String[]{"/Scenegraph/Events/Key Stroke Motion","/Scenegraph/Events/MouseEvent","/Scenegraph/Node Properties","/Graphics 2d/Shapes/Polygon","/Scenegraph/Stage","/Layout/TilePane",},"/ensemble/samples/scenegraph/events/cursor/CursorApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_132 = new SampleInfo("Gesture Event","A sample that demonstrates various multi-touch gesture events and their usage. Tap, scroll and pan to move the rectangle. Use pinch close and open zoom gestures to resize it. User rotate touch gesture to rotate it. Swipe events are reported but not wired to any other behavior. All events are logged to the console. You can also observe inertia scrolling. ","/Scenegraph/Events/Gesture Event","/ensemble/samples/scenegraph/events/gestureevent","ensemble.samples.scenegraph.events.gestureevent.GestureEventApp","/ensemble/samples/scenegraph/events/gestureevent/preview.png",new String[]{"/ensemble/samples/scenegraph/events/gestureevent/GestureEventApp.java",},new String[]{"javafx.scene.control.ListView","javafx.scene.input.RotateEvent","javafx.scene.input.ScrollEvent","javafx.scene.input.SwipeEvent","javafx.scene.input.TouchEvent","javafx.scene.input.ZoomEvent","javafx.scene.shape.Rectangle",},new String[]{"http://docs.oracle.com/javase/8/javafx/events-tutorial/events.htm#JFXED117","JavaFX Events",},new String[]{"/Scenegraph/Events/Key Stroke Motion","/Scenegraph/Events/MouseEvent","/Scenegraph/Events/Multi-Touch",},"/ensemble/samples/scenegraph/events/gestureevent/GestureEventApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_133 = new SampleInfo("KeyEvent","A sample that demonstrates various key events and their usage. Type in the text box to view the triggered events: key pressed, key typed and key released. Pressing the Shift, Ctrl, and Alt keys also trigger events. ","/Scenegraph/Events/KeyEvent","/ensemble/samples/scenegraph/events/keyevent","ensemble.samples.scenegraph.events.keyevent.KeyEventApp","/ensemble/samples/scenegraph/events/keyevent/preview.png",new String[]{"/ensemble/samples/scenegraph/events/keyevent/KeyEventApp.java",},new String[]{"javafx.collections.ListChangeListener","javafx.scene.control.ListView","javafx.scene.input.KeyCode","javafx.scene.input.KeyEvent",},new String[]{"http://docs.oracle.com/javase/8/javafx/events-tutorial/events.htm#JFXED117","JavaFX Events",},new String[]{"/Scenegraph/Events/Key Stroke Motion","/Scenegraph/Events/MouseEvent","/Controls/Listview/Simple ListView",},"/ensemble/samples/scenegraph/events/keyevent/KeyEventApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    private static final SampleInfo SAMPLE_134 = new SampleInfo("Key Stroke Motion","An example of animation generated from key events. Click the grey area to give it focus and try typing letters. ","/Scenegraph/Events/Key Stroke Motion","/ensemble/samples/scenegraph/events/keystrokemotion","ensemble.samples.scenegraph.events.keystrokemotion.KeyStrokeMotionApp","/ensemble/samples/scenegraph/events/keystrokemotion/preview.png",new String[]{"/ensemble/samples/scenegraph/events/keystrokemotion/KeyStrokeMotionApp.java","/ensemble/samples/scenegraph/events/keystrokemotion/LettersPane.java",},new String[]{"javafx.animation.Interpolator","javafx.scene.input.KeyEvent","javafx.scene.input.MouseEvent","javafx.scene.layout.Region",},new String[]{"http://docs.oracle.com/javase/8/javafx/events-tutorial/events.htm#JFXED117","JavaFX Events",},new String[]{"/Graphics 2d/Effects/Drop Shadow","/Animation/Interpolator","/Scenegraph/Events/KeyEvent","/Scenegraph/Events/MouseEvent",},"/ensemble/samples/scenegraph/events/keystrokemotion/KeyStrokeMotionApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_135 = new SampleInfo("MouseEvent","A sample that demonstrates various mouse and scroll events and their usage. Click the circles and drag them across the screen. Scroll the whole screen. All events are logged to the console. ","/Scenegraph/Events/MouseEvent","/ensemble/samples/scenegraph/events/mouseevent","ensemble.samples.scenegraph.events.mouseevent.MouseEventApp","/ensemble/samples/scenegraph/events/mouseevent/preview.png",new String[]{"/ensemble/samples/scenegraph/events/mouseevent/MouseEventApp.java",},new String[]{"javafx.scene.Cursor","javafx.scene.input.MouseEvent","javafx.scene.input.ScrollEvent","javafx.scene.paint.LinearGradient","javafx.scene.paint.RadialGradient","javafx.scene.shape.Circle",},new String[]{"http://docs.oracle.com/javase/8/javafx/events-tutorial/events.htm#JFXED117","JavaFX Events",},new String[]{"/Scenegraph/Events/Cursor","/Scenegraph/Events/Gesture Event","/Scenegraph/Events/KeyEvent","/Scenegraph/Events/Key Stroke Motion","/Scenegraph/Events/Multi-Touch",},"/ensemble/samples/scenegraph/events/mouseevent/MouseEventApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},false);
    private static final SampleInfo SAMPLE_136 = new SampleInfo("Multi-Touch","A sample that demonstrates multi-touch support. You can zoom in and out of the images and also rotate the images with multi-touch. ","/Scenegraph/Events/Multi-Touch","/ensemble/samples/scenegraph/events/multitouch","ensemble.samples.scenegraph.events.multitouch.MultiTouchApp","/ensemble/samples/scenegraph/events/multitouch/preview.png",new String[]{"/ensemble/samples/scenegraph/events/multitouch/MultiTouchApp.java","/ensemble/samples/scenegraph/events/multitouch/MultiTouchImageView.java","/ensemble/samples/shared-resources/warning.png","/ensemble/samples/shared-resources/Animal1.jpg","/ensemble/samples/shared-resources/Animal2.jpg","/ensemble/samples/shared-resources/Animal3.jpg","/ensemble/samples/scenegraph/events/multitouch/MultiTouchPane.java",},new String[]{"javafx.scene.effect.BlurType","javafx.scene.effect.DropShadow","javafx.scene.image.ImageView","javafx.scene.input.MouseEvent","javafx.scene.input.RotateEvent","javafx.scene.input.ZoomEvent","javafx.scene.layout.StackPane","javafx.scene.paint.Color","javafx.scene.shape.Rectangle",},new String[]{"http://docs.oracle.com/javase/8/javafx/events-tutorial/events.htm#JFXED117","JavaFX Events",},new String[]{"/Scenegraph/Events/Cursor","/Scenegraph/Events/Gesture Event","/Scenegraph/Events/KeyEvent","/Scenegraph/Events/Key Stroke Motion",},"/ensemble/samples/scenegraph/events/multitouch/MultiTouchApp.java",new PlaygroundProperty[]{},new ConditionalFeature[]{},true);
    public static final SampleCategory ROOT = new SampleCategory("ROOT",null,null,new SampleCategory[]{new SampleCategory("Animation",new SampleInfo[]{SAMPLE_0,SAMPLE_1,SAMPLE_2,},new SampleInfo[]{SAMPLE_0,SAMPLE_1,SAMPLE_2,SAMPLE_3,SAMPLE_4,SAMPLE_5,SAMPLE_6,SAMPLE_7,SAMPLE_8,SAMPLE_9,SAMPLE_10,SAMPLE_11,SAMPLE_12,},new SampleCategory[]{new SampleCategory("Transitions",new SampleInfo[]{SAMPLE_3,SAMPLE_4,SAMPLE_5,SAMPLE_6,SAMPLE_7,SAMPLE_8,SAMPLE_9,SAMPLE_10,SAMPLE_11,SAMPLE_12,},null,null),}),new SampleCategory("Charts",new SampleInfo[]{SAMPLE_13,SAMPLE_14,},new SampleInfo[]{SAMPLE_15,SAMPLE_16,SAMPLE_17,SAMPLE_18,SAMPLE_19,SAMPLE_20,SAMPLE_21,SAMPLE_22,SAMPLE_23,SAMPLE_13,SAMPLE_14,SAMPLE_24,SAMPLE_25,SAMPLE_26,SAMPLE_27,SAMPLE_28,SAMPLE_29,SAMPLE_30,},new SampleCategory[]{new SampleCategory("Area",new SampleInfo[]{SAMPLE_15,SAMPLE_16,SAMPLE_17,SAMPLE_18,},null,null),new SampleCategory("Bar",new SampleInfo[]{SAMPLE_19,SAMPLE_20,SAMPLE_21,SAMPLE_22,SAMPLE_23,},null,null),new SampleCategory("Line",new SampleInfo[]{SAMPLE_24,SAMPLE_25,SAMPLE_26,},null,null),new SampleCategory("Pie",new SampleInfo[]{SAMPLE_27,SAMPLE_28,},null,null),new SampleCategory("Scatter",new SampleInfo[]{SAMPLE_29,SAMPLE_30,},null,null),}),new SampleCategory("Controls",new SampleInfo[]{SAMPLE_31,SAMPLE_32,SAMPLE_33,SAMPLE_34,SAMPLE_35,SAMPLE_36,SAMPLE_37,SAMPLE_38,SAMPLE_39,SAMPLE_40,SAMPLE_41,SAMPLE_42,SAMPLE_43,SAMPLE_44,SAMPLE_45,SAMPLE_46,SAMPLE_47,SAMPLE_48,SAMPLE_49,SAMPLE_50,SAMPLE_51,SAMPLE_52,SAMPLE_53,},new SampleInfo[]{SAMPLE_31,SAMPLE_54,SAMPLE_55,SAMPLE_56,SAMPLE_32,SAMPLE_33,SAMPLE_34,SAMPLE_35,SAMPLE_36,SAMPLE_37,SAMPLE_38,SAMPLE_57,SAMPLE_58,SAMPLE_59,SAMPLE_39,SAMPLE_40,SAMPLE_41,SAMPLE_42,SAMPLE_43,SAMPLE_44,SAMPLE_45,SAMPLE_46,SAMPLE_47,SAMPLE_48,SAMPLE_49,SAMPLE_60,SAMPLE_61,SAMPLE_62,SAMPLE_63,SAMPLE_64,SAMPLE_65,SAMPLE_66,SAMPLE_67,SAMPLE_68,SAMPLE_50,SAMPLE_69,SAMPLE_70,SAMPLE_51,SAMPLE_52,SAMPLE_53,},new SampleCategory[]{new SampleCategory("Button",new SampleInfo[]{SAMPLE_54,SAMPLE_55,SAMPLE_56,},null,null),new SampleCategory("Listview",new SampleInfo[]{SAMPLE_57,SAMPLE_58,SAMPLE_59,},null,null),new SampleCategory("Text",new SampleInfo[]{SAMPLE_60,SAMPLE_61,SAMPLE_62,SAMPLE_63,SAMPLE_64,SAMPLE_65,SAMPLE_66,SAMPLE_67,SAMPLE_68,},null,null),new SampleCategory("Toolbar",new SampleInfo[]{SAMPLE_69,SAMPLE_70,},null,null),}),new SampleCategory("Graphics 2d",new SampleInfo[]{SAMPLE_71,SAMPLE_72,SAMPLE_73,SAMPLE_74,SAMPLE_75,SAMPLE_76,SAMPLE_77,SAMPLE_78,SAMPLE_79,SAMPLE_80,},new SampleInfo[]{SAMPLE_71,SAMPLE_72,SAMPLE_73,SAMPLE_74,SAMPLE_75,SAMPLE_76,SAMPLE_77,SAMPLE_81,SAMPLE_82,SAMPLE_83,SAMPLE_84,SAMPLE_85,SAMPLE_78,SAMPLE_86,SAMPLE_87,SAMPLE_88,SAMPLE_89,SAMPLE_90,SAMPLE_91,SAMPLE_79,SAMPLE_92,SAMPLE_93,SAMPLE_94,SAMPLE_95,SAMPLE_96,SAMPLE_97,SAMPLE_98,SAMPLE_99,SAMPLE_100,SAMPLE_101,SAMPLE_80,},new SampleCategory[]{new SampleCategory("Effects",new SampleInfo[]{SAMPLE_81,SAMPLE_82,SAMPLE_83,SAMPLE_84,SAMPLE_85,},null,null),new SampleCategory("Images",new SampleInfo[]{SAMPLE_86,SAMPLE_87,SAMPLE_88,},null,null),new SampleCategory("Paints",new SampleInfo[]{SAMPLE_89,SAMPLE_90,SAMPLE_91,},null,null),new SampleCategory("Shapes",new SampleInfo[]{SAMPLE_92,SAMPLE_93,SAMPLE_94,SAMPLE_95,SAMPLE_96,SAMPLE_97,SAMPLE_98,SAMPLE_99,SAMPLE_100,SAMPLE_101,},null,null),}),new SampleCategory("Graphics 3d",new SampleInfo[]{SAMPLE_102,SAMPLE_103,SAMPLE_104,SAMPLE_105,SAMPLE_106,},new SampleInfo[]{SAMPLE_102,SAMPLE_103,SAMPLE_104,SAMPLE_105,SAMPLE_106,},null),new SampleCategory("Language",new SampleInfo[]{SAMPLE_107,SAMPLE_108,SAMPLE_109,SAMPLE_110,SAMPLE_111,},new SampleInfo[]{SAMPLE_107,SAMPLE_112,SAMPLE_113,SAMPLE_108,SAMPLE_109,SAMPLE_110,SAMPLE_111,},new SampleCategory[]{new SampleCategory("Concurrency",new SampleInfo[]{SAMPLE_112,SAMPLE_113,},null,null),}),new SampleCategory("Layout",new SampleInfo[]{SAMPLE_114,SAMPLE_115,SAMPLE_116,SAMPLE_117,SAMPLE_118,SAMPLE_119,SAMPLE_120,SAMPLE_121,},new SampleInfo[]{SAMPLE_114,SAMPLE_115,SAMPLE_116,SAMPLE_117,SAMPLE_118,SAMPLE_119,SAMPLE_120,SAMPLE_121,},null),new SampleCategory("Media",new SampleInfo[]{SAMPLE_122,SAMPLE_124,SAMPLE_125,SAMPLE_126,},new SampleInfo[]{SAMPLE_122,SAMPLE_124,SAMPLE_125,SAMPLE_126,},null),new SampleCategory("Scenegraph",new SampleInfo[]{SAMPLE_127,SAMPLE_128,SAMPLE_129,SAMPLE_130,},new SampleInfo[]{SAMPLE_127,SAMPLE_128,SAMPLE_131,SAMPLE_132,SAMPLE_133,SAMPLE_134,SAMPLE_135,SAMPLE_136,SAMPLE_129,SAMPLE_130,},new SampleCategory[]{new SampleCategory("Events",new SampleInfo[]{SAMPLE_131,SAMPLE_132,SAMPLE_133,SAMPLE_134,SAMPLE_135,SAMPLE_136,},null,null),}),});
    public static final SampleInfo[] HIGHLIGHTS = new SampleInfo[]{SAMPLE_18,SAMPLE_14,SAMPLE_66,SAMPLE_124,};
    private static final HashMap<String,SampleInfo[]> DOCS_URL_TO_SAMPLE = new HashMap<String,SampleInfo[]>(214);
    static {
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.QuadCurveTo",new SampleInfo[]{SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.Transition",new SampleInfo[]{SAMPLE_9,SAMPLE_7,SAMPLE_8,SAMPLE_5,SAMPLE_6,SAMPLE_3,SAMPLE_4,SAMPLE_12,SAMPLE_11,SAMPLE_10,});
        DOCS_URL_TO_SAMPLE.put("https://docs.oracle.com/javafx/2/charts/jfxpub-charts.htm",new SampleInfo[]{SAMPLE_19,SAMPLE_18,SAMPLE_29,SAMPLE_17,SAMPLE_28,SAMPLE_16,SAMPLE_27,SAMPLE_15,SAMPLE_26,SAMPLE_14,SAMPLE_25,SAMPLE_24,SAMPLE_23,SAMPLE_22,SAMPLE_21,SAMPLE_20,SAMPLE_30,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Line",new SampleInfo[]{SAMPLE_71,SAMPLE_96,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.transform.Shear",new SampleInfo[]{SAMPLE_76,});
        DOCS_URL_TO_SAMPLE.put("javafx.collections.ListChangeListener",new SampleInfo[]{SAMPLE_109,SAMPLE_133,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.text.FontPosture",new SampleInfo[]{SAMPLE_66,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.SelectionModel",new SampleInfo[]{SAMPLE_59,SAMPLE_58,SAMPLE_57,});
        DOCS_URL_TO_SAMPLE.put("javafx.geometry.Rectangle2D",new SampleInfo[]{SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("http://www.oracle.com/pls/topic/lookup?ctx=javase80&id=JFXUI336",new SampleInfo[]{SAMPLE_49,SAMPLE_48,SAMPLE_47,SAMPLE_69,SAMPLE_46,SAMPLE_45,SAMPLE_44,SAMPLE_42,SAMPLE_41,SAMPLE_40,SAMPLE_70,SAMPLE_39,SAMPLE_38,SAMPLE_37,SAMPLE_59,SAMPLE_36,SAMPLE_58,SAMPLE_35,SAMPLE_57,SAMPLE_34,SAMPLE_56,SAMPLE_33,SAMPLE_55,SAMPLE_32,SAMPLE_54,SAMPLE_31,SAMPLE_52,SAMPLE_51,SAMPLE_50,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.cell.PropertyValueFactory",new SampleInfo[]{SAMPLE_49,SAMPLE_48,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.canvas.GraphicsContext",new SampleInfo[]{SAMPLE_74,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.transform.Translate",new SampleInfo[]{SAMPLE_104,SAMPLE_103,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Rectangle",new SampleInfo[]{SAMPLE_119,SAMPLE_129,SAMPLE_101,SAMPLE_44,SAMPLE_136,SAMPLE_31,SAMPLE_73,SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.DateCell",new SampleInfo[]{SAMPLE_35,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.Group",new SampleInfo[]{SAMPLE_128,SAMPLE_75,});
        DOCS_URL_TO_SAMPLE.put("javafx.beans.property.BooleanProperty",new SampleInfo[]{SAMPLE_48,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.BubbleChart",new SampleInfo[]{SAMPLE_13,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.Interpolator",new SampleInfo[]{SAMPLE_71,SAMPLE_134,SAMPLE_0,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.TouchEvent",new SampleInfo[]{SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.TranslateTransition",new SampleInfo[]{SAMPLE_12,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.cell.CheckBoxTableCell",new SampleInfo[]{SAMPLE_48,});
        DOCS_URL_TO_SAMPLE.put("javafx.collections.ObservableList",new SampleInfo[]{SAMPLE_109,SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.beans.property.StringProperty",new SampleInfo[]{SAMPLE_48,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.SubScene",new SampleInfo[]{SAMPLE_104,SAMPLE_106,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Path",new SampleInfo[]{SAMPLE_79,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.cell.TextFieldTreeTableCell",new SampleInfo[]{SAMPLE_51,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TreeItem",new SampleInfo[]{SAMPLE_52,SAMPLE_51,});
        DOCS_URL_TO_SAMPLE.put("javafx.collections.FXCollections",new SampleInfo[]{SAMPLE_109,SAMPLE_112,SAMPLE_113,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/animations.htm#JFXTE149",new SampleInfo[]{SAMPLE_9,SAMPLE_7,SAMPLE_8,SAMPLE_5,SAMPLE_6,SAMPLE_3,SAMPLE_4,SAMPLE_12,SAMPLE_1,SAMPLE_11,SAMPLE_2,SAMPLE_10,SAMPLE_0,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TreeTableView",new SampleInfo[]{SAMPLE_51,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ProgressBar",new SampleInfo[]{SAMPLE_41,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/events-tutorial/events.htm#JFXED117",new SampleInfo[]{SAMPLE_134,SAMPLE_133,SAMPLE_136,SAMPLE_135,SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.text.TextAlignment",new SampleInfo[]{SAMPLE_80,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.StrokeTransition",new SampleInfo[]{SAMPLE_11,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/fxml-tutorial/why_use_fxml.htm#JFXMG137",new SampleInfo[]{SAMPLE_108,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/layout-tutorial/index.html",new SampleInfo[]{SAMPLE_119,SAMPLE_116,SAMPLE_115,SAMPLE_118,SAMPLE_117,SAMPLE_114,SAMPLE_121,SAMPLE_120,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.image.ImageView",new SampleInfo[]{SAMPLE_60,SAMPLE_80,SAMPLE_116,SAMPLE_115,SAMPLE_38,SAMPLE_79,SAMPLE_78,SAMPLE_55,SAMPLE_88,SAMPLE_114,SAMPLE_136,SAMPLE_87,SAMPLE_64,SAMPLE_86,SAMPLE_74,SAMPLE_40,SAMPLE_72,SAMPLE_120,});
        DOCS_URL_TO_SAMPLE.put("javafx.beans.value.ObservableValue",new SampleInfo[]{SAMPLE_107,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.image.Image",new SampleInfo[]{SAMPLE_60,SAMPLE_79,SAMPLE_78,SAMPLE_88,SAMPLE_87,SAMPLE_64,SAMPLE_86,SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.event.EventHandler",new SampleInfo[]{SAMPLE_2,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.ClosePath",new SampleInfo[]{SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TextInputControl",new SampleInfo[]{SAMPLE_67,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.Glow",new SampleInfo[]{SAMPLE_76,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.VBox",new SampleInfo[]{SAMPLE_60,SAMPLE_37,SAMPLE_1,SAMPLE_32,SAMPLE_63,SAMPLE_121,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.KeyCombination",new SampleInfo[]{SAMPLE_39,});
        DOCS_URL_TO_SAMPLE.put("javafx.beans.InvalidationListener",new SampleInfo[]{SAMPLE_107,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.RotateEvent",new SampleInfo[]{SAMPLE_136,SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.Pane",new SampleInfo[]{SAMPLE_129,SAMPLE_79,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.MenuItem",new SampleInfo[]{SAMPLE_39,});
        DOCS_URL_TO_SAMPLE.put("javafx.fxml.JavaFXBuilderFactory",new SampleInfo[]{SAMPLE_108,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Ellipse",new SampleInfo[]{SAMPLE_119,SAMPLE_80,SAMPLE_95,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.text.Font",new SampleInfo[]{SAMPLE_66,SAMPLE_73,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Spinner",new SampleInfo[]{SAMPLE_45,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.Chart",new SampleInfo[]{SAMPLE_15,SAMPLE_111,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.BarChart",new SampleInfo[]{SAMPLE_19,SAMPLE_111,SAMPLE_22,SAMPLE_21,SAMPLE_20,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.FillTransition",new SampleInfo[]{SAMPLE_4,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Accordion",new SampleInfo[]{SAMPLE_31,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.ScaleTransition",new SampleInfo[]{SAMPLE_9,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.PauseTransition",new SampleInfo[]{SAMPLE_7,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ToggleButton",new SampleInfo[]{SAMPLE_56,SAMPLE_50,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.Paint",new SampleInfo[]{SAMPLE_91,SAMPLE_90,SAMPLE_89,SAMPLE_74,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/interoperability-tutorial/fx_swing.htm#JFXIP561",new SampleInfo[]{SAMPLE_111,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.transform.Scale",new SampleInfo[]{SAMPLE_106,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Toggle",new SampleInfo[]{SAMPLE_50,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.NumberAxis",new SampleInfo[]{SAMPLE_19,SAMPLE_18,SAMPLE_29,SAMPLE_17,SAMPLE_16,SAMPLE_15,SAMPLE_26,SAMPLE_14,SAMPLE_25,SAMPLE_13,SAMPLE_24,SAMPLE_23,SAMPLE_111,SAMPLE_22,SAMPLE_21,SAMPLE_20,SAMPLE_30,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.Effect",new SampleInfo[]{SAMPLE_82,SAMPLE_81,SAMPLE_85,SAMPLE_84,SAMPLE_83,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/interoperability-tutorial/concurrency.htm#JFXIP546",new SampleInfo[]{SAMPLE_112,SAMPLE_113,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.SceneAntialiasing",new SampleInfo[]{SAMPLE_105,SAMPLE_104,SAMPLE_106,SAMPLE_103,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.QuadCurve",new SampleInfo[]{SAMPLE_100,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.Scene",new SampleInfo[]{SAMPLE_130,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.web.WebEngine",new SampleInfo[]{SAMPLE_111,SAMPLE_53,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ListView",new SampleInfo[]{SAMPLE_59,SAMPLE_58,SAMPLE_57,SAMPLE_133,SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.StackedBarChart",new SampleInfo[]{SAMPLE_23,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.Lighting",new SampleInfo[]{SAMPLE_80,SAMPLE_130,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.media.AudioClip",new SampleInfo[]{SAMPLE_106,SAMPLE_124,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.RowConstraints",new SampleInfo[]{SAMPLE_117,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.cell.TextFieldTableCell",new SampleInfo[]{SAMPLE_48,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Polygon",new SampleInfo[]{SAMPLE_128,SAMPLE_76,SAMPLE_98,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.SwipeEvent",new SampleInfo[]{SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TableColumn",new SampleInfo[]{SAMPLE_49,SAMPLE_48,SAMPLE_112,SAMPLE_113,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.KeyValue",new SampleInfo[]{SAMPLE_1,SAMPLE_2,SAMPLE_0,SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.media.MediaPlayer",new SampleInfo[]{SAMPLE_19,SAMPLE_126,SAMPLE_15,SAMPLE_122,SAMPLE_125,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ColorPicker",new SampleInfo[]{SAMPLE_34,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ProgressIndicator",new SampleInfo[]{SAMPLE_112,SAMPLE_113,SAMPLE_42,SAMPLE_41,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/visual-effects-tutorial/visual_effects.htm#JFXTE191",new SampleInfo[]{SAMPLE_82,SAMPLE_81,SAMPLE_85,SAMPLE_84,SAMPLE_83,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.KeyCode",new SampleInfo[]{SAMPLE_133,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Label",new SampleInfo[]{SAMPLE_60,SAMPLE_115,SAMPLE_118,SAMPLE_117,SAMPLE_37,SAMPLE_34,SAMPLE_114,SAMPLE_64,SAMPLE_62,SAMPLE_110,SAMPLE_121,SAMPLE_50,SAMPLE_131,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.MenuBar",new SampleInfo[]{SAMPLE_39,SAMPLE_35,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Dialog",new SampleInfo[]{SAMPLE_36,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.Animation.Status",new SampleInfo[]{SAMPLE_71,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Sphere",new SampleInfo[]{SAMPLE_105,SAMPLE_103,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TablePosition",new SampleInfo[]{SAMPLE_49,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.VLineTo",new SampleInfo[]{SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.ScrollEvent",new SampleInfo[]{SAMPLE_135,SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.HLineTo",new SampleInfo[]{SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TreeTableColumn",new SampleInfo[]{SAMPLE_51,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Box",new SampleInfo[]{SAMPLE_104,SAMPLE_106,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.cell.TreeItemPropertyValueFactory",new SampleInfo[]{SAMPLE_51,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.image.PixelWriter",new SampleInfo[]{SAMPLE_87,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/properties-binding-tutorial/binding.htm#JFXBD107",new SampleInfo[]{SAMPLE_110,});
        DOCS_URL_TO_SAMPLE.put("javafx.stage.Stage",new SampleInfo[]{SAMPLE_130,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ContentDisplay",new SampleInfo[]{SAMPLE_60,});
        DOCS_URL_TO_SAMPLE.put("javafx.stage.StageStyle",new SampleInfo[]{SAMPLE_127,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.transform.Rotate",new SampleInfo[]{SAMPLE_80,SAMPLE_105,SAMPLE_104,SAMPLE_106,SAMPLE_103,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.PointLight",new SampleInfo[]{SAMPLE_105,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.StackPane",new SampleInfo[]{SAMPLE_81,SAMPLE_119,SAMPLE_136,SAMPLE_124,SAMPLE_83,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TextFormatter",new SampleInfo[]{SAMPLE_67,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.StackedAreaChart",new SampleInfo[]{SAMPLE_18,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ScrollPane",new SampleInfo[]{SAMPLE_37,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TabPane",new SampleInfo[]{SAMPLE_47,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/graphics-tutorial/javafx-3d-graphics.htm#JFXGR256",new SampleInfo[]{SAMPLE_105,SAMPLE_104,SAMPLE_106,SAMPLE_103,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TreeTableCell",new SampleInfo[]{SAMPLE_51,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.MoveTo",new SampleInfo[]{SAMPLE_17,SAMPLE_14,SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.DatePicker",new SampleInfo[]{SAMPLE_35,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Circle",new SampleInfo[]{SAMPLE_71,SAMPLE_93,SAMPLE_80,SAMPLE_44,SAMPLE_135,SAMPLE_75,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.GaussianBlur",new SampleInfo[]{SAMPLE_82,SAMPLE_80,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.SepiaTone",new SampleInfo[]{SAMPLE_85,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/graphics-tutorial/image_ops.htm#JFXGR238",new SampleInfo[]{SAMPLE_88,SAMPLE_87,SAMPLE_86,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.SplitPane",new SampleInfo[]{SAMPLE_46,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.Timeline",new SampleInfo[]{SAMPLE_71,SAMPLE_29,SAMPLE_1,SAMPLE_103,SAMPLE_2,SAMPLE_75,SAMPLE_0,SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.canvas.Canvas",new SampleInfo[]{SAMPLE_74,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.KeyEvent",new SampleInfo[]{SAMPLE_134,SAMPLE_133,SAMPLE_77,SAMPLE_73,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/media-tutorial/overview.htm#JFXMD101",new SampleInfo[]{SAMPLE_126,SAMPLE_122,SAMPLE_125,SAMPLE_124,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.PieChart",new SampleInfo[]{SAMPLE_28,SAMPLE_27,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.Reflection",new SampleInfo[]{SAMPLE_71,SAMPLE_77,SAMPLE_74,SAMPLE_84,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.Region",new SampleInfo[]{SAMPLE_46,SAMPLE_134,SAMPLE_100,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.PhongMaterial",new SampleInfo[]{SAMPLE_105,SAMPLE_104,SAMPLE_106,SAMPLE_103,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.FlowPane",new SampleInfo[]{SAMPLE_116,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.TilePane",new SampleInfo[]{SAMPLE_120,SAMPLE_131,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.media.AudioSpectrumListener",new SampleInfo[]{SAMPLE_19,SAMPLE_15,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.RadioButton",new SampleInfo[]{SAMPLE_43,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/user-interface-tutorial/text.htm#JFXUI734",new SampleInfo[]{SAMPLE_60,SAMPLE_68,SAMPLE_67,SAMPLE_66,SAMPLE_65,SAMPLE_64,SAMPLE_63,SAMPLE_62,SAMPLE_61,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.BorderPane",new SampleInfo[]{SAMPLE_115,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Hyperlink",new SampleInfo[]{SAMPLE_38,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.AmbientLight",new SampleInfo[]{SAMPLE_105,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.ColumnConstraints",new SampleInfo[]{SAMPLE_117,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.CubicCurveTo",new SampleInfo[]{SAMPLE_17,SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.CubicCurve",new SampleInfo[]{SAMPLE_94,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.PathTransition",new SampleInfo[]{SAMPLE_6,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.text.TextFlow",new SampleInfo[]{SAMPLE_66,SAMPLE_61,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.PerspectiveCamera",new SampleInfo[]{SAMPLE_105,SAMPLE_104,SAMPLE_106,SAMPLE_103,SAMPLE_102,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.FadeTransition",new SampleInfo[]{SAMPLE_3,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Slider",new SampleInfo[]{SAMPLE_69,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.RadialGradient",new SampleInfo[]{SAMPLE_71,SAMPLE_91,SAMPLE_127,SAMPLE_135,SAMPLE_74,});
        DOCS_URL_TO_SAMPLE.put("javafx.fxml.FXMLLoader",new SampleInfo[]{SAMPLE_108,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.BlurType",new SampleInfo[]{SAMPLE_136,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.GridPane",new SampleInfo[]{SAMPLE_117,SAMPLE_42,SAMPLE_50,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.Color",new SampleInfo[]{SAMPLE_71,SAMPLE_93,SAMPLE_92,SAMPLE_91,SAMPLE_90,SAMPLE_127,SAMPLE_104,SAMPLE_129,SAMPLE_101,SAMPLE_89,SAMPLE_100,SAMPLE_99,SAMPLE_103,SAMPLE_136,SAMPLE_54,SAMPLE_98,SAMPLE_102,SAMPLE_75,SAMPLE_97,SAMPLE_74,SAMPLE_96,SAMPLE_73,SAMPLE_95,SAMPLE_94,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.InnerShadow",new SampleInfo[]{SAMPLE_76,SAMPLE_83,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TitledPane",new SampleInfo[]{SAMPLE_31,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ToolBar",new SampleInfo[]{SAMPLE_70,SAMPLE_115,SAMPLE_69,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.Node",new SampleInfo[]{SAMPLE_129,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.CheckBox",new SampleInfo[]{SAMPLE_32,SAMPLE_121,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Menu",new SampleInfo[]{SAMPLE_39,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.Cursor",new SampleInfo[]{SAMPLE_135,SAMPLE_131,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Tab",new SampleInfo[]{SAMPLE_47,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.SequentialTransition",new SampleInfo[]{SAMPLE_29,SAMPLE_10,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Arc",new SampleInfo[]{SAMPLE_92,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Shape",new SampleInfo[]{SAMPLE_93,SAMPLE_92,SAMPLE_91,SAMPLE_90,SAMPLE_101,SAMPLE_89,SAMPLE_100,SAMPLE_99,SAMPLE_98,SAMPLE_96,SAMPLE_95,SAMPLE_94,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Button",new SampleInfo[]{SAMPLE_70,SAMPLE_115,SAMPLE_118,SAMPLE_37,SAMPLE_69,SAMPLE_79,SAMPLE_34,SAMPLE_55,SAMPLE_114,SAMPLE_54,SAMPLE_31,SAMPLE_130,SAMPLE_63,SAMPLE_40,SAMPLE_120,});
        DOCS_URL_TO_SAMPLE.put("javafx.beans.binding.StringBinding",new SampleInfo[]{SAMPLE_110,});
        DOCS_URL_TO_SAMPLE.put("javafx.fxml.Initializable",new SampleInfo[]{SAMPLE_108,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.LineTo",new SampleInfo[]{SAMPLE_17,SAMPLE_14,SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.CheckMenuItem",new SampleInfo[]{SAMPLE_35,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.CycleMethod",new SampleInfo[]{SAMPLE_71,SAMPLE_75,SAMPLE_74,SAMPLE_73,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.ArcTo",new SampleInfo[]{SAMPLE_97,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/embedded-browser-tutorial/overview.htm#JFXWV135",new SampleInfo[]{SAMPLE_53,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.LinearGradient",new SampleInfo[]{SAMPLE_90,SAMPLE_135,SAMPLE_75,SAMPLE_73,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.XYChart",new SampleInfo[]{SAMPLE_19,SAMPLE_15,SAMPLE_26,SAMPLE_14,SAMPLE_25,SAMPLE_111,SAMPLE_30,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.BlendMode",new SampleInfo[]{SAMPLE_75,SAMPLE_74,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.Parent",new SampleInfo[]{SAMPLE_128,});
        DOCS_URL_TO_SAMPLE.put("javafx.concurrent.Task",new SampleInfo[]{SAMPLE_112,SAMPLE_113,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TableView",new SampleInfo[]{SAMPLE_49,SAMPLE_48,SAMPLE_112,SAMPLE_113,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.HBox",new SampleInfo[]{SAMPLE_118,SAMPLE_1,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TextField",new SampleInfo[]{SAMPLE_118,SAMPLE_68,SAMPLE_67,SAMPLE_65,SAMPLE_63,SAMPLE_110,});
        DOCS_URL_TO_SAMPLE.put("javafx.util.converter.FormatStringConverter",new SampleInfo[]{SAMPLE_67,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.paint.Stop",new SampleInfo[]{SAMPLE_71,SAMPLE_73,});
        DOCS_URL_TO_SAMPLE.put("javafx.concurrent.Service",new SampleInfo[]{SAMPLE_112,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TreeView",new SampleInfo[]{SAMPLE_52,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.text.Text",new SampleInfo[]{SAMPLE_80,SAMPLE_66,SAMPLE_73,SAMPLE_61,});
        DOCS_URL_TO_SAMPLE.put("javafx.fxml.FXML",new SampleInfo[]{SAMPLE_108,});
        DOCS_URL_TO_SAMPLE.put("javafx.util.Duration",new SampleInfo[]{SAMPLE_1,SAMPLE_2,SAMPLE_0,SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.layout.AnchorPane",new SampleInfo[]{SAMPLE_114,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.AreaChart",new SampleInfo[]{SAMPLE_17,SAMPLE_16,SAMPLE_15,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.media.Media",new SampleInfo[]{SAMPLE_19,SAMPLE_126,SAMPLE_15,SAMPLE_122,SAMPLE_125,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.text.TextBoundsType",new SampleInfo[]{SAMPLE_80,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Pagination",new SampleInfo[]{SAMPLE_40,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.RadioMenuItem",new SampleInfo[]{SAMPLE_35,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TextArea",new SampleInfo[]{SAMPLE_36,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.PerspectiveTransform",new SampleInfo[]{SAMPLE_77,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.MouseEvent",new SampleInfo[]{SAMPLE_28,SAMPLE_106,SAMPLE_134,SAMPLE_77,SAMPLE_136,SAMPLE_135,SAMPLE_73,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.shape.Polyline",new SampleInfo[]{SAMPLE_99,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.LineChart",new SampleInfo[]{SAMPLE_26,SAMPLE_25,SAMPLE_24,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.ScatterChart",new SampleInfo[]{SAMPLE_29,SAMPLE_30,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.BoxBlur",new SampleInfo[]{SAMPLE_75,});
        DOCS_URL_TO_SAMPLE.put("javafx.geometry.VPos",new SampleInfo[]{SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.input.ZoomEvent",new SampleInfo[]{SAMPLE_136,SAMPLE_132,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.Tooltip",new SampleInfo[]{SAMPLE_47,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.RotateTransition",new SampleInfo[]{SAMPLE_8,});
        DOCS_URL_TO_SAMPLE.put("http://docs.oracle.com/javase/8/javafx/graphics-tutorial/canvas.htm#JFXGR214",new SampleInfo[]{SAMPLE_74,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.web.WebView",new SampleInfo[]{SAMPLE_111,SAMPLE_53,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.KeyFrame",new SampleInfo[]{SAMPLE_1,SAMPLE_103,SAMPLE_2,SAMPLE_0,SAMPLE_72,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.TableRow",new SampleInfo[]{SAMPLE_49,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.image.WritableImage",new SampleInfo[]{SAMPLE_87,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.chart.CategoryAxis",new SampleInfo[]{SAMPLE_19,SAMPLE_24,SAMPLE_23,SAMPLE_111,SAMPLE_22,SAMPLE_21,SAMPLE_20,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.effect.DropShadow",new SampleInfo[]{SAMPLE_81,SAMPLE_80,SAMPLE_79,SAMPLE_136,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ChoiceBox",new SampleInfo[]{SAMPLE_33,});
        DOCS_URL_TO_SAMPLE.put("javafx.animation.ParallelTransition",new SampleInfo[]{SAMPLE_5,});
        DOCS_URL_TO_SAMPLE.put("javafx.event.ActionEvent",new SampleInfo[]{SAMPLE_2,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ToggleGroup",new SampleInfo[]{SAMPLE_47,SAMPLE_35,SAMPLE_56,SAMPLE_50,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.web.HTMLEditor",new SampleInfo[]{SAMPLE_37,});
        DOCS_URL_TO_SAMPLE.put("javafx.beans.value.ChangeListener",new SampleInfo[]{SAMPLE_109,SAMPLE_107,});
        DOCS_URL_TO_SAMPLE.put("javafx.scene.control.ScrollBar",new SampleInfo[]{SAMPLE_44,SAMPLE_77,});
    }
    public static SampleInfo[] getSamplesForDoc(String docUrl) {
        return DOCS_URL_TO_SAMPLE.get(docUrl);
    }
}
