package headergen;
import com.sun.media.jfxmedia.MediaError;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
public class HeaderGen {
private static void generateFile(File file) throws IOException {
PrintStream os = new PrintStream(file);
os.println("/* DO NOT EDIT THIS FILE - it is machine generated */");
os.println();
os.println("#ifndef _JFXMEDIA_ERRORS_H_");
os.println("#define _JFXMEDIA_ERRORS_H_");
os.println();
for (MediaError error : MediaError.values()) {
os.println("#define    " + error.name() + "    " + error.code());
}
os.println();
os.println("#endif // _JFXMEDIA_ERRORS_H_");
os.close();
}
public static void main(String[] arg) {
if (arg.length == 2) {
File file = null;
try {
file = new File(arg[0]);
if (!file.exists())
{
System.out.println("HeaderGen: Creating header file at path: " + file.getAbsolutePath());
file.createNewFile();
generateFile(file);
} else {
String errorFilePath = arg[1] + "/" + MediaError.class.getCanonicalName().replace(".", "/") + ".java";
File errorFile = new File(errorFilePath);
if (errorFile.lastModified() <= file.lastModified()) {
System.out.println("HeaderGen: no need to regenerate header file.");
} else {
System.out.println("HeaderGen: re-creating header file at path: " + file.getAbsolutePath());
generateFile(file);
}
}
} catch (IOException ioex) {
String path = (file != null) ? file.getAbsolutePath() : null;
System.err.println("HeaderGen IO error: " + ioex.getMessage() + ": " + path);
System.exit(-2);
}
} else {
System.err.println("Too few arguments.\nUsage:\n\tHeaderGen <absolute path to header file> <absolute path to sources root>\n");
System.exit(-1);
}
}
}
