/*  ==== ML OBJECT TAGS ====
 *
 *  Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *  
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 *  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Description
 *  -----------
 *  This header is used by both C and assembler files and defines the tags
 *  used for ML values and other garbage collector markers, as well as
 *  macros for manipulating them.
 *
 *  IMPORTANT
 *  ---------
 *  This file is scanned by tags.awk and __tags.awk to produce SML sources.
 *  Any #define which defines an upper case integer will be included.
 *
 *  $Id: tags.h,v 1.7 1996/11/07 17:30:29 stephenb Exp $
 */


#ifndef tags_h
#define tags_h


/*  === PRIMARY TAGS ===
 *
 *  Every mlval is tagged in the bottom 3 bits as below.  Odd tags are
 *  always pointers, even tags are always immediates.  Possible uses
 *  for PRIMARY6 and PRIMARY7 include weak pointers,  floating-point,
 *  foreign pointers. Note that PAIRPTR and POINTER are such that
 *  (mlval - 1) is always the address of the first data word of the
 *  object (pairs being unheaded).
 */

#define INTEGER0 0		/* 000 : even integer		*/
#define PAIRPTR  1		/* 001 : pair pointer		*/
#define HEADER   2		/* 010 : header word		*/
#define REFPTR   3		/* 011 : reference pointer	*/
#define INTEGER1 4		/* 100 : odd integer		*/
#define POINTER  5		/* 101 : any other pointer	*/
#define PRIMARY6 6		/* 110 : unused : not a pointer	*/
#define PRIMARY7 7		/* 111 : unused : a pointer	*/


/*  === SECONDARY TAGS ===
 *
 *  These all live in header words.  Ordinary objects have bit 5 unset.
 *  For ordinary objects: objects with `normal' equality have bit 4
 *  unset, and objects containing pointers have bit 3 unset.  For back
 *  pointers the length field is the distance back to the start of the
 *  object.
 */

#define RECORD		 2	/* 000010 pointers, simple equality	*/
#define STRING		10	/* 001010 no pointers, simple equality	*/
#define ARRAY		18	/* 010010 pointers, ref equality 	*/
#define BYTEARRAY	26	/* 011010 no pointers, ref equality	*/
#define BACKPTR		34	/* 100010 back pointer (see above)	*/
#define CODE		42	/* 101010 no pointers, ref equality	*/
#define HEADER50	50	/* 110010 unused			*/
#define WEAKARRAY       58      /* 111010 special pointers, ref equality*/


/*  === SPECIAL VALUES AND MARKERS ===
 *
 *  These values are used as markers.  An `impossible' value is one which
 *  can not be generated by ML.
 *
 *  MLERROR          impossible value used to flag errors
 *  EVACUATED        impossible value used to mark evacuated objects in the
 *                   garabge collector
 *  DEAD	     impossible value used to annul weak array entries
 *
 *  The values beginning with STACK are placed in the closure register in
 *  special stack frames so that they can be recognised by various parts of
 *  the runtime system.
 */

#define MLERROR			5
#define EVACUATED		1
#define DEAD			6    /* NOTE: not a pointer */
#define STACK_START		4    /* start of ML stack (see callml) */
#define STACK_DISTURB_EVENT	8    /* event poll in ml_disturbance */
#define STACK_EXTENSION		12   /* first frame on new stack block */
#define STACK_RAISE             16   /* raise frame */
#define STACK_EVENT		20   /* event check frame */
#define STACK_C_RAISE		24   /* raise from C */
#define STACK_C_CALL		28   /* call to C */
#define STACK_INTERCEPT		32   /* code vector interception frame */
#define STACK_SPACE_PROFILE	36   /* space profiling entry frame */


/*  === CODE VECTOR ANCILLARY ===
 *
 *  Each code vector has attached to it a record (usually a pair)
 *  containing tables/arrays of information for the code objects in that
 *  vector. This record is called the ancillary record. The macros
 *  beginning with ANC_ define the index within that record.
 *  See also values.h.
 *
 *  NAMES	the name strings
 *  PROFILES	profiling handle (see the profiler)
 *  INTERFNS	the functions to call on interception/replacement
 */

#define ANC_NAMES		0
#define ANC_PROFILES		1
#define ANC_INTERFNS		2

/*  === OTHER RUNTIME PARAMETERS ===
 *
 *  STACK_BUFFER is the number of `unused' bytes that must be maintained
 *  between an ML stack frame and the stack limit register %g6.
 *  CODE_OFFSET is the number to be added to an mlval code vector to address
 *  its first instruction.
 *  *_INTERCEPT_LENGTH is the length in bytes of the code in a code vector
 *  which is altered to implement interception.  (See intercept.h and
 *  interface.S.)
 */

#define STACK_BUFFER		2048
#define DEFAULT_STACK_SIZE	64
#define CODE_OFFSET		3
#define SPARC_INTERCEPT_LENGTH	12
#define MIPS_INTERCEPT_LENGTH   16
#define I386_INTERCEPT_LENGTH   3

#endif /* tags_h */
