/*  ==== FOREIGN INTERFACE CALL STUB GENERATOR ====
 *
 *  Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *  
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 *  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Implementation
 *  --------------
 *
 *  Revision Log
 *  ------------
 *  $Log: fi_call_stub_h_gen.c,v $
 *  Revision 1.2  1996/05/14 11:22:57  stephenb
 *  Fix warning about lack of prototype for `exit'.
 *  Also added a comment explaining why various extern declarations are
 *  included in the code (crappy SunOS header files).
 *
 * Revision 1.1  1995/07/21  16:29:27  nickb
 * new unit
 * Replaced the old generation system.
 *
 */

#include <stdio.h>
#include <stdlib.h>		/* exit */


/* The following are here just for SunOS since its header files don't
 * contain prototypes -- and when they do they are vacuous ones
 */
extern int    printf(const char *, ...);
extern int    fprintf(FILE *stream, const char *, ...);
extern int    sscanf(const char *, const char *, ...);


static void nl(void)
{
  printf("\n");
}

extern int main(int argc, char *argv[])
{
  int size, code;

  if (argc == 2)
    code = sscanf(argv[1],"%d",&size);
  else
    code = 0;
  
  if (code != 1) {
    fprintf(stderr,
	    "Usage : %s <size> - makes foreign call stub of size <size>\n",
	    argv[0]);
    exit(1);
  }

  printf("   /*=====================================================*/\n");
  printf("   /*                                                     */\n");
  printf("   /*             FOREIGN INTERFACE CALL STUB             */\n");
  printf("   /*             ---------------------------             */\n");
  printf("   /*                                                     */\n");
  printf("   /*   Generated by rts/misc/fi_call_stub_h_gen.c        */\n");
  printf("   /*                                                     */\n");
  printf("   /*   (C) 1995 Harlequin Ltd.                           */\n");
  printf("   /*=====================================================*/\n");
  nl();
  printf("#include \"types.h\"\n");
  printf("#include \"mltypes.h\"\n");
  nl();
  printf("#define MAX_FI_ARG_LIMIT\t\t%d\n",size);
  printf("   /*                                                       \n");
  printf("    *  Gives the maximum no. of arguments that the FI can   \n");
  printf("    *  manage using the call stub.                          \n");
  printf("    */                                                      \n");
  nl();
  nl();
  printf("extern void *call_ffun(void *, void *[], int);              \n");
  printf("   /*                                                       \n");
  printf("    *  call_ffun(function, arg_vector, num_of_args) : result\n");
  printf("    *                                                       \n");
  printf("    *  Foreign call stub code  (see gen/fi_call_code.c)     \n");
  printf("    *  That code is automatically generated.                \n");
  printf("    *  (see misc/fi_call_code_c_gen.c)                      \n");
  printf("    */                                                      \n");
  nl();
  nl();
  printf("extern mlval call_ffun_error(int);                          \n");
  printf("   /*                                                       \n");
  printf("    *  call_ffun_error(num_of_args)                         \n");
  printf("    *                                                       \n");
  printf("    *  Reports error for request for too many foreign       \n");
  printf("    *  arguments. Can provide an mlval result.              \n");
  printf("    *  (implemented externally)                             \n");
  printf("    */                                                      \n");
  nl();
  return 0;
}
