/*  ==== FOREIGN INTERFACE CALL STUB GENERATOR ====
 *
 *  Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *  
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 *  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Implementation
 *  --------------
 *
 *  Revision Log
 *  ------------
 *  $Log: fi_call_stub_c_gen.c,v $
 *  Revision 1.3  1995/08/04 14:20:01  nickb
 *  Add stdio and stdarg inclusions.
 *
 * Revision 1.2  1995/07/24  13:45:16  nickb
 * Add prototypes.
 *
 * Revision 1.1  1995/07/21  16:29:15  nickb
 * new unit
 * Replaced the old generation system.
 *
 */

#include "ansi.h"
#include <stdio.h>
#include <stdarg.h>

/* call stub file name */
#define filename       "fi_call_stub"

/* call stub function name */
#define vcall_ffun     "call_ffun"

/* function variable name */
#define vffun          "ffun"

/* argument vector name */
#define vargv          "argv"

/* argument size name */
#define vsize          "size"

/* argument (and return) type */
#define argtype        "void *"

/* Formatting sizes */
#define cwidth         5
#define cwidth_1       (cwidth - 1)

/* Definitions */
static void nl(void)
{
  printf("\n");
}

static int indent_level = 0;

static void push(int n)
{
  indent_level += n;
}

static void pop(int n)
{
  indent_level -= n;
  if (indent_level < 0) {
    fprintf(stderr, "Indentation level fell below 0\n");
    exit (1);
  }
}
 
static void line(const char *string, ...)
{
  int i = indent_level;
  va_list arg;

  va_start (arg,string);
  while(i--)
    putchar(' ');
  vfprintf(stdout,string,arg);
  va_end (arg);
}

static void print_cast(int args)
{
  int i, j, ln, cn;

  ln = (args-1) / cwidth;
  cn = (args-1) % cwidth +1;

  printf("((%s(*)\n", argtype);
  line("(");
  if (ln > 0) {
    for (i=0; i<ln; i++) {
      for (j=0; j<cwidth; j++)
	printf("%s, ", argtype);
      printf("\n");
      line(" ");
    }
  }

  if (cn > 0) {
    cn--;
    for (i=0; i<cn; i++)
      printf("%s, ", argtype);
    printf("%s", argtype);
  }
  printf("))%s)",vffun);
}

static void print_args(int args)
{
  int i, j, ln, cn, idx;

  ln = (args-1) / cwidth;
  cn = (args-1) % cwidth + 1;

  idx = 0;

  printf("(");
  if (ln > 0) {
    for (i=0;i<ln;i++) {
      for (j=0;j<cwidth;j++) {
	printf("%s[%d], ", vargv, idx);
	idx++;
      }
      printf("\n");
      line(" ");
    }
  }
  if (cn > 0) {
    cn--;
    for (i=0;i<cn;i++) {
      printf("%s[%d], ", vargv, idx);
      idx++;
    }
    printf("%s[%d]", vargv, idx);
  }
  printf(")");
}

static void print_switch_case(int i)
{
  line("case %d : \n", i);
  push(2);
  line("return(");
  push(7);
  print_cast(i);
  if (i > 0) {
    printf("\n");
    line("");
  }
  print_args(i);
  pop(7);
  printf(");\n");
  pop(2);
  return;
}

extern int main(int argc, char *argv[])
{
  int size, i, code;

  if (argc == 2)
    code = sscanf(argv[1],"%d",&size);
  else
    code = 0;
  
  if (code != 1) {
    fprintf(stderr,
	    "Usage : %s <size> - makes foreign call stub of size <size>\n",
	    argv[0]);
    exit(1);
  }

  printf("   /*=====================================================*/\n");
  printf("   /*                                                     */\n");
  printf("   /*             FOREIGN INTERFACE CALL STUB             */\n");
  printf("   /*             ---------------------------             */\n");
  printf("   /*                                                     */\n");
  printf("   /*   Generated by rts/misc/fi_call_stub_c_gen.c        */\n");
  printf("   /*                                                     */\n");
  printf("   /*   (C) 1995 Harlequin Ltd.                           */\n");
  printf("   /*=====================================================*/\n");
  nl();
  printf("#include \"%s.h\"\n",filename);
  nl();
  printf("%s%s(void *%s, %s%s[], int %s)\n"
	 , argtype, vcall_ffun, vffun, argtype, vargv, vsize);
  printf("{\n");
  push(2);
  line("switch (%s) {\n",vsize);
  push(2);
  for (i=0; i<=size;i++)
    print_switch_case(i);
  line("default : \n");
  line("  return((%s)%s_error(%s));\n",argtype,vcall_ffun,vsize);
  pop(2);
  line("}\n");
  pop(2);
  printf("}\n");
  return(0);
}
