(*
 * $Log: __labelstrings.sml,v $
 * Revision 1.71  1999/04/29 16:08:03  johnh
 * [Bug #190557]
 * Change name of Files dialog to Common Files dialog.
 *
 * Revision 1.70  1999/03/23  14:44:48  johnh
 * [Bug #190536]
 * add personalAd.
 *
 * Revision 1.69  1998/06/01  16:23:06  johnh
 * [Bug #30369]
 * Replace source path with a list of files.
 *
 * Revision 1.68  1998/05/13  16:01:18  johnh
 * [Bug #30406]
 * Rename targets to target sources.
 *
 * Revision 1.67  1998/05/12  11:45:00  johnh
 * [Bug #30410]
 * Remove 'Set' from Project Workspace buttons.
 *
 * Revision 1.66  1998/04/01  12:08:56  jont
 * [Bug #70086]
 * Windows_ has become WindowsGui_
 *
 * Revision 1.65  1998/03/26  14:27:56  johnh
 * [Bug #50035]
 * Add more virtual key codes and close key mapped to F4.
 *
 * Revision 1.64  1998/03/02  15:07:22  mitchell
 * [Bug #70074]
 * Add depth limit support for signature printing
 *
 * Revision 1.63  1998/02/18  17:07:28  jont
 * [Bug #70070]
 * Remove MLWorks.IO.terminal_out in favour of Terminal.output
 *
 * Revision 1.62  1998/01/27  14:31:34  johnh
 * [Bug #30071]
 * Merge in Project Workspace changes.
 *
 * Revision 1.61  1997/10/28  17:31:50  johnh
 * [Bug #30296]
 * Add strings for error browser buttons.
 *
 * Revision 1.60  1997/10/09  15:42:29  johnh
 * [Bug #30193]
 * Add label for Usage->PrintBacktrace.
 *
 * Revision 1.59  1997/10/08  13:36:34  johnh
 * [Bug #30137]
 * Shouldn't have removed clear_console in last fix.
 *
 * Revision 1.58  1997/10/03  15:13:26  johnh
 * [Bug #30137]
 * Create System messages window.
 *
 * Revision 1.57  1997/10/01  17:06:32  jkbrook
 * [Bug #20088]
 * Merging from MLWorks_11:
 * SML'96 should be SML'97
 *
 * Revision 1.55.2.15  1998/01/15  15:59:32  johnh
 * [Bug #30071]
 * Introducing subprojects.
 *
 * Revision 1.55.2.14  1998/01/09  17:11:32  johnh
 * [Bug #30071]
 * split project propeties locations dialog in two.
 *
 * Revision 1.55.2.13  1998/01/09  11:54:14  johnh
 * [Bug #30071]
 * Add mode location.
 *
 * Revision 1.55.2.12  1998/01/06  15:57:04  johnh
 * [Bug #30071]
 * Add about labels.
 *
 * Revision 1.55.2.11  1997/12/11  15:56:24  johnh
 * [Bug #30071]
 * Add save_proj_as to file menu.
 * Rename 'Entries' on Project Workspace to 'Files'.
 *
 * Revision 1.55.2.10  1997/12/03  11:16:54  johnh
 * [Bug #30071]
 * Improve project menu labels.
 *
 * Revision 1.55.2.9  1997/12/02  16:51:50  johnh
 * [Bug #30071]
 * Add labels for relative path names in Project Properties.
 *
 * Revision 1.55.2.8  1997/12/02  13:29:22  johnh
 * [Bug #30071]
 * Change labels for new project and file menus.
 *
 * Revision 1.55.2.7  1997/11/24  11:39:02  johnh
 * [Bug #30071]
 * Remove Paths menu.
 *
 * Revision 1.55.2.5  1997/11/12  13:36:30  johnh
 * [Bug #30071]
 * Labels for dialog shown when creating a new PW tool.
 *
 * Revision 1.55.2.4  1997/11/11  13:42:58  johnh
 * [Bug #30244]
 * Merging dependency graph changes (full menu structure).
 *
 * Revision 1.55.2.3  1997/10/06  12:43:54  johnh
 * [Bug #30071]
 * Adding changes for allowing relative paths in project properties.
 *
 * Revision 1.55.2.2  1997/09/12  14:48:42  johnh
 * [Bug #30071]
 * Redesign Compilation Manager -> Project Workspace.
 *
 * Revision 1.56  1997/09/30  12:47:48  johnh
 * [Bug #30244]
 * Changing dependency graph menu label to Graph.
 *
 * Revision 1.55  1997/09/05  10:35:35  johnh
 * [Bug #30241]
 * Implement the proper Windows find dialog, so remove old labels.
 *
 * Revision 1.54  1997/08/06  13:03:18  brucem
 * [Bug #30202]
 * Add new dependency graph menu.
 * And graph dialogs.
 *
 * Revision 1.53  1997/07/23  09:04:44  johnh
 * [Bug #30182]
 * Add some more virtual keys.
 *
 * Revision 1.52  1997/07/14  13:27:34  johnh
 * [Bug #30124]
 * Add help menu labels.
 *
 * Revision 1.51  1997/06/09  10:25:56  johnh
 * [Bug #30068]
 * Changed break and trace identifiers.
 *
 * Revision 1.50  1997/05/27  11:17:13  daveb
 * [Bug #30136]
 * Removed early-mips-r4000 option.
 *
 * Revision 1.49  1997/05/23  08:31:03  johnh
 * [Bug #30054]
 * Changing name of Save Source and Save Source As.
 *
 * Revision 1.48  1997/05/16  16:04:55  johnh
 * Implementing single menu bar on Windows.
 *
 * Revision 1.47  1997/03/25  11:29:40  matthew
 * Adding platform dependent options
 *
 * Revision 1.46  1997/03/20  11:53:15  matthew
 * Adding useRelativePathname
 *
 * Revision 1.45  1996/11/14  11:42:50  daveb
 * Changed "End X Session" to "End GUI Session".
 *
 * Revision 1.44  1996/10/31  17:05:16  daveb
 * Renamed Windows_ to Windows, as users will see it.
 *
 * Revision 1.43  1996/10/09  20:33:31  io
 * moving String from toplevel
 *
 * Revision 1.42  1996/09/23  14:48:36  matthew
 * Adding interruptButton label
 *
 * Revision 1.41  1996/08/12  16:24:37  nickb
 * Add label for "sort" button in profile tool action menu.
 *
 * Revision 1.40  1996/08/01  13:00:47  daveb
 * [Bug #1517]
 * Added accelerators for Alt-P and Alt-N.
 *
 * Revision 1.39  1996/06/25  13:42:03  daveb
 * Made button buttons have different names from menu buttons, so that
 * Windows can distinguish between them, and so let us put mnemonics on
 * the menu items but not the buttons.
 *
 * Revision 1.38  1996/06/17  16:39:14  nickb
 * Add Profile button.
 *
 * Revision 1.37  1996/06/15  16:43:17  brianm
 * Modifications to add custom editor interface ...
 *
 * Revision 1.36  1996/06/13  10:31:07  daveb
 * Removed Accelerator from the Listener menu entry.
 *
 * Revision 1.35  1996/05/29  16:19:32  daveb
 * Changed "Search Pervasives" to "Search System Context".
 *
 * Revision 1.34  1996/05/24  14:55:45  daveb
 * Changes to graph dialogs.
 *
 * Revision 1.33  1996/05/24  11:31:21  daveb
 * Added Abandon button to Listener.
 *
 * Revision 1.32  1996/05/24  10:12:12  daveb
 * Removed Evaluator.
 *
 * Revision 1.31  1996/05/22  16:19:18  daveb
 * Added label for editSelection and language.
 *
 * Revision 1.30  1996/05/22  13:18:22  daveb
 * Removed Local Variables mode.
 *
 * Revision 1.29  1996/05/21  16:42:28  daveb
 * Removed some obsolete entries.
 *
 * Revision 1.28  1996/05/21  16:13:16  daveb
 * Various renamings.
 *
 * Revision 1.27  1996/05/20  10:31:00  daveb
 * Added Save Image menu item.
 *
 * Revision 1.26  1996/05/16  14:28:28  daveb
 * Removed entries for modNameLabel, sourceFileLabel, and objectFileLabel, as
 * these are set programmatically.
 *
 * Revision 1.25  1996/05/16  14:17:06  nickb
 * Add "slider".
 *
 * Revision 1.24  1996/05/16  11:11:07  daveb
 * Fixed clashing mnemonics on File menu and Compilation Manager toolbar.
 *
 * Revision 1.23  1996/05/15  16:03:35  daveb
 * Made the console be a permanent pane of the compilation manager.
 *
 * Revision 1.21  1996/05/01  12:17:07  jont
 * String functions explode, implode, chr and ord now only available from String
 * io functions and types
 * instream, oustream, open_in, open_out, close_in, close_out, input, output and end_of_stream
 * now only available from MLWorks.IO
 *
 * Revision 1.20  1996/04/11  16:07:38  daveb
 * Added removeDuplicates.
 *
 * Revision 1.19  1996/04/04  14:55:05  matthew
 * Adding some resources
 *
 * Revision 1.18  1996/04/03  16:36:43  daveb
 * Revised menus in compilation manager.
 * Added missing mnemonics elsewhere.
 *
 * Revision 1.17  1996/03/14  15:27:21  matthew
 * Renaming do_all to compile_and_load
 *
 * Revision 1.16  1996/03/14  11:56:48  matthew
 * Adding objectPath
 *
 * Revision 1.15  1996/03/12  17:24:28  matthew
 * Adding some more labels, funnily enough
 *
 * Revision 1.14  1996/03/07  16:55:32  daveb
 * Added errorTextLabel, savePreferences, debuggerArgsLabel, debuggerFramesLabel,
 * and corrected confusion between labels in source browser and compilation
 * manager.
 *
 * Revision 1.13  1996/02/28  17:20:30  matthew
 * Changes to WINDOWS sig
 *
 * Revision 1.12  1996/02/26  15:44:32  stephenb
 * Change Traced/trace to Duplicated/duplicated since with the
 * change in the debugger implementation, trace is no longer the
 * only command that results in duplicate frames.
 *
 * Revision 1.11  1996/02/20  12:06:19  matthew
 * Removing evaluator accelerator
 *
 * Revision 1.10  1996/01/24  15:27:55  matthew
 * Changing diagnostic message
 *
 * Revision 1.9  1996/01/19  15:02:42  matthew
 * Adding some inspector things
 *
 * Revision 1.8  1996/01/17  12:19:39  matthew
 * Changing some labels
 *
 * Revision 1.7  1996/01/11  15:09:15  matthew
 * Adding some more strings
 *
 * Revision 1.6  1996/01/08  16:41:44  matthew
 * Adding deleteAll resource
 *
 * Revision 1.5  1995/11/23  12:38:58  matthew
 * Changing some names
 *
 * Revision 1.4  1995/11/21  17:25:23  matthew
 * More fiddling
 *
 * Revision 1.3  1995/11/16  14:23:30  matthew
 * Updating
 *
 * Revision 1.2  1995/08/29  13:46:55  matthew
 * Adding some mnemonics etc.
 *
 * Revision 1.1  1995/08/11  14:03:04  matthew
 * new unit
 * Label resources for windows code
 *
 *)

require "^.utils.__terminal";
require "labelstrings";
require "__windows_gui";

structure LabelStrings_ : LABELSTRINGS =
  struct
    type word = WindowsGui.word
    type AcceleratorFlag = WindowsGui.accelerator_flag

    (* some virtual keys *)

    val VK_F1 = 0x70
    val VK_F2 = 0x71
    val VK_F3 = 0x72
    val VK_F4 = 0x73
    val VK_F5 = 0x74
    val VK_F6 = 0x75
    val VK_F7 = 0x76
    val VK_F8 = 0x77
    val VK_F9 = 0x78
    val VK_F10 = 0x79
    val VK_F11 = 0x7a
    val VK_F12 = 0x7b

    val VK_TAB = 0x09

    val VK_PRIOR = 	0x21	(* page up *)
    val VK_NEXT = 	0x22	(* page down *)
    val VK_END = 	0x23
    val VK_HOME = 	0x24

    val VK_LEFT = 	0x25
    val VK_UP = 	0x26
    val VK_RIGHT = 	0x27
    val VK_DOWN = 	0x28

    val VK_DELETE = 	0x2e

    val label_strings =
      [
	(* Advert for personal edition *)
	("personalAd", "About &Professional Edition"),
	("mlwLicensing", "MLWorks &Licensing"),

	(* Error browser *)
	("repeatButton", "Repeat"),
	("editSourceButton", "Edit"),

	(* System messages window *)
	("clear_messages", "Clear"),
	("close_messages", "Close"),
	("sysMessages", "S&ystem messages"),

	(* Project Workspace *)
	("new_proj", "&New Project"),
	("open_proj", "&Open Project"),
	("save_proj", "&Save Project\tCtrl+S"),
	("save_proj_as", "Save Project &As...\tCtrl+A"),
	("load_proj_files", "&Load Project Files"),

        ("compile","&Compile Selection"),
	("compile_all", "Compile &Target Sources"),
        ("load", "&Load Selection"),
	("load_targets", "L&oad Targets"),
	("recompile", "&Force Compile of Selection"),
	("reload", "Force Load of &Selection"),
        ("check", "Read &Dependencies"),
        ("show", "Sho&w"),
        ("check_compile", "Files to &Compile Selection"),
        ("check_build", "Files to Compile &Target Sources"),
        ("check_load", "Files to &Load Selection"),
        ("check_targets", "Files to L&oad Targets"),

	("proj_properties", "&Properties"),
	("prop_files", "Common &Files"),
	("prop_target", "&Targets"),
	("prop_subproj", "&Subprojects"),
	("prop_mode", "&Modes"),
	("prop_config", "&Configurations"),
	("prop_lib", "&Library path"),
	("prop_obj_dir", "&Objects location"),
	("prop_bin_dir", "&Binaries location"),
	("prop_about", "&About"),

	("PW_new", "New Project"),
	("PW_open", "Open Project"),
	("PW_choiceLabel", "Choose whether to create a new project or open an existing one:"),
	("PW_readDependencies", "Read Dependencies"),
	("PW_files", "Common Files"),
	("PW_curTargets", "Targets"),
	("PW_subprojects", "Subprojects"),
	("PW_libraryPath", "Library Path"),
	("PW_relativeBin", "Relative path names for Binaries"),
	("PW_relativeObj", "Relative path names for Objects"),
	("PW_objectsDir", "Objects Location"),
	("PW_binariesDir", "Binaries Location"),

	("projNameLabel", "Project Name: <NONE>"),
	("projSourceLabel", "Project Source Path: "),
	("projObjectsLabel", "Object Files Location: <NEED DEFAULT>"),
	("projBinariesLabel", "Binary Files Location: <NEED DEFAULT>"),

	("PWP_Ok", "OK"),
	("PWP_Apply", "Apply"),
	("PWP_Reset", "Reset"),
	("PWP_Cancel", "Cancel"),

	("PWP_files", "Relative path names"),
	("PWP_config_files", "Relative path names"),
	("PWP_config_lib", "Relative path names"),
	("PWP_lib_path", "Relative path names"),

	(* Project Properties - Paths Dialog *)
	("PWP_propFilesLabel", "Files to be included in the project:"),
	("PWP_moveUp", "Move Up"),
	("PWP_moveDown", "Move Down"),
	("PWP_removeSel", "Remove Selection"),
	("PWP_removeAll", "Remove All"),
	("PWP_addButton", "Add to List"),

	(* Project Properties - Files Dialog *)
	("PWF_propFilesLabel", "Files to be included in the project:"),
	("PWF_addFiles", "Add file(s)"),
	("PWF_removeSel", "Remove Selection"),
	("PWF_removeAll", "Remove All"),
	("PWF_addButton", "Add From Directory"),


	(* Project Properties - Targets Dialog *)
	("PWT_addConfig","Set Configuration"),
	("PWT_addMode", "Set Mode"),
	("PWT_addTarget", "Add New Target"),
	("PWT_configLabel", "Configuration:"),
	("PWT_detailsLabel", "Details of selected current target:"),
	("PWT_disable", "Disable"),
	("PWT_disableLabel", "List of disabled target sources: "),
	("PWT_dynlibRadio", "Dynamic Library"),
	("PWT_enableTarget", "Enable"),
	("PWT_exeRadio", "Executable"),
	("PWT_imageRadio", "Image"),
	("PWT_modeLabel", "Mode:"),
	("PWT_moveDown", "Move Down"),
	("PWT_moveUp", "Move Up"),
	("PWT_objfileRadio", "Object File"),
	("PWT_relative", "Relative path names"),
	("PWT_removeDisabled", "Remove Selection"),
	("PWT_removeTarget", "Remove Target"),
	("PWT_typeLabel", "Target (destination) type:"),
	("PWT_targetsLabel", "List of current target sources in build order:"),

	(* Porject Properties - Subprojects Dialog *)
	("PWS_subprojLabel", "List of included subprojects:"),
	("PWS_addProj", "Add"),
	("PWS_removeProj", "Remove"),
	("PWS_openProj", "Open"),
	("PWS_backProj", "Back"),
	("PWS_relProj", "Relative path names"),

	(* Project Properties - Modes Dialog *)
	("PWM_modeLabel", "List of modes:"),
	("PWM_removeMode", "Remove Selected Mode"),
	("PWM_setCurMode", "Set as Current"),
	("PWM_addMode", "Add New Mode"),
	("PWM_modeDetailsLabel", "Details of selected mode:"),
	("PWM_locChange", "Set name of directory"),

	("PWM_genInterruptCode", "Compile for interruptable loops"),
	("PWM_genInterceptCode", "Compile for tracing and call-counting"),
	("PWM_genDebugInfo", "Generate debug information"),
	("PWM_genVarDebugInfo", "Generate variable debug information"),
	("PWM_optLeaf", "Optimize leaf functions"),
	("PWM_optTail", "Optimize tail calls"),
	("PWM_optSelfTail", "Optimize self tail calls"),

	(* Project Properties - Configurations Dialog *)
	("PWC_addBinLoc", "Set Binaries Location"),
	("PWC_addConfig", "Add New Configuration"),
	("PWC_configLabel", "List of configurations:"),
	("PWC_files", "Files in Configuration"),
	("PWC_libraryLabel", "Library path for selected configuration:"),
	("PWC_libraryPath", "Set Library Path"),
	("PWC_removeConfig", "Remove Selected Configuration"),
	("PWC_setCurConfig", "Set As Current"),

	(* Project Properties - About Dialog *)
	("PWA_descLabel", "Project description:"),
	("PWA_verLabel", "Project version information:"),

       (* Dependency graph menu *)
       ("expand_all", "&Expand All"),
       ("only_root", "Show Only &Root"),
       ("make_root", "&Make Selection Root"),
       ("original_root", "&Original Root"),
       ("layout_style", "&Layout Style"),
       ("cascading_layout", "&Cascading Layout"),
       ("tree_layout", "&Tree Layout"),

       (* Graph dialog *)
       ("indicate_hidden", "Indicate Hidden Children"),

       ("Cancel", "Exit MLWorks"),
       ("Help", "Cancel"),
       ("OK", "End GUI Session"),

       ("abandon", "&Abandon Current Definition"),
       ("abSyn","Abstract Syntax"),
       ("abandonButton","Abandon"),
       ("abort","&Abort"),
       ("abortButton","Abort"),
       ("abstractions","Abstractions"),
       ("action","&Action"),
       ("active","Linked"),
       ("addBreak", "Add Break Point"),
       ("addBreakTrace", "Add &Break/Trace Point"),
       ("addTrace", "Add Trace Point"),
       ("append","Append Selection"),
       ("apply","Apply"),
       ("autoSelection","&Auto-Update Tool"),
       ("backtrace", "Print &Backtrace"),
       ("barWidth","Bar width"),
       ("below","Below"),
       ("bottom","Bottom"),
       ("break","Breakpoint..."),
       ("breakTrace","&Break/Trace\tF10"),
       ("breakTraceButton", "Add Break/Trace Point"),
       ("breakTraceItem", "Name"),
       ("browseContext","Browse"),
       ("cancel","Cancel"),
       ("centre","Centre"),
       ("hcentre","Centre"),
       ("vcentre","Centre"),
       ("childPosition","Child Position"),
       ("clearButton","Clear"),
       ("clear_console","Clear Lo&g"),
       ("clear_def", "&Clear Current Definition"),
       ("close","&Close Window\tF4"),
       ("closeButton","Close"),
       ("compatibility","C&ompatibility..."),
       ("compatibilityMode","Compatibility"),
       ("compatibilityOptionsLabel","Compatibility Preferences"),
       ("compiler","&Compiler..."),
       ("compilerOptionsLabel","Compiler Preferences"),
       ("completionMenu","Use completion menu"),
       ("console","Log/Console"),
       ("content_type","Type"),
       ("content_value","Value"),
       ("context","&Context"),
       ("contextSelect","Select"),
       ("contextBrowser","&Context Browser\tF7"),
       ("contextWindow","&History\tF9"),
       ("continue","&Continue"),
       ("continueButton","Continue"),
       ("copy","&Copy\tCtrl+C"),
       ("current","Current"),
       ("custom_editor_name","Custom Editor Name"),
       ("cut","Cu&t\tCtrl+X"),
       ("debug_menu", "&Debug"),
       ("debuggerArgsLabel","Local Variables"),
       ("debuggerFramesLabel","Stack (grows upwards)"),
       ("debugging","Debugging"),
       ("defaultOverloads","Default types for overloaded operators"),
       ("default_visibility","Expand all children"),
       ("delete","&Delete Selection\tDel"),
       ("deleteAll","Delete &All"),
       ("deleteAllButton","Delete All Items"),
       ("deleteSelection","Remo&ve Selected Unit"),
       ("deleteSelectedButton","Remove Selected Item"),
       ("dismiss","Dismiss"),
       ("displayEntryTypes","Display Types of Entries"),
       ("duplicate","&Duplicate Tool"),
       ("edit","&Edit"),
       ("editButton","Edit"),
       ("editSource", "&Edit Source"),
       ("edit_error","Edit E&rror"),
       ("edit_frame","&Edit"),
       ("editor","&Editor..."),
       ("editorOptionsLabel","Editor Preferences"),
       ("editSelection","&Edit Selection"),
       ("environment","&General..."),
       ("environmentOptionsLabel","Miscellaneous Preferences"),
       ("eof","EOF"),
       ("error","E&rror"),
       ("errorTextLabel","Details"),
       ("evaluate", "&Evaluate"),
       ("evaluateButton","Evaluate"),
       ("exit","E&xit\tAlt+F4"),
       ("extensions","&Extensions..."),
       ("extensionsOptionsLabel","Extensions Preferences"),
       ("external_editor_command","External Editor Command"),
       ("file","&File"),
       ("fileBrowser","&File Tool"),
       ("filter","&Browser Filters..."),
       ("filterFrames","Debugger &Filters..."),
       ("fixitySpecs","Fixity directives in signatures"),
       ("floatPrecision","Precision of reals "),
       ("functionStepper","Function Stepper"),
       ("functor","Functor"),
       ("functors","Functors"),
       ("general", "&General Preferences"),
       ("generateDebugInfo","Generate debug information"),
       ("generateInterceptableCode","Compile for tracing and call-counting"),
       ("generateInterruptableCode","Compile for interruptible loops"),
       ("generateVariableDebugInfo","Generate variable debug information"),
       ("graph","&Graph Layout..."),
       ("graphLabel","Components"),
       ("graph_arity","Max. node arity"),
       ("graph_depth","Max. graph depth"),
       ("graph_seln_posn","Selection &Position..."),
       ("graph_sharing","Share equal values"),
       ("group","Group"),
       ("help_menu", "&Help"),
       ("hide","Hide"),
       ("hideAnonymousFrames","Hide anonymous frames"),
       ("hideCFrames","Hide C frames"),
       ("hideDeliveredFrames","Hide delivered frames"),
       ("hideHandlerFrames","Hide handler frames"),
       ("hideSetupFrames","Hide setup frames"),
       ("hideDuplicateFrames","Hide duplicate frames"),
       ("history","Hi&story"),
       ("historyTitleLabel","History"),
       ("horizontal","Horizontal"),
       ("horizontalSelection","Horizontal Selection"),
       ("horizontalSpacing","Horizontal"),
       ("idealLabelSpace","Ideal label spacing"),
       ("initialBrowser","&System Browser\tF8"),
       ("initialContext","New"),
       ("input","Input"),
       ("inputLabel","New input"),
       ("inputTitleLabel","Program"),
       ("insert","Insert Selection"),
       ("insp_item","In&spector..."),
       ("inspect","&Inspect"),
       ("inspectFrameInfo","&Inspect"),
       ("inspector","Inspector"),
       ("installationHelp", "&Installation"),
       ("internals","In&ternals..."),
       ("internalsOptionsLabel","Internals Options"),
       ("interruptButton","Interrupt"),
       ("intervalStepper","Interval Stepper"),
       ("itemSearch","Search for Item"),
       ("label","Messages"),
       ("labelOffset","Offset"),
       ("lambda","Lambda Code"),
       ("lambdaEnv","Lambda Environment"),
       ("language","&Language..."),
       ("layout","&Profiler Layout..."),
       ("left","Left"),
       ("lineStyle","Line Style:"),
       ("listLabel","Files:"),
       (*
       ("listener","&Listener\tAlt+L"),
       *)
       ("listener","&Listener\tF5"),
       ("listener_menu", "&Listener"),
       ("listen_props", "P&roperties"),
       ("local","Local"),
       ("make","Make"),
       ("makefull","Make..."),
       ("main","&Main"),
       ("maximumBars","Maximum number of bars"),
       ("maximumBreaks", "No. of breakpoints to skip"),
       ("maximumDepth","Maximum depth"),
       ("maximumHistoryLength","Maximum history length"),
       ("maximumNumberErrors","Maximum number of errors"),
       ("maximumRefDepth","Maximum ref depth"),
       ("maximumSeqSize","Maximum sequence size"),
       ("maximumStrDepth","Maximum structure depth"),
       ("maximumSigDepth","Maximum signature depth"),
       ("maximumStringSize","Maximum string size"),
       ("maximumTickSpace","Maximum tick spacing"),
       ("mipsR4000","Compile for MIPS R4000 and later"),
       ("mir","MIR Code"),
       ("mode","&Mode..."),
       ("modeOptionsLabel","Mode Preferences"),
       ("module","&Build"),
       ("moduleTitleLabel","Module"),
       ("moveto","Select"),
       ("next","&Next"),
       ("nextButton","Next"),
       ("next_def", "&Next Definition"),
       ("njSignatures","Limited `open' in signatures"),
       ("hnone","No Policy"),
       ("vnone","No Policy"),
       ("object","Object Code"),
       ("objectPath","Object Path"),
       ("ok","OK"),
       ("oldDefinition","SML 1990"),
       ("opInDatatype","`op' optional when unambiguous"),
       ("openFixity","Include fixity in `open'"),
       ("optLambda","Optimized Lambda Code"),
       ("optMir","Optimized MIR Code"),
       ("optimizeLeafFns","Optimize leaf functions"),
       ("optimizeSelfTailCalls","Optimize self tail calls"),
       ("optimizeTailCalls","Optimize tail calls"),
       ("optimizing","Optimizing"),
       ("options","&Details"),
       ("orientation","Orientation:"),
       ("origin","Origin"),
       ("horigin","Origin"),
       ("vorigin","Origin"),
       ("original","Original Root"),
       ("outputTitleLabel","Result"),
       ("parent","Parent"),
       ("paste","&Paste\tCtrl+V"),
       ("pathLabel","Source Path"),
       ("peel", "&Peel Off Function Profile"),
       ("peelButton","Peel Off"),
       ("popContext","Previous"),
       ("prevButton","Previous"),
       ("previousRoots","Previous Roots"),
       ("previous_def", "&Previous Definition"),
       ("profileButton","Profile"),
       ("profile", "Pro&file Evaluation"),
       ("project","Project"),
       ("project_menu", "&Project"),
       ("projWorkspace","&Project Workspace\tF6"),
       ("pushContext","Copy"),
       ("query","&Query"),
       ("quit","Quit"),
       ("read_depend","&Read Dependencies"),
       ("redo","&Redo"),
       ("referenceMan", "Reference &Manual"),
       ("releaseNotes", "&Release Notes"),
       ("removeAllBreakTrace", "Remove A&ll Break/Trace Points"),
       ("removeAllUnits", "Remove All &Units"),
       ("removeDuplicates","Remove D&uplicates"),
       ("removeUnit", "Remove Selected Unit"),
       ("repeat", "&Repeat Last Evaluation"),
       ("requireKeyword","`require' reserved word"),
       ("reset","Reset"),
       ("resultTitleLabel","Result"),
       ("right","Right"),
       ("roots","Roots"),
       ("save","Sa&ve Listener Input"),
       ("saveAs","Save Listener &Input As..."),
       ("saveImage","Sav&e Session As..."),
       ("savePreferences","&Save Preferences"),
       ("search","&Find..."),
       ("searchPervasives", "Search System Context"),
       ("searchUserContext","Search User Context"),
       ("select_emacs_server","Emacs Server"),
       ("select_vi","Vi"),
       ("select_external_editor","External"),
       ("select_custom_editor","Custom"),
       ("selectionLabel","Selection"),
       ("send","OK"),
       ("senseContext","Sense Context"),
       ("senseSelection","Sense Selection"),
       ("sensitivity","Sensitivity..."),
       ("sensitivityOptionsLabel","Sensitivity Options"),
       ("setBreakpoint","Enter Function Name:"),
       ("setBreakpointDialog","Set breakpoint"),
       ("setContext","Set Context"),
       ("setSelection","Set Selection"),
       ("setObjectPath","&Object Path..."),
       ("setWD","Current &Directory..."),
       ("settings","&Settings"),
       ("setup","P&references"),
       ("showAbsyn","Show abstract syntax"),
       ("showDebugInfo","Show debug info"),
       ("showEnviron","Show lambda environment"),
       ("showEqInfo","Show equality info"),
       ("showExnDetails","Show exception details"),
       ("showFnDetails","Show function details"),
       ("showFrameInfo","&Information..."),
       ("show_graph","&Dependencies of Selection"),
       ("show_defn","&View Source"),
       ("showIdClass","Show identifier class"),
       ("showLambda","Show lambda code"),
       ("showMach","Show object code"),
       ("showMir","Show MIR code"),
       ("showOptLambda","Show optimized lambda code"),
       ("showOptMir","Show optimized MIR code"),
       ("showVariableDebugInfo","Show variable info"),
       ("show_all","Expand all children"),
       ("show_atoms","Show atomic entries"),
       ("show_conenvs","Show constructor environments"),
       ("show_cons","Show constructors"),
       ("show_exns","Show exceptions"),
       ("show_funs","Show functors"),
       ("show_sigs","Show signatures"),
       ("show_strs","Show structures"),
       ("show_types","Show types"),
       ("show_vars","Show variables"),
       ("signature","Signature"),
       ("signatures","Signatures"),
       ("slider","Slider"),
       ("sml_90","SML '90"),
       ("sml_97","SML '97"),
       ("sort","S&ort"),
       ("sourcepath","Source Path"),
       ("sourceTitleLabel","Source"),
       ("spaceButton","Space"),
       ("sparcV7","Compile for SPARC V7"),
       ("srcTitleLabel","Source"),
       ("step","&Step"),
       ("stepButton","Step"),
       ("stepEval", "&Step Evaluation"),
       ("straight","Straight"),
       ("structure","Structure"),
       ("time", "&Time Evaluation"),
       ("timeButton","Time"),
       ("toggleMode","Toggle Mode"),
       ("tools","&Tools"),
       ("tool_settings", "&Tool Settings"),
       ("top","Top"),
       ("topLevel","Top Level"),
       ("toplevel","Top Level"),
       ("trace","&Trace"),
       ("typeCheck","Type Check"),
       ("typeDynamic","Type `&dynamic'"),
       ("typeTitleLabel","Type"),
       ("unit","Unit"),
       ("undo","Undo"),
       ("untrace","&Untrace"),
       ("update","Update"),
       ("usage_menu", "&Usage"),
       ("use","&Read Into Listener..."),
       ("useDebugger","Use debugger"),
       ("useErrorBrowser","Use error browser"),
       ("useRelativePathname","Relative pathnames in use"),
       ("userGuide", "&User Guide"),
       ("valTitleLabel","Value"),
       ("value","&Action"),
       ("valuePrinterOptionsLabel","Value Printer Options"),
       ("valueprinter","&Value Printer..."),
       ("vertical","Vertical"),
       ("verticalSelection","Vertical Selection"),
       ("verticalSpacing","Vertical"),
       ("view","&View"),
       ("visible","Visible"),
       ("weakTyvars","Weak type variables"),
       ("window","Window"),
       ("windowDebugger","Always use window debugger"),
       ("windows","&Windows")]

    (* Funny things happen if we don't use FVIRTKEY here *)
    val accelerator_list =
      [("previous_def",[WindowsGui.FALT,WindowsGui.FVIRTKEY],ord #"P"),
       ("next_def",[WindowsGui.FALT,WindowsGui.FVIRTKEY],ord #"N"),
       ("cut",[WindowsGui.FCONTROL,WindowsGui.FVIRTKEY],ord #"X"),
       ("copy",[WindowsGui.FCONTROL,WindowsGui.FVIRTKEY],ord #"C"),
       ("paste",[WindowsGui.FCONTROL,WindowsGui.FVIRTKEY],ord #"V"),
       ("save_proj",[WindowsGui.FCONTROL,WindowsGui.FVIRTKEY],ord #"S"),
       ("save_proj_as",[WindowsGui.FCONTROL,WindowsGui.FVIRTKEY],ord #"A"),

       ("close", [WindowsGui.FVIRTKEY],VK_F4),

       ("listener", [WindowsGui.FVIRTKEY], VK_F5),
       ("projWorkspace", [WindowsGui.FVIRTKEY], VK_F6),
       ("contextBrowser", [WindowsGui.FVIRTKEY], VK_F7),
       ("initialBrowser", [WindowsGui.FVIRTKEY], VK_F8),
       ("contextWindow", [WindowsGui.FVIRTKEY], VK_F9),
       ("breakTrace", [WindowsGui.FVIRTKEY], VK_F10),

       ("exit",[WindowsGui.FALT,WindowsGui.FVIRTKEY],VK_F4),
       ("close",[WindowsGui.FCONTROL,WindowsGui.FVIRTKEY],VK_F4)]
(*
 ("delete",[WindowsGui.FVIRTKEY],46) (* Its magic *)
*)

    val title_list =
      [("breakpointManager","Breakpoint Manager"),
       ("traceManager","Trace Manager"),
       ("quitDialog","MLWorks Exit Dialog"),
       ("messageDialog","Message"),
       ("completions","Completions"),
       ("searchList","Matches"),
       ("functionProfile","Function Profile")]

    val label_actions =
      map (fn (name,_) => (name,WindowsGui.newControlId ())) label_strings

    exception LookupFailed

    fun lookup (name,[]) = raise LookupFailed
      | lookup (name,(name',id)::rest) =
        if name = name' then id else lookup (name,rest)

    fun get_title s = 
      lookup (s,title_list) handle LookupFailed => s

    val accelerators =
      map 
      (fn (label,flags,key) => (flags,key,WindowsGui.wordToInt (lookup (label,label_actions))))
      accelerator_list

    fun get_label name =
      let
        fun aux [] = name (* default to original name *)
          | aux ((name',label)::rest) =
            if name = name' then label
            else aux rest
      in
        aux label_strings
      end

    fun get_action name =
      let
        fun aux [] = (Terminal.output("No action id for " ^ name ^ "\n");
                      WindowsGui.newControlId ())
          | aux ((name',id)::rest) =
            if name = name'
              then id
            else aux rest
      in
        aux label_actions
      end
  end
