(*  ==== LAMBDA ENVIRONMENT/MODULE TRANSLATION ====
 *
 *  Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 *  All rights reserved.
 *  
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *  
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 *  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Description
 *  -----------
 *  These functions deal with the packaging up of a lambda environment and
 *  lambda bindings (usually the result of compiling some topdecs) into a
 *  single lambda expression and a special lambda environment.
 *
 *  Revision Log
 *  ------------
 *  $Log: lambdamodule.sml,v $
 *  Revision 1.1  1992/10/01 13:47:58  richard
 *  Initial revision
 *
 *)

require "environtypes";

signature LAMBDAMODULE =
  sig
    structure EnvironTypes : ENVIRONTYPES

    val pack :
      EnvironTypes.Top_Env * EnvironTypes.LambdaTypes.binding list ->
      EnvironTypes.Top_Env * EnvironTypes.LambdaTypes.LambdaExp

    val unpack :
      EnvironTypes.Top_Env * EnvironTypes.LambdaTypes.LambdaExp ->
      EnvironTypes.Top_Env * EnvironTypes.LambdaTypes.binding list
  end;
