(* host-db.sml
 *
 * This file includes parts which are Copyright (c) 1995 AT&T Bell 
 * Laboratories. All rights reserved.  
 *
 * $Log: host_db.sml,v $
 * Revision 1.2  1999/02/16 09:31:34  mitchell
 * [Bug #190508]
 * Improve layout
 *
 *  Revision 1.1  1999/02/15  14:08:04  mitchell
 *  new unit
 *  [Bug #190508]
 *  Add socket support to the basis library
 *
 *)

require "__string_cvt";

signature NET_HOST_DB =
  sig
    eqtype in_addr
    eqtype addr_family
    type entry

    val name     : entry -> string
    val aliases  : entry -> string list
    val addrType : entry -> addr_family
    val addr     : entry -> in_addr
    val addrs    : entry -> in_addr list
    val getByName: string -> entry option
    val getByAddr: in_addr -> entry option

    val getHostName: unit -> string

    val scan       : (char, 'a) StringCvt.reader 
                     -> (in_addr, 'a) StringCvt.reader
    val fromString : string -> in_addr option
    val toString   : in_addr -> string
  end



