(* Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file should be generated by a stub-generator from <ndbm.h>
 * This version has been written by hand.
 *
 * Revision Log
 * ------------
 * $Log: ndbm.sml,v $
 * Revision 1.2  1997/07/03 08:14:04  stephenb
 * [Bug #30029]
 * The previous version used the signatures/structures from
 * the prototype version the new FI.  This version uses the
 * signatures/structures that a customer will see.
 *
 *  Revision 1.1  1997/04/29  14:52:21  stephenb
 *  new unit
 *  [Bug #30030]
 *
 *)
 
require "$.basis.__word";

signature NDBM =
  sig
    eqtype DBM
    eqtype datum

    eqtype c_int
    eqtype c_uint
    eqtype c_char
    eqtype 'a c_ptr
 
    (* DBM utilities *)
    val DBM'size' : Word.word
    val DBM'addr' : DBM -> DBM c_ptr

    (* datum utilities *)
    val datum'size' : Word.word
    val datum'addr' : datum -> datum c_ptr

    (* DBM field addresses *)
    val DBM'dbm_dirf'addr : DBM -> c_int c_ptr
    val DBM'dbm_pagf'addr : DBM -> c_int c_ptr
    (* ... *)

    (* dbm field values *)
    val DBM'dbm_dirf : DBM -> c_int
    val DBM'dbm_pagf : DBM -> c_int
    (* ... *)

    (* datum field addresses *)
    val datum'dptr'addr : datum -> c_char c_ptr c_ptr
    val datum'dsize'addr : datum -> c_uint c_ptr

    (* datum field values *)
    val datum'dptr : datum -> c_char c_ptr
    val datum'dsize : datum -> c_uint


    val DBM_INSERT  : c_int
    val DBM_REPLACE : c_int

    val dbm_open :  c_char c_ptr * c_int * c_int -> DBM c_ptr
    val dbm_store : DBM c_ptr * datum * datum * c_int -> c_int
    val dbm_delete : DBM c_ptr * datum -> c_int
    val dbm_fetch : DBM c_ptr * datum -> datum
    val dbm_firstkey : DBM c_ptr -> datum
    val dbm_nextkey : DBM c_ptr -> datum
    val dbm_error : DBM c_ptr -> c_int
    val dbm_clearerr : DBM c_ptr -> c_int
    val dbm_close : DBM c_ptr -> unit
  end
