(* Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file should be generated by a stub-generator from <ndbm.h>
 * The current version has been written by hand.
 *
 * Revision Log
 * ------------
 * $Log: __ndbm.sml,v $
 * Revision 1.2  1997/07/03 08:14:32  stephenb
 * [Bug #30029]
 * The previous version used the signatures/structures from
 * the prototype version the new FI.  This version uses the
 * signatures/structures that a customer will see.
 *
 *  Revision 1.1  1997/04/29  14:49:42  stephenb
 *  new unit
 *  [Bug #30030]
 *
 *)

require "$.basis.__word";
require "$.foreign.__mlworks_dynamic_library";
require "$.foreign.__mlworks_c_interface";
require "ndbm";
require "__ndbm_stub";


structure Ndbm : NDBM =
  struct
    (* C' is just here to make the code shorter and easier to write.
     * Whether the stub generated version uses this is an up to 
     * the stub generator writer
     *)
    structure C' = MLWorksCInterface

    type c_int = C'.Int.int
    type c_uint = C'.Uint.word
    type c_char = C'.Char.char
    type 'a c_ptr = 'a C'.ptr

    fun scale'' offset addr = C'.next (addr, offset)

    datatype DBM = DBM of C'.void c_ptr

    datatype datum = DATUM of C'.void c_ptr

    (* Hidden utility functions *)
      
    fun DBM'toRep' (DBM addr) = addr

    fun datum'toRep' (DATUM addr) = addr

    (* dbm utilities *)

    val DBM'size' = 0w11 * 0w4 + 0w1024 + 0w4096

    val DBM'addr' = C'.fromVoidPtr o DBM'toRep'

    (* datum utilities *)

    val datum'size' : Word.word = 0w8

    val datum'addr' : datum -> datum c_ptr = C'.fromVoidPtr o datum'toRep'

    (* Fields Addresses *)

    val DBM'dbm_dirf'addr : DBM -> c_int c_ptr = 
      C'.fromVoidPtr o scale'' 0w0 o DBM'toRep'
    
    val DBM'dbm_pagf'addr : DBM -> c_int c_ptr = 
      C'.fromVoidPtr o scale'' 0w4 o DBM'toRep'

    (* ... *)

    (* Field Values *)

    val DBM'dbm_dirf : DBM -> c_int = 
      C'.IntPtr.! o DBM'dbm_dirf'addr
    
    val DBM'dbm_pagf : DBM -> c_int = 
      C'.IntPtr.! o DBM'dbm_pagf'addr
    
    (* ... *)


    (* Fields Addresses *)

    val datum'dptr'addr : datum -> c_char c_ptr c_ptr = 
      C'.fromVoidPtr o scale'' 0w0 o datum'toRep'

    val datum'dsize'addr : datum -> C'.Uint.word c_ptr =
      C'.fromVoidPtr o scale'' 0w4 o datum'toRep'


    (* Fields Values *)

    val datum'dptr : datum -> c_char c_ptr = 
      C'.PtrPtr.! o datum'dptr'addr

    val datum'dsize : datum -> C'.Uint.word =
      C'.UintPtr.! o datum'dsize'addr


    val DBM_INSERT = C'.Int.fromInt 0
    val DBM_REPLACE = C'.Int.fromInt 1

    val dbm_open : c_char c_ptr * c_int * c_int -> DBM c_ptr =
      MLWorksDynamicLibrary.bind "dbm_open"

    val dbm_store : DBM c_ptr * datum * datum * c_int -> c_int =
      MLWorksDynamicLibrary.bind "dbm_store"

    val dbm_delete : DBM c_ptr * datum -> c_int =
      MLWorksDynamicLibrary.bind "dbm_delete"

    val dbm_fetch : DBM c_ptr * datum -> datum =
      MLWorksDynamicLibrary.bind "dbm_fetch"

    val dbm_firstkey : DBM c_ptr -> datum =
      MLWorksDynamicLibrary.bind "dbm_firstkey"

    val dbm_nextkey : DBM c_ptr -> datum =
      MLWorksDynamicLibrary.bind "dbm_nextkey"

    val dbm_error : DBM c_ptr -> c_int =
      MLWorksDynamicLibrary.bind "dbm_error"

    val dbm_clearerr : DBM c_ptr -> c_int =
      MLWorksDynamicLibrary.bind "dbm_clearerr"

    val dbm_close : DBM c_ptr -> unit =
      MLWorksDynamicLibrary.bind "dbm_close"
    
  end
