/* Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file could/should be generated by a stub generator from <sys/dirent.h>
 * This version has been written by hand.
 *
 * Revision Log
 * ------------
 * $Log: dirent_stub.c,v $
 * Revision 1.1  1997/06/30 15:36:36  stephenb
 * new unit
 * ** No reason given. **
 *
 */

#include <dirent.h>
#include "mlw_ci.h"


static mlw_val mlw_stub_opendir(mlw_val arg)
{
  char *file_name= mlw_ci_char_ptr_to_charp(arg);
  DIR * dir= opendir(file_name);
  return mlw_ci_void_ptr_from_voidp((void *)dir);
}



static mlw_val mlw_stub_readdir(mlw_val arg)
{
  DIR *dir= (DIR *)mlw_ci_void_ptr_to_voidp(arg);
  struct dirent * result= readdir(dir);
  return mlw_ci_void_ptr_from_voidp(result);
}



static mlw_val mlw_stub_telldir(mlw_val arg)
{
  DIR *dir= (DIR *)mlw_ci_void_ptr_to_voidp(arg);
  long result= telldir(dir);
  return mlw_ci_long_from_long(result);
}



static mlw_val mlw_stub_seekdir(mlw_val arg)
{
  DIR *dir= (DIR *)mlw_ci_void_ptr_to_voidp(mlw_arg(arg, 0));
  long loc= mlw_ci_long_to_long(arg);
  seekdir(dir, loc);
  return mlw_val_unit;
}



static mlw_val mlw_stub_rewinddir(mlw_val arg)
{
  DIR *dir= (DIR *)mlw_ci_void_ptr_to_voidp(arg);
  rewinddir(dir);
  return mlw_val_unit;
}



static mlw_val mlw_stub_closedir(mlw_val arg)
{
  DIR *dir= (DIR *)mlw_ci_void_ptr_to_voidp(arg);
  closedir(dir);
  return mlw_val_unit;
}




mlw_ci_export void mlw_stub_init_dirent(void)
{
  mlw_ci_register_function("dirent_opendir",    mlw_stub_opendir);
  mlw_ci_register_function("dirent_readdir",    mlw_stub_readdir);
  mlw_ci_register_function("dirent_telldir",    mlw_stub_telldir);
  mlw_ci_register_function("dirent_seekdir",    mlw_stub_seekdir);
  mlw_ci_register_function("dirent_rewinddir",  mlw_stub_rewinddir);
  mlw_ci_register_function("dirent_closedir",   mlw_stub_closedir);
}
