import java.io.*;
import java.util.*;
public enum UnicodeScript {
COMMON,
LATIN,
GREEK,
CYRILLIC,
ARMENIAN,
HEBREW,
ARABIC,
SYRIAC,
THAANA,
DEVANAGARI,
BENGALI,
GURMUKHI,
GUJARATI,
ORIYA,
TAMIL,
TELUGU,
KANNADA,
MALAYALAM,
SINHALA,
THAI,
LAO,
TIBETAN,
MYANMAR,
GEORGIAN,
HANGUL,
ETHIOPIC,
CHEROKEE,
CANADIAN_ABORIGINAL,
OGHAM,
RUNIC,
KHMER,
MONGOLIAN,
HIRAGANA,
KATAKANA,
BOPOMOFO,
HAN,
YI,
OLD_ITALIC,
GOTHIC,
DESERET,
INHERITED,
TAGALOG,
HANUNOO,
BUHID,
TAGBANWA,
LIMBU,
TAI_LE,
LINEAR_B,
UGARITIC,
SHAVIAN,
OSMANYA,
CYPRIOT,
BRAILLE,
BUGINESE,
COPTIC,
NEW_TAI_LUE,
GLAGOLITIC,
TIFINAGH,
SYLOTI_NAGRI,
OLD_PERSIAN,
KHAROSHTHI,
BALINESE,
CUNEIFORM,
PHOENICIAN,
PHAGS_PA,
NKO,
SUNDANESE,
BATAK,
LEPCHA,
OL_CHIKI,
VAI,
SAURASHTRA,
KAYAH_LI,
REJANG,
LYCIAN,
CARIAN,
LYDIAN,
CHAM,
TAI_THAM,
TAI_VIET,
AVESTAN,
EGYPTIAN_HIEROGLYPHS,
SAMARITAN,
MANDAIC,
LISU,
BAMUM,
JAVANESE,
MEETEI_MAYEK,
IMPERIAL_ARAMAIC,
OLD_SOUTH_ARABIAN,
INSCRIPTIONAL_PARTHIAN,
INSCRIPTIONAL_PAHLAVI,
OLD_TURKIC,
BRAHMI,
KAITHI,
MEROITIC_HIEROGLYPHS,
MEROITIC_CURSIVE,
SORA_SOMPENG,
CHAKMA,
SHARADA,
TAKRI,
MIAO,
UNKNOWN;
private static final int[] scriptStarts = {
0x0000,
0x0041,
0x005B,
0x0061,
0x007B,
0x00AA,
0x00AB,
0x00BA,
0x00BB,
0x00C0,
0x00D7,
0x00D8,
0x00F7,
0x00F8,
0x02B9,
0x02E0,
0x02E5,
0x02EA,
0x02EC,
0x0300,
0x0370,
0x0374,
0x0375,
0x037E,
0x0384,
0x0385,
0x0386,
0x0387,
0x0388,
0x03E2,
0x03F0,
0x0400,
0x0485,
0x0487,
0x0531,
0x0589,
0x058A,
0x0591,
0x0600,
0x060C,
0x060D,
0x061B,
0x061E,
0x061F,
0x0620,
0x0640,
0x0641,
0x064B,
0x0656,
0x065F,
0x0660,
0x066A,
0x0670,
0x0671,
0x06DD,
0x06DE,
0x0700,
0x0750,
0x0780,
0x07C0,
0x0800,
0x0840,
0x08A0,
0x0900,
0x0951,
0x0953,
0x0964,
0x0966,
0x0981,
0x0A01,
0x0A81,
0x0B01,
0x0B82,
0x0C01,
0x0C82,
0x0D02,
0x0D82,
0x0E01,
0x0E3F,
0x0E40,
0x0E81,
0x0F00,
0x0FD5,
0x0FD9,
0x1000,
0x10A0,
0x10FB,
0x10FC,
0x1100,
0x1200,
0x13A0,
0x1400,
0x1680,
0x16A0,
0x16EB,
0x16EE,
0x1700,
0x1720,
0x1735,
0x1740,
0x1760,
0x1780,
0x1800,
0x1802,
0x1804,
0x1805,
0x1806,
0x18B0,
0x1900,
0x1950,
0x1980,
0x19E0,
0x1A00,
0x1A20,
0x1B00,
0x1B80,
0x1BC0,
0x1C00,
0x1C50,
0x1CC0,
0x1CD0,
0x1CD3,
0x1CD4,
0x1CE1,
0x1CE2,
0x1CE9,
0x1CED,
0x1CEE,
0x1CF4,
0x1CF5,
0x1D00,
0x1D26,
0x1D2B,
0x1D2C,
0x1D5D,
0x1D62,
0x1D66,
0x1D6B,
0x1D78,
0x1D79,
0x1DBF,
0x1DC0,
0x1E00,
0x1F00,
0x2000,
0x200C,
0x200E,
0x2071,
0x2074,
0x207F,
0x2080,
0x2090,
0x20A0,
0x20D0,
0x2100,
0x2126,
0x2127,
0x212A,
0x212C,
0x2132,
0x2133,
0x214E,
0x214F,
0x2160,
0x2189,
0x2800,
0x2900,
0x2C00,
0x2C60,
0x2C80,
0x2D00,
0x2D30,
0x2D80,
0x2DE0,
0x2E00,
0x2E80,
0x2FF0,
0x3005,
0x3006,
0x3007,
0x3008,
0x3021,
0x302A,
0x302E,
0x3030,
0x3038,
0x303C,
0x3041,
0x3099,
0x309B,
0x309D,
0x30A0,
0x30A1,
0x30FB,
0x30FD,
0x3105,
0x3131,
0x3190,
0x31A0,
0x31C0,
0x31F0,
0x3200,
0x3220,
0x3260,
0x327F,
0x32D0,
0x3358,
0x3400,
0x4DC0,
0x4E00,
0xA000,
0xA4D0,
0xA500,
0xA640,
0xA6A0,
0xA700,
0xA722,
0xA788,
0xA78B,
0xA800,
0xA830,
0xA840,
0xA880,
0xA8E0,
0xA900,
0xA930,
0xA960,
0xA980,
0xAA00,
0xAA60,
0xAA80,
0xAAE0,
0xAB01,
0xABC0,
0xAC00,
0xD7FC,
0xF900,
0xFB00,
0xFB13,
0xFB1D,
0xFB50,
0xFD3E,
0xFD50,
0xFDFD,
0xFE00,
0xFE10,
0xFE20,
0xFE30,
0xFE70,
0xFEFF,
0xFF21,
0xFF3B,
0xFF41,
0xFF5B,
0xFF66,
0xFF70,
0xFF71,
0xFF9E,
0xFFA0,
0xFFE0,
0x10000,
0x10100,
0x10140,
0x10190,
0x101FD,
0x10280,
0x102A0,
0x10300,
0x10330,
0x10380,
0x103A0,
0x10400,
0x10450,
0x10480,
0x10800,
0x10840,
0x10900,
0x10920,
0x10980,
0x109A0,
0x10A00,
0x10A60,
0x10B00,
0x10B40,
0x10B60,
0x10C00,
0x10E60,
0x11000,
0x11080,
0x110D0,
0x11100,
0x11180,
0x11680,
0x12000,
0x13000,
0x16800,
0x16F00,
0x1B000,
0x1B001,
0x1D000,
0x1D167,
0x1D16A,
0x1D17B,
0x1D183,
0x1D185,
0x1D18C,
0x1D1AA,
0x1D1AE,
0x1D200,
0x1D300,
0x1EE00,
0x1F000,
0x1F200,
0x1F201,
0x20000,
0xE0001,
0xE0100,
0xE01F0
};
private static final UnicodeScript[] scripts = {
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
BOPOMOFO,
COMMON,
INHERITED,
GREEK,
COMMON,
GREEK,
COMMON,
GREEK,
COMMON,
GREEK,
COMMON,
GREEK,
COPTIC,
GREEK,
CYRILLIC,
INHERITED,
CYRILLIC,
ARMENIAN,
COMMON,
ARMENIAN,
HEBREW,
ARABIC,
COMMON,
ARABIC,
COMMON,
ARABIC,
COMMON,
ARABIC,
COMMON,
ARABIC,
INHERITED,
ARABIC,
INHERITED,
COMMON,
ARABIC,
INHERITED,
ARABIC,
COMMON,
ARABIC,
SYRIAC,
ARABIC,
THAANA,
NKO,
SAMARITAN,
MANDAIC,
ARABIC,
DEVANAGARI,
INHERITED,
DEVANAGARI,
COMMON,
DEVANAGARI,
BENGALI,
GURMUKHI,
GUJARATI,
ORIYA,
TAMIL,
TELUGU,
KANNADA,
MALAYALAM,
SINHALA,
THAI,
COMMON,
THAI,
LAO,
TIBETAN,
COMMON,
TIBETAN,
MYANMAR,
GEORGIAN,
COMMON,
GEORGIAN,
HANGUL,
ETHIOPIC,
CHEROKEE,
CANADIAN_ABORIGINAL,
OGHAM,
RUNIC,
COMMON,
RUNIC,
TAGALOG,
HANUNOO,
COMMON,
BUHID,
TAGBANWA,
KHMER,
MONGOLIAN,
COMMON,
MONGOLIAN,
COMMON,
MONGOLIAN,
CANADIAN_ABORIGINAL,
LIMBU,
TAI_LE,
NEW_TAI_LUE,
KHMER,
BUGINESE,
TAI_THAM,
BALINESE,
SUNDANESE,
BATAK,
LEPCHA,
OL_CHIKI,
SUNDANESE,
INHERITED,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
LATIN,
GREEK,
CYRILLIC,
LATIN,
GREEK,
LATIN,
GREEK,
LATIN,
CYRILLIC,
LATIN,
GREEK,
INHERITED,
LATIN,
GREEK,
COMMON,
INHERITED,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
INHERITED,
COMMON,
GREEK,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
BRAILLE,
COMMON,
GLAGOLITIC,
LATIN,
COPTIC,
GEORGIAN,
TIFINAGH,
ETHIOPIC,
CYRILLIC,
COMMON,
HAN,
COMMON,
HAN,
COMMON,
HAN,
COMMON,
HAN,
INHERITED,
HANGUL,
COMMON,
HAN,
COMMON,
HIRAGANA,
INHERITED,
COMMON,
HIRAGANA,
COMMON,
KATAKANA,
COMMON,
KATAKANA,
BOPOMOFO,
HANGUL,
COMMON,
BOPOMOFO,
COMMON,
KATAKANA,
HANGUL,
COMMON,
HANGUL,
COMMON,
KATAKANA,
COMMON,
HAN,
COMMON,
HAN,
YI,
LISU,
VAI,
CYRILLIC,
BAMUM,
COMMON,
LATIN,
COMMON,
LATIN,
SYLOTI_NAGRI,
COMMON,
PHAGS_PA,
SAURASHTRA,
DEVANAGARI,
KAYAH_LI,
REJANG,
HANGUL,
JAVANESE,
CHAM,
MYANMAR,
TAI_VIET,
MEETEI_MAYEK,
ETHIOPIC,
MEETEI_MAYEK,
HANGUL,
UNKNOWN ,
HAN,
LATIN,
ARMENIAN,
HEBREW,
ARABIC,
COMMON,
ARABIC,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
ARABIC,
COMMON,
LATIN,
COMMON,
LATIN,
COMMON,
KATAKANA,
COMMON,
KATAKANA,
COMMON,
HANGUL,
COMMON,
LINEAR_B,
COMMON,
GREEK,
COMMON,
INHERITED,
LYCIAN,
CARIAN,
OLD_ITALIC,
GOTHIC,
UGARITIC,
OLD_PERSIAN,
DESERET,
SHAVIAN,
OSMANYA,
CYPRIOT,
IMPERIAL_ARAMAIC,
PHOENICIAN,
LYDIAN,
MEROITIC_HIEROGLYPHS,
MEROITIC_CURSIVE,
KHAROSHTHI,
OLD_SOUTH_ARABIAN,
AVESTAN,
INSCRIPTIONAL_PARTHIAN,
INSCRIPTIONAL_PAHLAVI,
OLD_TURKIC,
ARABIC,
BRAHMI,
KAITHI,
SORA_SOMPENG,
CHAKMA,
SHARADA,
TAKRI,
CUNEIFORM,
EGYPTIAN_HIEROGLYPHS,
BAMUM,
MIAO,
KATAKANA,
HIRAGANA,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
INHERITED,
COMMON,
GREEK,
COMMON,
ARABIC,
COMMON,
HIRAGANA,
COMMON,
HAN,
COMMON,
INHERITED,
UNKNOWN
};
private static HashMap<String, UnicodeScript> aliases=
new HashMap<String, UnicodeScript>();
static {
aliases.put("ARAB", ARABIC);
aliases.put("ARMI", IMPERIAL_ARAMAIC);
aliases.put("ARMN", ARMENIAN);
aliases.put("AVST", AVESTAN);
aliases.put("BALI", BALINESE);
aliases.put("BAMU", BAMUM);
aliases.put("BATK", BATAK);
aliases.put("BENG", BENGALI);
aliases.put("BOPO", BOPOMOFO);
aliases.put("BRAI", BRAILLE);
aliases.put("BRAH", BRAHMI);
aliases.put("BUGI", BUGINESE);
aliases.put("BUHD", BUHID);
aliases.put("CAKM", CHAKMA);
aliases.put("CANS", CANADIAN_ABORIGINAL);
aliases.put("CARI", CARIAN);
aliases.put("CHAM", CHAM);
aliases.put("CHER", CHEROKEE);
aliases.put("COPT", COPTIC);
aliases.put("CPRT", CYPRIOT);
aliases.put("CYRL", CYRILLIC);
aliases.put("DEVA", DEVANAGARI);
aliases.put("DSRT", DESERET);
aliases.put("EGYP", EGYPTIAN_HIEROGLYPHS);
aliases.put("ETHI", ETHIOPIC);
aliases.put("GEOR", GEORGIAN);
aliases.put("GLAG", GLAGOLITIC);
aliases.put("GOTH", GOTHIC);
aliases.put("GREK", GREEK);
aliases.put("GUJR", GUJARATI);
aliases.put("GURU", GURMUKHI);
aliases.put("HANG", HANGUL);
aliases.put("HANI", HAN);
aliases.put("HANO", HANUNOO);
aliases.put("HEBR", HEBREW);
aliases.put("HIRA", HIRAGANA);
aliases.put("ITAL", OLD_ITALIC);
aliases.put("JAVA", JAVANESE);
aliases.put("KALI", KAYAH_LI);
aliases.put("KANA", KATAKANA);
aliases.put("KHAR", KHAROSHTHI);
aliases.put("KHMR", KHMER);
aliases.put("KNDA", KANNADA);
aliases.put("KTHI", KAITHI);
aliases.put("LANA", TAI_THAM);
aliases.put("LAOO", LAO);
aliases.put("LATN", LATIN);
aliases.put("LEPC", LEPCHA);
aliases.put("LIMB", LIMBU);
aliases.put("LINB", LINEAR_B);
aliases.put("LISU", LISU);
aliases.put("LYCI", LYCIAN);
aliases.put("LYDI", LYDIAN);
aliases.put("MAND", MANDAIC);
aliases.put("MERC", MEROITIC_CURSIVE);
aliases.put("MERO", MEROITIC_HIEROGLYPHS);
aliases.put("MLYM", MALAYALAM);
aliases.put("MONG", MONGOLIAN);
aliases.put("MTEI", MEETEI_MAYEK);
aliases.put("MYMR", MYANMAR);
aliases.put("NKOO", NKO);
aliases.put("OGAM", OGHAM);
aliases.put("OLCK", OL_CHIKI);
aliases.put("ORKH", OLD_TURKIC);
aliases.put("ORYA", ORIYA);
aliases.put("OSMA", OSMANYA);
aliases.put("PHAG", PHAGS_PA);
aliases.put("PLRD", MIAO);
aliases.put("PHLI", INSCRIPTIONAL_PAHLAVI);
aliases.put("PHNX", PHOENICIAN);
aliases.put("PRTI", INSCRIPTIONAL_PARTHIAN);
aliases.put("RJNG", REJANG);
aliases.put("RUNR", RUNIC);
aliases.put("SAMR", SAMARITAN);
aliases.put("SARB", OLD_SOUTH_ARABIAN);
aliases.put("SAUR", SAURASHTRA);
aliases.put("SHAW", SHAVIAN);
aliases.put("SHRD", SHARADA);
aliases.put("SINH", SINHALA);
aliases.put("SORA", SORA_SOMPENG);
aliases.put("SUND", SUNDANESE);
aliases.put("SYLO", SYLOTI_NAGRI);
aliases.put("SYRC", SYRIAC);
aliases.put("TAGB", TAGBANWA);
aliases.put("TALE", TAI_LE);
aliases.put("TAKR", TAKRI);
aliases.put("TALU", NEW_TAI_LUE);
aliases.put("TAML", TAMIL);
aliases.put("TAVT", TAI_VIET);
aliases.put("TELU", TELUGU);
aliases.put("TFNG", TIFINAGH);
aliases.put("TGLG", TAGALOG);
aliases.put("THAA", THAANA);
aliases.put("THAI", THAI);
aliases.put("TIBT", TIBETAN);
aliases.put("UGAR", UGARITIC);
aliases.put("VAII", VAI);
aliases.put("XPEO", OLD_PERSIAN);
aliases.put("XSUX", CUNEIFORM);
aliases.put("YIII", YI);
aliases.put("ZINH", INHERITED);
aliases.put("ZYYY", COMMON);
aliases.put("ZZZZ", UNKNOWN);
};
private static final int ICU_UNKNOWN = 103;
private static short[] icuScripts = {
0,
25,
14,
8,
3,
19,
2,
34,
37,
10,
4,
16,
15,
31,
35,
36,
22,
26,
33,
38,
24,
39,
28,
12,
18,
11,
6,
40,
29,
32,
23,
27,
20,
22,
5,
17,
41,
30,
13,
9,
1,
42,
43,
44,
45,
48,
52,
49,
53,
51,
50,
47,
46,
55,
7,
59,
56,
60,
58,
61,
57,
62,
101,
91,
90,
87,
113,
63,
82,
109,
99,
111,
79,
110,
107,
104,
76,
66,
ICU_UNKNOWN,
127,
117,
71,
126,
84,
131,
130,
78,
ICU_UNKNOWN,
116,
133,
125,
122,
ICU_UNKNOWN,
65,
120,
86,
141,
152,
118,
151,
153,
ICU_UNKNOWN,
103
};
private static String getScriptName(UnicodeScript script) {
if (script==INHERITED) return "Inherited";
if (script==COMMON) return "Common";
if (script==UNKNOWN) return "Unknown";
Set<String> keys = aliases.keySet();
for (String key : keys) {
UnicodeScript val = aliases.get(key);
if (val == script) {
return key;
}
}
return "Unknown";
}
public static void main(String args[]) throws Exception {
BufferedWriter w =
new BufferedWriter(new FileWriter(new File("data.javapart")));
w.write("   private static int[] data = {"); w.newLine();
for (int i=0; i<scriptStarts.length;i++) {
int start = scriptStarts[i];
UnicodeScript scriptID = scripts[i];
int icuScriptCode = icuScripts[scriptID.ordinal()];
String name = getScriptName(scriptID);
String h = Integer.toHexString(start);
String line = "        0x0" + Integer.toHexString(start)+", "+ icuScriptCode+",";
String comment="//  " + name;
int pad = 24-line.length();
while (pad-->0) line=line+" ";
w.write(line+comment);
w.newLine();
}
w.write("    };"); w.newLine();
w.close();
}
}
