package com.sun.javafx.text;
public class ScriptMapper {
public static final int INVALID = -1;
public static final int COMMON = 0;
public static final int INHERITED = 1;
public static final int LATN = 25;
private static final int UNKNOWN = 103;
private static int cache;
public static synchronized int getScript(int codePoint) {
if (codePoint >= data[cache] && codePoint < data[cache+2]) {
return data[cache+1];
}
if (codePoint < CHAR_START || codePoint >= CHAR_LIMIT) {
return UNKNOWN;
}
int probe = dataPower;
int index = 0;
if (codePoint >= data[dataExtra]) {
index = dataExtra;
}
while (probe > 2) {
probe >>= 1;
if (codePoint >= data[index + probe]) {
index += probe;
}
}
cache = index;
return data[index+1];
}
private static final int MIN_LAYOUT_CHARCODE = 0x0300;
private static final int MAX_LAYOUT_CHARCODE = 0x206F;
public static boolean isComplexCharCode(int code) {
if (code < MIN_LAYOUT_CHARCODE || code > MAX_LAYOUT_CHARCODE) {
return false;
}
else if (code <= 0x036f) {
return true;
}
else if (code < 0x0590) {
return false;
}
else if (code <= 0x06ff) {
return true;
}
else if (code < 0x0900) {
return false;
}
else if (code <= 0x0e7f) {
return true;
}
else if (code < 0x0f00) {
return false;
}
else if (code <= 0x0fff) {
return true;
}
else if (code <= 0x109f) {
return true;
}
else if (code < 0x1100) {
return false;
}
else if (code <= 0x11ff) {
return true;
}
else if (code < 0x1780) {
return false;
}
else if (code <= 0x17ff) {
return true;
}
else if (code < 0x200c) {
return false;
}
else if (code <= 0x200d) {
return true;
}
else if (code >= 0x202a && code <= 0x202e) {
return true;
}
else if (code >= 0x206a && code <= 0x206f) {
return true;
}
return false;
}
private static int[] data = {
0x00, 0,
0x041, 25,
0x05b, 0,
0x061, 25,
0x07b, 0,
0x0aa, 25,
0x0ab, 0,
0x0ba, 25,
0x0bb, 0,
0x0c0, 25,
0x0d7, 0,
0x0d8, 25,
0x0f7, 0,
0x0f8, 25,
0x02b9, 0,
0x02e0, 25,
0x02e5, 0,
0x02ea, 5,
0x02ec, 0,
0x0300, 1,
0x0370, 14,
0x0374, 0,
0x0375, 14,
0x037e, 0,
0x0384, 14,
0x0385, 0,
0x0386, 14,
0x0387, 0,
0x0388, 14,
0x03e2, 7,
0x03f0, 14,
0x0400, 8,
0x0485, 1,
0x0487, 8,
0x0531, 3,
0x0589, 0,
0x058a, 3,
0x0591, 19,
0x0600, 2,
0x060c, 0,
0x060d, 2,
0x061b, 0,
0x061e, 2,
0x061f, 0,
0x0620, 2,
0x0640, 0,
0x0641, 2,
0x064b, 1,
0x0656, 2,
0x065f, 1,
0x0660, 0,
0x066a, 2,
0x0670, 1,
0x0671, 2,
0x06dd, 0,
0x06de, 2,
0x0700, 34,
0x0750, 2,
0x0780, 37,
0x07c0, 87,
0x0800, 126,
0x0840, 84,
0x08a0, 2,
0x0900, 10,
0x0951, 1,
0x0953, 10,
0x0964, 0,
0x0966, 10,
0x0981, 4,
0x0a01, 16,
0x0a81, 15,
0x0b01, 31,
0x0b82, 35,
0x0c01, 36,
0x0c82, 22,
0x0d02, 26,
0x0d82, 33,
0x0e01, 38,
0x0e3f, 0,
0x0e40, 38,
0x0e81, 24,
0x0f00, 39,
0x0fd5, 0,
0x0fd9, 39,
0x01000, 28,
0x010a0, 12,
0x010fb, 0,
0x010fc, 12,
0x01100, 18,
0x01200, 11,
0x013a0, 6,
0x01400, 40,
0x01680, 29,
0x016a0, 32,
0x016eb, 0,
0x016ee, 32,
0x01700, 42,
0x01720, 43,
0x01735, 0,
0x01740, 44,
0x01760, 45,
0x01780, 23,
0x01800, 27,
0x01802, 0,
0x01804, 27,
0x01805, 0,
0x01806, 27,
0x018b0, 40,
0x01900, 48,
0x01950, 52,
0x01980, 59,
0x019e0, 23,
0x01a00, 55,
0x01a20, 103,
0x01b00, 62,
0x01b80, 113,
0x01bc0, 63,
0x01c00, 82,
0x01c50, 109,
0x01cc0, 113,
0x01cd0, 1,
0x01cd3, 0,
0x01cd4, 1,
0x01ce1, 0,
0x01ce2, 1,
0x01ce9, 0,
0x01ced, 1,
0x01cee, 0,
0x01cf4, 1,
0x01cf5, 0,
0x01d00, 25,
0x01d26, 14,
0x01d2b, 8,
0x01d2c, 25,
0x01d5d, 14,
0x01d62, 25,
0x01d66, 14,
0x01d6b, 25,
0x01d78, 8,
0x01d79, 25,
0x01dbf, 14,
0x01dc0, 1,
0x01e00, 25,
0x01f00, 14,
0x02000, 0,
0x0200c, 1,
0x0200e, 0,
0x02071, 25,
0x02074, 0,
0x0207f, 25,
0x02080, 0,
0x02090, 25,
0x020a0, 0,
0x020d0, 1,
0x02100, 0,
0x02126, 14,
0x02127, 0,
0x0212a, 25,
0x0212c, 0,
0x02132, 25,
0x02133, 0,
0x0214e, 25,
0x0214f, 0,
0x02160, 25,
0x02189, 0,
0x02800, 46,
0x02900, 0,
0x02c00, 56,
0x02c60, 25,
0x02c80, 7,
0x02d00, 12,
0x02d30, 60,
0x02d80, 11,
0x02de0, 8,
0x02e00, 0,
0x02e80, 17,
0x02ff0, 0,
0x03005, 17,
0x03006, 0,
0x03007, 17,
0x03008, 0,
0x03021, 17,
0x0302a, 1,
0x0302e, 18,
0x03030, 0,
0x03038, 17,
0x0303c, 0,
0x03041, 20,
0x03099, 1,
0x0309b, 0,
0x0309d, 20,
0x030a0, 0,
0x030a1, 22,
0x030fb, 0,
0x030fd, 22,
0x03105, 5,
0x03131, 18,
0x03190, 0,
0x031a0, 5,
0x031c0, 0,
0x031f0, 22,
0x03200, 18,
0x03220, 0,
0x03260, 18,
0x0327f, 0,
0x032d0, 22,
0x03358, 0,
0x03400, 17,
0x04dc0, 0,
0x04e00, 17,
0x0a000, 41,
0x0a4d0, 131,
0x0a500, 99,
0x0a640, 8,
0x0a6a0, 130,
0x0a700, 0,
0x0a722, 25,
0x0a788, 0,
0x0a78b, 25,
0x0a800, 58,
0x0a830, 0,
0x0a840, 90,
0x0a880, 111,
0x0a8e0, 10,
0x0a900, 79,
0x0a930, 110,
0x0a960, 18,
0x0a980, 78,
0x0aa00, 66,
0x0aa60, 28,
0x0aa80, 127,
0x0aae0, 103,
0x0ab01, 11,
0x0abc0, 103,
0x0ac00, 18,
0x0d7fc, 103,
0x0f900, 17,
0x0fb00, 25,
0x0fb13, 3,
0x0fb1d, 19,
0x0fb50, 2,
0x0fd3e, 0,
0x0fd50, 2,
0x0fdfd, 0,
0x0fe00, 1,
0x0fe10, 0,
0x0fe20, 1,
0x0fe30, 0,
0x0fe70, 2,
0x0feff, 0,
0x0ff21, 25,
0x0ff3b, 0,
0x0ff41, 25,
0x0ff5b, 0,
0x0ff66, 22,
0x0ff70, 0,
0x0ff71, 22,
0x0ff9e, 0,
0x0ffa0, 18,
0x0ffe0, 0,
0x010000, 49,
0x010100, 0,
0x010140, 14,
0x010190, 0,
0x0101fd, 1,
0x010280, 107,
0x0102a0, 104,
0x010300, 30,
0x010330, 13,
0x010380, 53,
0x0103a0, 61,
0x010400, 9,
0x010450, 51,
0x010480, 50,
0x010800, 47,
0x010840, 116,
0x010900, 91,
0x010920, 76,
0x010980, 86,
0x0109a0, 141,
0x010a00, 57,
0x010a60, 133,
0x010b00, 117,
0x010b40, 125,
0x010b60, 122,
0x010c00, 103,
0x010e60, 2,
0x011000, 65,
0x011080, 120,
0x0110d0, 152,
0x011100, 118,
0x011180, 151,
0x011680, 153,
0x012000, 101,
0x013000, 71,
0x016800, 130,
0x016f00, 103,
0x01b000, 22,
0x01b001, 20,
0x01d000, 0,
0x01d167, 1,
0x01d16a, 0,
0x01d17b, 1,
0x01d183, 0,
0x01d185, 1,
0x01d18c, 0,
0x01d1aa, 1,
0x01d1ae, 0,
0x01d200, 14,
0x01d300, 0,
0x01ee00, 2,
0x01f000, 0,
0x01f200, 20,
0x01f201, 0,
0x020000, 17,
0x0e0001, 0,
0x0e0100, 1,
0x0e01f0, 103,
};
private static final int dataPower = 1 << 9;
private static final int dataExtra = data.length - dataPower;
private static final int CHAR_START = 0;
private static final int CHAR_LIMIT = data[data.length - 2];
}
