package com.javafx.experiments.importers.maya.values.impl;
import java.util.Iterator;
import com.javafx.experiments.importers.maya.types.MInt3ArrayType;
import com.javafx.experiments.importers.maya.values.MData;
import com.javafx.experiments.importers.maya.values.MInt3Array;
public class MInt3ArrayImpl extends MDataImpl implements MInt3Array {
private int[] data;
static class Parser {
private MInt3Array array;
Parser(MInt3Array array) {
this.array = array;
}
public void parse(Iterator<String> elements) {
int i = 0;
while (elements.hasNext()) {
array.set(
i++,
Integer.parseInt(elements.next()),
Integer.parseInt(elements.next()),
Integer.parseInt(elements.next()));
}
}
}
static class MInt3ArraySlice extends MDataImpl implements MInt3Array {
private MInt3Array array;
private int base;
private int length;
MInt3ArraySlice(
MInt3Array array,
int base,
int length) {
super((MInt3ArrayType) array.getType());
this.array = array;
this.base = base;
this.length = length;
}
public void setSize(int size) {
array.setSize(base + size);
}
public int getSize() {
return length;
}
public void set(int index, int x, int y, int z) {
if (index >= length) {
throw new ArrayIndexOutOfBoundsException(index);
}
array.set(base + index, x, y, z);
}
public int[] get() {
throw new RuntimeException("Probably shouldn't fetch the data behind a slice");
}
public void parse(Iterator<String> elements) {
new Parser(this).parse(elements);
}
}
public MInt3ArrayImpl(MInt3ArrayType type) {
super(type);
}
public void setSize(int size) {
if (data == null || 3 * size > data.length) {
int[] newdata = new int[3 * size];
if (data != null) {
System.arraycopy(data, 0, newdata, 0, data.length);
}
data = newdata;
}
}
public void set(int index, int x, int y, int z) {
data[3 * index + 0] = x;
data[3 * index + 1] = y;
data[3 * index + 2] = z;
}
public int getSize() {
return data == null ? 0 : data.length / 3;
}
public int[] get() {
return data;
}
public MData getData(int index) {
return getData(index, index + 1);
}
public MData getData(int start, int end) {
return new MInt3ArraySlice(this, start, end - start + 1);
}
public void parse(Iterator<String> elements) {
new Parser(this).parse(elements);
}
}
