package test.javafx.fxml;
import java.io.IOException;
import javafx.fxml.FXMLLoaderShim;
import org.junit.Test;
import static org.junit.Assert.*;
public class CompareVersionsTest {
@Test
public void testCompareJFXVersions() throws IOException {
assertTrue(FXMLLoaderShim.compareJFXVersions("1.1", "1.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.1", "0.9.9") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("2", "1.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("2", "1.1.1") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("2", "1.2.3") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("2.1", "2.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("2.1.1.1", "2.1.1.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.5.2", "1.3.5") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0-ea", "2") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0_fcs", "2.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0", "2.0.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0.1", "3.0.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.2.1", "3.2.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.2.1-ea", "1.2.3") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("2", "1") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("5", "3") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("6", "5") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0.1", "3.0.0.0") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0.1", "3.0.0.0.0.1") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("8.0.0-ea", "2.2.5") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9-ea", "8.0.40") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9", "8.0.40") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9.1.2.3", "9.1") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9.2", "9.1.2.3") > 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1", "1.0") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.0", "1") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3", "1.2.3") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1", "1") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("5", "5") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3.0-fcs", "1.2.3") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3_ea", "1.2.3.0.0.0") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3.0.0.0.0", "1.2.3") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9-ea", "9") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9-ea", "9.0.0.0") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9", "9.0.0.0") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9.0.0.0", "9") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9.0.1", "9.0.1.0") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("ABC", "1.2.3") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("a.b.c", "1.2.3") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3", "abc") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("abc", "abc") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3.a.b", "1.2.3") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.3", "1.2.3.*") == 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("0.9", "1.0") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1", "2") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1", "3") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1", "12") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3", "3.0.0.1.2") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1", "1.2") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2", "1.2.3") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.0", "1.2.1") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("1.2.0", "1.2.0.0.0.1") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.2.1", "3.2.2") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("3.0.0.1", "3.0.0.1.0.0.1") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("8.0.40", "9") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9.1", "9.1.2.3") < 0);
assertTrue(FXMLLoaderShim.compareJFXVersions("9.1.2.3", "9.2") < 0);
}
}
