package test.javafx.scene.input;
import com.sun.javafx.PlatformUtil;
import javafx.application.Platform;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import test.util.Util;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.SunClipboard;
import static org.junit.Assert.*;
import static org.junit.Assume.assumeTrue;
public class ClipboardTest {
static CountDownLatch startupLatch;
static Clipboard clipboard;
public static void main(String[] args) throws Exception {
initFX();
try {
ClipboardTest test = new ClipboardTest();
test.testCopyUTF8String();
test.testPasteUTF8String();
} catch (Throwable e) {
e.printStackTrace();
} finally {
teardown();
}
}
@BeforeClass
public static void initFX() {
startupLatch = new CountDownLatch(1);
Platform.startup(() -> {
clipboard = Clipboard.getSystemClipboard();
startupLatch.countDown();
});
try {
if (!startupLatch.await(15, TimeUnit.SECONDS)) {
fail("Timeout waiting for FX runtime to start");
}
} catch (InterruptedException ex) {
fail("Unexpected exception: " + ex);
}
}
@Test
public void testCopyUTF8String() throws Exception {
String text = new String(new byte[]{
0x20, (byte) 0x4a, (byte) 0x75, (byte) 0x6d, (byte) 0x70, (byte) 0x20,
(byte) 0x74, (byte) 0x6f, (byte) 0x3a, (byte) 0x20, (byte) 0xf0,
(byte) 0x9f, (byte) 0x98, (byte) 0x83, (byte) 0xf0, (byte) 0x9f,
(byte) 0x92, (byte) 0x81, (byte) 0x20, (byte) 0x4a, (byte) 0x75,
(byte) 0x6d, (byte) 0x70
}, "UTF-8");
ClipboardContent content = new ClipboardContent();
content.putString(text);
Util.runAndWait(() -> clipboard.setContent(content));
Thread.sleep(1000);
assertEquals(text, Toolkit.getDefaultToolkit()
.getSystemClipboard().getData(DataFlavor.stringFlavor));
}
@Test
public void testPasteUTF8String() throws Exception {
String text = new String(new byte[]{
0x20, (byte) 0x4a, (byte) 0x75, (byte) 0x6d, (byte) 0x70, (byte) 0x20,
(byte) 0x74, (byte) 0x6f, (byte) 0x3a, (byte) 0x20, (byte) 0xf0,
(byte) 0x9f, (byte) 0x98, (byte) 0x83, (byte) 0xf0, (byte) 0x9f,
(byte) 0x92, (byte) 0x81, (byte) 0x20, (byte) 0x4a, (byte) 0x75,
(byte) 0x6d, (byte) 0x70
}, "UTF-8");
Toolkit.getDefaultToolkit()
.getSystemClipboard().setContents(new StringSelection(text), null);
Thread.sleep(1000);
Util.runAndWait(() ->
assertEquals(text, clipboard.getContent(DataFormat.PLAIN_TEXT)));
}
@Test
public void testCustomClipboard() throws Exception {
assumeTrue(PlatformUtil.isWindows());
Toolkit.getDefaultToolkit().getSystemClipboard()
.setContents(new ClipboardTransferable(new CustomClipboard()), null);
Util.runAndWait(() -> {
boolean hasString = clipboard.hasString();
assertFalse(hasString);
});
}
@AfterClass
public static void teardown() {
Platform.exit();
}
private static final class CustomClipboard extends SunClipboard {
private static final int CF_HDROP = 15;
private static final byte[] CF_HDROP_BYTES = new byte[] {
0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
0x44, 0x00, 0x3A, 0x00, 0x5C, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00, 0x61, 0x00,
0x00, 0x00,
0x00, 0x00,
};
public CustomClipboard() {
super("CustomClipboard");
}
@Override
public long getID() {
return 0;
}
@Override
protected void clearNativeContext() {
}
@Override
protected void setContentsNative(final Transferable transferable) {
}
@Override
protected long[] getClipboardFormats() {
return new long[] { CF_HDROP };
}
@Override
protected byte[] getClipboardData(final long id) {
if (id == CF_HDROP) {
return CF_HDROP_BYTES;
} else {
return new byte[0];
}
}
@Override
protected void registerClipboardViewerChecked() {
}
@Override
protected void unregisterClipboardViewerChecked() {
}
}
}
