(*  ==== Testing ====
 *
 *  Result: OK
 *
 *
 *  Revision Log
 *  ------------
 *  $Log: reals.sml,v $
 *  Revision 1.9  1998/04/21 09:27:58  mitchell
 *  [Bug #30336]
 *  Fix tests to agree with revised spec of fmt and toString
 *
 *  Revision 1.8  1997/11/21  15:01:36  daveb
 *  [Bug #30323]
 *
 *  Revision 1.7  1997/09/19  13:51:10  daveb
 *  [Bug #30214]
 *  Added tests for negative zero.
 *
 *  Revision 1.6  1997/05/28  15:56:18  matthew
 *  Updating
 *
 *  Revision 1.5  1997/03/06  13:41:32  matthew
 *  Change to reading functions
 *
 *  Revision 1.4  1996/11/06  13:37:21  andreww
 *  [Bug #1711]
 *  reals no longer eqtype
 *
 *  Revision 1.3  1996/11/06  12:05:17  matthew
 *  [Bug #1728]
 *  __integer becomes __int
 *
 *  Revision 1.2  1996/10/22  13:20:54  jont
 *  Remove references to toplevel
 *
 *  Revision 1.1  1996/05/22  12:26:08  matthew
 *  new unit
 *  New test
 *
*)

(* test/real.sml -- here we test only the `exotic' operations
   PS 1995-03-24 
   modified for MLWorks Fri May 17 11:05:53 1996
   *)


infix 1 seq
fun e1 seq e2 = e2;
fun say s = print s;
fun check b = if b then "OK" else "WRONG";
fun check' f = (if f () then "OK" else "WRONG") handle _ => "EXN";

fun range (from, to) p = 
    let open Int
    in
	(from > to) orelse (p from) andalso (range (from+1, to) p)
    end;

fun checkrange bounds = check o range bounds;

local 
    open Real
    infix ?=
in	

val test1 = check(sign ~57.0 = ~1 andalso sign 99.0 = 1 andalso sign 0.0 = 0);
val test2 = check(sameSign(~255.0, ~256.0) andalso sameSign(255.0, 256.0) 
		  andalso sameSign(0.0, 0.0));
val test3 = check(sign 1E~300 = 1 andalso sign ~1E~300 = ~1
		  andalso sign 1E300 = 1 andalso sign ~1E300 = ~1);

local 
    val args = [0.0, 99.0, ~5.0, 1.1, ~1.1, 1.9, ~1.9, 2.5, ~2.5, 
		1000001.4999, ~1000001.4999];
in
val test4 = check(map ceil args  
		   = [0, 99, ~5, 2, ~1, 2, ~1, 3, ~2, 1000002, ~1000001]);
val test5 = check(map floor args 
		   = [0, 99, ~5, 1, ~2, 1, ~2, 2, ~3, 1000001, ~1000002]);
val test6 = check(map trunc args 
		   = [0, 99, ~5, 1, ~1, 1, ~1, 2, ~2, 1000001, ~1000001]);
val test7 = check(map round args 
		   = [0, 99, ~5, 1, ~1, 2, ~2, 2, ~2, 1000001, ~1000001]);
end

val test8 = check(0.0 ?= real 0 andalso 2.0 ?= real 2 andalso ~2.0 ?= real ~2);

fun chk(s, r) = 
    let val eps = abs r * 1E~10 
    in 
	check'(fn _ => 
	       case fromString s of
		   SOME res => abs(res - r) <= eps
                 | NONE     => false)
    end

val test9 = 
    List.map chk[("0", 0.0),
		 ("156", 156.0),
		 ("+156", 156.0), 
		 ("~156", ~156.0), 
		 ("-156", ~156.0), 
		 ("156.25", 156.25), 
		 ("+156.25", 156.25), 
		 ("~156.25", ~156.25), 
		 ("-156.25", ~156.25),
		 (".25", 0.25),
		 ("+.25", 0.25),
		 ("~.25", ~0.25),
		  ("-.25", ~0.25),

		  ("156E024", 156E024),
		  ("+156E024", 156E024),
		  ("~156E024", ~156E024),
		  ("-156E024", ~156E024),
		  ("156.25E024", 156.25E024),
		  ("+156.25E024", 156.25E024),
		  ("~156.25E024", ~156.25E024),
		  ("-156.25E024", ~156.25E024),
		  (".25E024", 0.25E024),
		  ("+.25E024", 0.25E024),
		  ("~.25E024", ~0.25E024),
		  ("-.25E024", ~0.25E024),

		  ("156E+024", 156E024),
		  ("+156E+024", 156E024),
		  ("~156E+024", ~156E024),
		  ("-156E+024", ~156E024),
		  ("156.25E+024", 156.25E024),
		  ("+156.25E+024", 156.25E024),
		  ("~156.25E+024", ~156.25E024),
		  ("-156.25E+024", ~156.25E024),
		  (".25E+024", 0.25E024),
		  ("+.25E+024", 0.25E024),
		  ("~.25E+024", ~0.25E024),
		  ("-.25E+024", ~0.25E024),

		  ("156E~024", 156E~024),
		  ("+156E~024", 156E~024),
		  ("~156E~024", ~156E~024),
		  ("-156E~024", ~156E~024),
		  ("156.25E~024", 156.25E~024),
		  ("+156.25E~024", 156.25E~024),
		  ("~156.25E~024", ~156.25E~024),
		  ("-156.25E~024", ~156.25E~024),
		  (".25E~024", 0.25E~024),
		  ("+.25E~024", 0.25E~024),
		  ("~.25E~024", ~0.25E~024),
		  ("-.25E~024", ~0.25E~024),

		  ("156E-024", 156E~024),
		  ("+156E-024", 156E~024),
		  ("~156E-024", ~156E~024),
		  ("-156E-024", ~156E~024),
		  ("156.25E-024", 156.25E~024),
		  ("+156.25E-024", 156.25E~024),
		  ("~156.25E-024", ~156.25E~024),
		  ("-156.25E-024", ~156.25E~024),
		  (".25E-024", 0.25E~024),
		  ("+.25E-024", 0.25E~024),
		  ("~.25E-024", ~0.25E~024),
		  ("-.25E-024", ~0.25E~024),

		  ("156e024", 156E024),
		  ("+156e024", 156E024),
		  ("~156e024", ~156E024),
		  ("-156e024", ~156E024),
		  ("156.25e024", 156.25E024),
		  ("+156.25e024", 156.25E024),
		  ("~156.25e024", ~156.25E024),
		  ("-156.25e024", ~156.25E024),
		  (".25e024", 0.25E024),
		  ("+.25e024", 0.25E024),
		  ("~.25e024", ~0.25E024),
		  ("-.25e024", ~0.25E024),

		  ("156e+024", 156E024),
		  ("+156e+024", 156E024),
		  ("~156e+024", ~156E024),
		  ("-156e+024", ~156E024),
		  ("156.25e+024", 156.25E024),
		  ("+156.25e+024", 156.25E024),
		  ("~156.25e+024", ~156.25E024),
		  ("-156.25e+024", ~156.25E024),
		  (".25e+024", 0.25E024),
		  ("+.25e+024", 0.25E024),
		  ("~.25e+024", ~0.25E024),
		  ("-.25e+024", ~0.25E024),

		  ("156e~024", 156E~024),
		  ("+156e~024", 156E~024),
		  ("~156e~024", ~156E~024),
		  ("-156e~024", ~156E~024),
		  ("156.25e~024", 156.25E~024),
		  ("+156.25e~024", 156.25E~024),
		  ("~156.25e~024", ~156.25E~024),
		  ("-156.25e~024", ~156.25E~024),
		  (".25e~024", 0.25E~024),
		  ("+.25e~024", 0.25E~024),
		  ("~.25e~024", ~0.25E~024),
		  ("-.25e~024", ~0.25E~024),

		  ("156e-024", 156E~024),
		  ("+156e-024", 156E~024),
		  ("~156e-024", ~156E~024),
		  ("-156e-024", ~156E~024),
		  ("156.25e-024", 156.25E~024),
		  ("+156.25e-024", 156.25E~024),
		  ("~156.25e-024", ~156.25E~024),
		  ("-156.25e-024", ~156.25E~024),
		  (".25e-024", 0.25E~024),
		  ("+.25e-024", 0.25E~024),
		  ("~.25e-024", ~0.25E~024),
		  ("-.25e-024", ~0.25E~024)];
val test10 = 
    List.map (fn s => case fromString s of NONE => "OK" | _ => "WRONG") 
             ["e10", 
              "E10", 
	      "+e10",
              "+E10",
	      "~e10",
              "~E10", 
	      "-e10",
              "-E10",
              "",
              ".",
              ".E10"];

val test11 =
    List.map check
      [Real.toString ~0.0  = "~0",
       Real.toString 0.0  = "0",
       Real.toString (~(0.0))  = "~0",
       Real.toString (0.0 - 0.0)  = "0"]


end
