(*
 Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are
 met:
 
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 based on Revision ???
 
 Revision Log
 ------------
 $Log: machregisters.sml,v $
 Revision 1.2  1993/11/17 14:08:35  io
 Deleted old SPARC comments and fixed type errors

 *)
 
require "../utils/set";


signature MACHREGISTERS =

  sig

    structure Set	: SET

    eqtype T


    (*  == General registers ==  *)

    val gcs : T Set.Set		(* int/ptr visible to garbage collector *)
    val non_gcs : T Set.Set	(* int/ptr not visible to garbage collector *)
    val fps : T Set.Set		(* floating point registers *)


    (*  == Special purpose reserved registers ==  *)

    val fn_arg : T	(* function argument and return *)
    val cl_arg : T	(* closure pointer *)
    val fp : T		(* frame pointer *)
    val sp : T		(* stack pointer *)
    val lr : T		(* link register *)
    val handler : T	(* pointer to exception handler code *)
    val global : T	(* not affected by PRESERVE or RESTORE *)
    val gc1 : T		(* reserved for garbage collector *)
    val gc2 : T		(* reserved for garbage collector *)

    val after_preserve : T -> T
    val after_restore : T -> T

  end
