(*
 *
 * $Log: lego_lex.sml,v $
 * Revision 1.2  1998/08/05 17:42:58  jont
 * Automatic checkin:
 * changed attribute _comment to ' *  '
 *
 *
 *)
require "ut1";
require "ut2";
require "lego_grm.sml";
require "ut3";
require "base";
require "^.polyml-compat";

functor LegoLexFun(structure Tokens:Lego_TOKENS
                            structure Pos:POS):LEXER=
   struct
    structure UserDeclarations =
      struct

structure Tokens = Tokens
open Tokens

structure Pos = Pos
open Pos

type pos = Pos.pos
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult = (svalue,pos) token

fun eof() = EOF(!lno,!lno)


structure KeyWord : sig
		      val find : string -> ((pos*pos)->lexresult) option
	  	    end =
  struct

	val TableSize = 300
	val HashFactor = 7

	val hash = fn s =>
	   fold (fn (c,v)=>(v*HashFactor+(ord c)) mod TableSize) (explode s) 0


	val HashTable = Array.array(TableSize,nil) :
		 (string * ((pos*pos)->lexresult)) list Array.array


	val add = fn (s,v) =>
	 let val i = hash s
	 in Array.update(HashTable,i,(s,v) :: (Array.sub(HashTable, i)))
	 end

        val find = fn s =>
	  let val i = hash s
	      fun f ((key,v)::r) = if s=key then SOME v else f r
	        | f nil = NONE
	  in  f (Array.sub(HashTable, i))
	  end
 
	val _ = 
	    (app add
        [("allE", ALLE),
         ("allI", ALLI),
         ("andE", ANDE),
         ("andI", ANDI),
         ("Cd", CD),
         ("Claim", CLAIM),
	 ("Configure", CONFIG),
         ("Ctxt", CTXT),
         ("Inductive", INDUCTIVE),
         ("NoReductions", NOREDS),
         ("Parameters", PARAMS),
         ("Constructors", CONSTRS),
         ("Decls", DECLS),
         ("Discharge", DISCHARGE),
         ("DischargeKeep", DISCHARGEKEEP),
         ("Dnf", DNF),
	 ("Drop", EOF),
         ("echo", ECHO),
         ("Elim", ELIM),
         ("Equiv", EQUIV),
         ("exI", EXI),
         ("exE", EXE),
         ("ExpAll", EXPALL),
         ("Expand", EXPAND),
         ("ExportState", EXPORT),
         ("Forget", FORGET),
         ("ForgetMark", FORGETMARK),
         ("Freeze", FREEZE),
         ("From", FROM),
         ("Unfreeze", UNFREEZE),
         ("Gen", GEN),
         ("Goal", GOAL),
         ("Help", HELP),
         ("Hnf", HNF),
         ("Include", INCLUDE),
         ("Immed", IMMED),
         ("impE", IMPE),
         ("impI", IMPI),
         ("Init", INIT),
         ("Intros", INTROS),
         ("intros", iNTROS),
         ("Import", IMPORT),
         ("KillRef", KILLREF),
         ("Logic", LOGIC),
         ("line", LINE),
         ("Load", LOAD),
         ("Module", MODULE),
         ("Marks", MARKS),
         ("Next", NEXT),
         ("Normal", NORMAL),
         ("notE", NOTE),
         ("notI", NOTI),
         ("orE", ORE),
         ("orIL", ORIL),
         ("orIR", ORIR),
         ("Prf", PRF),
         ("Prop", PROP),
         ("Pwd", PWD),
	 ("Qrepl", QREPL),
         ("Refine", REFINE),
         ("Reload", RELOAD),
         ("Save", SAVE),
         ("StartTimer", STARTTIMER),
         ("PrintTimer", PRINTTIMER),
         ("TReg", TREG),
         ("Type", TYPE),
         ("TypeOf", TYPEOF),
         ("Undo", UNDO),
         ("VReg", VREG)
        ]) 
   end
   open KeyWord


val com_nest_level = ref 0

fun intofstring s =
    let fun genint ([],n) = n
          | genint (h::t, n) = genint(t, n*10 + (ord h) - (ord "0"))
     in genint(explode s, 0) end


end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\005\005\005\005\005\005\005\005\005\053\055\005\005\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\053\005\050\049\043\005\005\005\041\040\005\038\037\035\032\029\
\\027\027\027\027\027\027\027\027\027\027\026\025\024\021\020\019\
\\005\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\018\016\015\005\014\
\\005\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\010\008\007\006\005\
\\005"
val s3 =
"\056\056\056\056\056\056\056\056\056\056\062\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\060\059\057\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056"
val s8 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\000\000\
\\000"
val s11 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\013\000\000\000\000\000\000\000\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\012\012\012\012\012\012\012\012\012\012\012\000\000\000\000\013\
\\000\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\012\012\012\012\012\012\012\012\012\012\012\000\000\000\000\000\
\\000"
val s13 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\013\000\000\000\000\000\000\000\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\013\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s16 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\017\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\028\028\028\028\028\028\028\028\028\028\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\030\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\034\033\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\036\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s38 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\039\039\039\039\039\039\039\039\039\039\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s41 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\042\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\045\000\000\000\000\000\000\000\044\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s45 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\046\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\047\000\000\000\000\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s50 =
"\051\051\051\051\051\051\051\051\051\051\000\051\051\051\051\051\
\\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051\051\052\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\051\
\\051"
val s53 =
"\000\000\000\000\000\000\000\000\000\054\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\054\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s56 =
"\056\056\056\056\056\056\056\056\056\056\000\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\000\000\000\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\056\
\\056"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\058\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\061\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [(N 104)], trans = s0},
{fin = [(N 80),(N 104)], trans = s0},
{fin = [(N 70),(N 104)], trans = s0},
{fin = [(N 20),(N 104)], trans = s8},
{fin = [(N 18)], trans = s0},
{fin = [(N 48),(N 104)], trans = s0},
{fin = [(N 96),(N 102),(N 104)], trans = s11},
{fin = [(N 96),(N 102)], trans = s11},
{fin = [(N 102)], trans = s13},
{fin = [(N 82),(N 104)], trans = s0},
{fin = [(N 76),(N 104)], trans = s0},
{fin = [(N 15),(N 104)], trans = s16},
{fin = [(N 66)], trans = s0},
{fin = [(N 63),(N 104)], trans = s0},
{fin = [(N 68),(N 104)], trans = s0},
{fin = [(N 72),(N 104)], trans = s0},
{fin = [(N 44),(N 104)], trans = s21},
{fin = [(N 34)], trans = s22},
{fin = [(N 28)], trans = s0},
{fin = [(N 50),(N 104)], trans = s0},
{fin = [(N 78),(N 104)], trans = s0},
{fin = [(N 22),(N 104)], trans = s0},
{fin = [(N 85),(N 104)], trans = s27},
{fin = [(N 85)], trans = s27},
{fin = [(N 104)], trans = s29},
{fin = [(N 10)], trans = s0},
{fin = [(N 7)], trans = s0},
{fin = [(N 42),(N 104)], trans = s32},
{fin = [(N 40)], trans = s0},
{fin = [(N 37)], trans = s0},
{fin = [(N 104)], trans = s35},
{fin = [(N 13)], trans = s0},
{fin = [(N 24),(N 104)], trans = s0},
{fin = [(N 104)], trans = s38},
{fin = [(N 89)], trans = s38},
{fin = [(N 74),(N 104)], trans = s0},
{fin = [(N 52),(N 104)], trans = s41},
{fin = [(N 31)], trans = s0},
{fin = [(N 104)], trans = s43},
{fin = [(N 55)], trans = s0},
{fin = [], trans = s45},
{fin = [], trans = s46},
{fin = [], trans = s47},
{fin = [(N 61)], trans = s0},
{fin = [(N 46),(N 104)], trans = s0},
{fin = [(N 104)], trans = s50},
{fin = [], trans = s50},
{fin = [(N 93)], trans = s0},
{fin = [(N 4),(N 104)], trans = s53},
{fin = [(N 4)], trans = s53},
{fin = [(N 1)], trans = s0},
{fin = [(N 109)], trans = s56},
{fin = [(N 117)], trans = s57},
{fin = [(N 115)], trans = s0},
{fin = [(N 117)], trans = s0},
{fin = [(N 117)], trans = s60},
{fin = [(N 112)], trans = s0},
{fin = [(N 106)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val C = STARTSTATE 3;
val INITIAL = STARTSTATE 1;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (inc_lno(); lex())
| 10 => (AND(!lno,!lno))
| 102 => (ID (yytext,!lno,!lno))
| 104 => (errmsg "Lego lexer"
	                      ("ignoring bad character "^yytext,!lno,!lno); 
                       lex())
| 106 => (inc_lno(); lex())
| 109 => (lex())
| 112 => (com_nest_level := !com_nest_level + 1; lex())
| 115 => (com_nest_level := !com_nest_level - 1;
                       if (!com_nest_level = 0)
                       then (YYBEGIN INITIAL; lex())
                       else lex())
| 117 => (lex())
| 13 => (ARROW(!lno,!lno))
| 15 => (BACKSLASH(!lno,!lno))
| 18 => (CHOICE(!lno,!lno))
| 20 => (BAR(!lno,!lno))
| 22 => (COLON(!lno,!lno))
| 24 => (COMMA(!lno,!lno))
| 28 => (CONTRACT(!lno,!lno))
| 31 => (YYBEGIN C; com_nest_level := 1; lex())
| 34 => (DEQ(!lno,!lno))
| 37 => (DOT1(!lno,!lno))
| 4 => (lex())
| 40 => (DOT2(!lno,!lno))
| 42 => (DOT(!lno,!lno))
| 44 => (EQUL(!lno,!lno))
| 46 => (HASH(!lno,!lno))
| 48 => (LCBR(!lno,!lno))
| 50 => (LPTBR(!lno,!lno))
| 52 => (LRBR(!lno,!lno))
| 55 => (DOLLARSQ(!lno,!lno))
| 61 => (DOLLARSAVE(!lno,!lno))
| 63 => (LSQBR(!lno,!lno))
| 66 => (OR(!lno,!lno))
| 68 => (QM(!lno,!lno))
| 7 => (SLASHS(!lno,!lno))
| 70 => (RCBR(!lno,!lno))
| 72 => (RPTBR(!lno,!lno))
| 74 => (RRBR(!lno,!lno))
| 76 => (RSQBR(!lno,!lno))
| 78 => (SEMICOLON(!lno,!lno))
| 80 => (TILDE(!lno,!lno))
| 82 => (UNDERSCORE(!lno,!lno))
| 85 => (INT (intofstring yytext,!lno,!lno))
| 89 => (RELINT (intofstring (substring (yytext,1,size(yytext)-1)),!lno,!lno))
| 93 => (STRING (substring (yytext,1,size(yytext)-2),!lno,!lno))
| 96 => (case  KeyWord.find yytext
	                 of SOME v => v (!lno,!lno)
	                  | _ => ID (yytext,!lno,!lno))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
