(*
 *
 * $Log: lego__grm.sml,v $
 * Revision 1.2  1998/08/05 17:41:59  jont
 * Automatic checkin:
 * changed attribute _comment to ' *  '
 *
 *
 *)
require "ut1";
require "utils";
require "base";
require "lego_grm.sml";
require "ut3";
require "universe";
require "term";
require "namespace";
require "parser";
require "synt";
require "toplevel";
require "discharge";
require "newtop";
require "tactics";
require "logic";
require "help";
require "modules";
require "init";

functor LegoLrValsFun (structure Token : TOKEN
                        structure Pos : POS
                       ) : Lego_LRVALS = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Lego grammar *)

  

end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\008\000\104\000\013\000\013\001\018\000\075\000\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\001\000\008\000\104\000\017\000\025\001\018\000\075\000\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\001\000\008\000\104\000\017\000\038\001\018\000\075\000\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\001\000\008\000\104\000\018\000\075\000\029\000\042\001\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\001\000\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\083\000\036\001\092\000\021\000\094\000\020\000\000\000\
\\001\000\008\000\214\000\011\000\213\000\014\000\212\000\018\000\075\000\
\\029\000\211\000\057\000\047\000\059\000\045\000\061\000\088\000\000\000\
\\001\000\008\000\214\000\011\000\231\000\014\000\212\000\000\000\
\\001\000\011\000\223\000\083\000\222\000\000\000\
\\001\000\011\000\239\000\017\000\238\000\000\000\
\\001\000\011\000\004\001\029\000\003\001\000\000\
\\001\000\018\000\075\000\021\000\145\000\040\000\144\000\044\000\143\000\
\\045\000\090\000\057\000\047\000\059\000\045\000\060\000\044\000\
\\061\000\088\000\066\000\142\000\075\000\030\000\077\000\028\000\
\\092\000\021\000\094\000\020\000\095\000\141\000\000\000\
\\001\000\018\000\075\000\045\000\090\000\051\000\089\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\081\000\087\000\092\000\021\000\094\000\020\000\000\000\
\\001\000\018\000\075\000\045\000\090\000\057\000\047\000\059\000\045\000\
\\060\000\044\000\061\000\088\000\075\000\030\000\077\000\028\000\
\\092\000\021\000\093\000\175\000\094\000\020\000\103\000\174\000\000\000\
\\001\000\018\000\075\000\045\000\090\000\057\000\047\000\059\000\045\000\
\\060\000\044\000\061\000\088\000\075\000\030\000\077\000\028\000\
\\092\000\021\000\094\000\020\000\000\000\
\\001\000\018\000\075\000\045\000\137\000\057\000\047\000\059\000\045\000\
\\061\000\088\000\096\000\136\000\000\000\
\\001\000\018\000\108\000\057\000\047\000\059\000\045\000\061\000\107\000\000\000\
\\001\000\028\000\000\000\088\000\000\000\000\000\
\\001\000\045\000\113\000\000\000\
\\001\000\045\000\114\000\000\000\
\\001\000\045\000\117\000\091\000\116\000\000\000\
\\001\000\045\000\126\000\000\000\
\\001\000\045\000\137\000\096\000\136\000\000\000\
\\001\000\045\000\155\000\000\000\
\\001\000\045\000\163\000\000\000\
\\001\000\045\000\164\000\000\000\
\\001\000\045\000\181\000\000\000\
\\001\000\045\000\182\000\000\000\
\\001\000\045\000\204\000\051\000\203\000\000\000\
\\001\000\045\000\229\000\000\000\
\\001\000\045\000\026\001\000\000\
\\001\000\045\000\040\001\000\000\
\\001\000\051\000\089\000\081\000\087\000\000\000\
\\001\000\051\000\089\000\081\000\087\000\093\000\172\000\103\000\171\000\000\000\
\\001\000\051\000\109\000\000\000\
\\001\000\051\000\244\000\000\000\
\\001\000\051\000\245\000\000\000\
\\001\000\051\000\001\001\000\000\
\\001\000\051\000\029\001\000\000\
\\001\000\078\000\187\000\000\000\
\\001\000\079\000\233\000\000\000\
\\001\000\082\000\232\000\000\000\
\\001\000\083\000\224\000\000\000\
\\001\000\083\000\253\000\000\000\
\\001\000\083\000\254\000\000\000\
\\001\000\083\000\017\001\000\000\
\\001\000\083\000\018\001\000\000\
\\001\000\083\000\019\001\000\000\
\\001\000\083\000\021\001\000\000\
\\001\000\083\000\037\001\000\000\
\\001\000\084\000\215\000\000\000\
\\001\000\084\000\217\000\000\000\
\\001\000\084\000\248\000\000\000\
\\001\000\084\000\249\000\000\000\
\\001\000\084\000\011\001\000\000\
\\001\000\091\000\176\000\000\000\
\\001\000\091\000\189\000\000\000\
\\001\000\101\000\201\000\102\000\200\000\000\000\
\\001\000\102\000\028\001\000\000\
\\048\001\000\000\
\\049\001\000\000\
\\050\001\000\000\
\\051\001\000\000\
\\052\001\000\000\
\\053\001\000\000\
\\054\001\000\000\
\\055\001\000\000\
\\056\001\000\000\
\\057\001\000\000\
\\058\001\001\000\083\000\002\000\082\000\003\000\081\000\004\000\080\000\
\\009\000\079\000\010\000\078\000\012\000\077\000\015\000\076\000\
\\018\000\075\000\019\000\074\000\020\000\073\000\021\000\072\000\
\\025\000\071\000\026\000\070\000\030\000\069\000\031\000\068\000\
\\032\000\067\000\033\000\066\000\034\000\065\000\035\000\064\000\
\\036\000\063\000\037\000\062\000\038\000\061\000\041\000\060\000\
\\043\000\059\000\044\000\058\000\045\000\057\000\046\000\056\000\
\\047\000\055\000\048\000\054\000\049\000\053\000\050\000\052\000\
\\052\000\051\000\053\000\050\000\055\000\049\000\056\000\048\000\
\\057\000\047\000\058\000\046\000\059\000\045\000\060\000\044\000\
\\061\000\043\000\062\000\042\000\063\000\041\000\064\000\040\000\
\\065\000\039\000\066\000\038\000\067\000\037\000\068\000\036\000\
\\070\000\035\000\071\000\034\000\072\000\033\000\073\000\032\000\
\\074\000\031\000\075\000\030\000\076\000\029\000\077\000\028\000\
\\078\000\027\000\080\000\026\000\085\000\025\000\086\000\024\000\
\\087\000\023\000\090\000\022\000\092\000\021\000\094\000\020\000\
\\097\000\019\000\098\000\018\000\099\000\017\000\000\000\
\\059\001\000\000\
\\060\001\000\000\
\\061\001\000\000\
\\062\001\039\000\205\000\000\000\
\\063\001\000\000\
\\064\001\054\000\209\000\000\000\
\\065\001\045\000\117\000\091\000\116\000\000\000\
\\066\001\000\000\
\\067\001\000\000\
\\068\001\000\000\
\\069\001\042\000\236\000\045\000\137\000\096\000\136\000\000\000\
\\070\001\042\000\236\000\045\000\137\000\096\000\136\000\000\000\
\\071\001\042\000\236\000\045\000\137\000\096\000\136\000\000\000\
\\072\001\042\000\236\000\045\000\137\000\096\000\136\000\000\000\
\\073\001\027\000\207\000\000\000\
\\074\001\027\000\000\001\000\000\
\\075\001\000\000\
\\076\001\000\000\
\\077\001\000\000\
\\078\001\000\000\
\\079\001\000\000\
\\080\001\000\000\
\\081\001\000\000\
\\082\001\000\000\
\\083\001\045\000\250\000\000\000\
\\084\001\000\000\
\\085\001\000\000\
\\086\001\045\000\202\000\000\000\
\\087\001\045\000\202\000\000\000\
\\088\001\045\000\202\000\000\000\
\\089\001\000\000\
\\090\001\000\000\
\\091\001\000\000\
\\092\001\093\000\161\000\103\000\160\000\000\000\
\\093\001\000\000\
\\094\001\000\000\
\\095\001\093\000\180\000\103\000\179\000\000\000\
\\096\001\000\000\
\\097\001\000\000\
\\098\001\000\000\
\\099\001\093\000\124\000\103\000\123\000\000\000\
\\100\001\000\000\
\\101\001\000\000\
\\102\001\000\000\
\\103\001\000\000\
\\104\001\000\000\
\\105\001\000\000\
\\106\001\045\000\202\000\000\000\
\\107\001\045\000\202\000\000\000\
\\108\001\000\000\
\\109\001\000\000\
\\110\001\000\000\
\\111\001\045\000\186\000\051\000\185\000\000\000\
\\112\001\000\000\
\\113\001\000\000\
\\114\001\045\000\178\000\051\000\177\000\000\000\
\\115\001\000\000\
\\116\001\000\000\
\\117\001\000\000\
\\118\001\000\000\
\\119\001\000\000\
\\120\001\000\000\
\\121\001\000\000\
\\122\001\000\000\
\\123\001\000\000\
\\124\001\000\000\
\\125\001\000\000\
\\126\001\000\000\
\\127\001\100\000\027\001\000\000\
\\128\001\100\000\045\001\000\000\
\\129\001\000\000\
\\130\001\000\000\
\\131\001\000\000\
\\132\001\051\000\089\000\081\000\087\000\000\000\
\\133\001\000\000\
\\134\001\000\000\
\\135\001\000\000\
\\136\001\000\000\
\\137\001\000\000\
\\138\001\000\000\
\\139\001\000\000\
\\140\001\000\000\
\\141\001\000\000\
\\142\001\000\000\
\\143\001\000\000\
\\144\001\000\000\
\\145\001\000\000\
\\146\001\000\000\
\\147\001\000\000\
\\148\001\018\000\075\000\045\000\090\000\057\000\047\000\059\000\045\000\
\\060\000\044\000\061\000\088\000\075\000\030\000\077\000\028\000\
\\092\000\021\000\094\000\020\000\000\000\
\\148\001\018\000\075\000\057\000\047\000\059\000\045\000\061\000\088\000\000\000\
\\149\001\000\000\
\\150\001\018\000\108\000\057\000\047\000\059\000\045\000\061\000\107\000\000\000\
\\151\001\000\000\
\\152\001\000\000\
\\153\001\000\000\
\\154\001\000\000\
\\155\001\000\000\
\\156\001\000\000\
\\157\001\000\000\
\\158\001\000\000\
\\159\001\000\000\
\\160\001\000\000\
\\161\001\016\000\012\001\000\000\
\\162\001\000\000\
\\163\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\164\001\008\000\104\000\011\000\103\000\014\000\225\000\018\000\075\000\
\\045\000\090\000\057\000\047\000\059\000\045\000\060\000\044\000\
\\061\000\088\000\075\000\030\000\077\000\028\000\092\000\021\000\
\\094\000\020\000\000\000\
\\164\001\008\000\104\000\011\000\103\000\018\000\075\000\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\165\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\166\001\005\000\099\000\006\000\098\000\007\000\097\000\022\000\096\000\
\\023\000\095\000\024\000\094\000\042\000\093\000\069\000\092\000\000\000\
\\167\001\005\000\099\000\006\000\098\000\007\000\097\000\022\000\096\000\
\\023\000\095\000\024\000\094\000\042\000\093\000\069\000\092\000\000\000\
\\168\001\005\000\099\000\006\000\098\000\007\000\097\000\022\000\096\000\
\\023\000\095\000\024\000\094\000\042\000\093\000\069\000\092\000\000\000\
\\169\001\000\000\
\\170\001\060\000\111\000\000\000\
\\171\001\000\000\
\\172\001\000\000\
\\173\001\000\000\
\\173\001\011\000\159\000\017\000\158\000\018\000\075\000\057\000\047\000\
\\059\000\045\000\061\000\088\000\000\000\
\\174\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\175\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\176\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\177\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\178\001\000\000\
\\179\001\000\000\
\\180\001\000\000\
\\181\001\005\000\099\000\069\000\092\000\000\000\
\\182\001\000\000\
\\183\001\000\000\
\\184\001\000\000\
\\185\001\000\000\
\\186\001\000\000\
\\187\001\000\000\
\\188\001\051\000\089\000\081\000\087\000\000\000\
\\189\001\000\000\
\\190\001\005\000\099\000\000\000\
\\191\001\005\000\099\000\069\000\092\000\000\000\
\\192\001\000\000\
\\193\001\000\000\
\\194\001\000\000\
\\195\001\008\000\104\000\014\000\225\000\018\000\075\000\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\196\001\000\000\
\\197\001\008\000\104\000\018\000\075\000\029\000\033\001\045\000\090\000\
\\057\000\047\000\059\000\045\000\060\000\044\000\061\000\088\000\
\\075\000\030\000\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\197\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\198\001\008\000\104\000\018\000\075\000\045\000\090\000\057\000\047\000\
\\059\000\045\000\060\000\044\000\061\000\088\000\075\000\030\000\
\\077\000\028\000\092\000\021\000\094\000\020\000\000\000\
\\199\001\089\000\218\000\000\000\
\\200\001\045\000\202\000\000\000\
\\201\001\000\000\
\\202\001\000\000\
\\203\001\000\000\
\\204\001\000\000\
\\205\001\089\000\216\000\000\000\
\\206\001\045\000\202\000\000\000\
\\207\001\000\000\
\\208\001\000\000\
\\209\001\000\000\
\\210\001\000\000\
\\211\001\000\000\
\\212\001\000\000\
\\213\001\000\000\
\\214\001\000\000\
\\215\001\042\000\152\000\045\000\137\000\051\000\089\000\081\000\087\000\
\\096\000\136\000\000\000\
\\215\001\042\000\152\000\045\000\137\000\096\000\136\000\000\000\
\\216\001\000\000\
\\216\001\093\000\169\000\103\000\168\000\000\000\
\\217\001\000\000\
\\218\001\000\000\
\\219\001\000\000\
\\220\001\000\000\
\\221\001\000\000\
\\222\001\000\000\
\\223\001\000\000\
\"
val actionRowNumbers =
"\068\000\191\000\011\000\142\000\
\\063\000\061\000\058\000\164\000\
\\163\000\059\000\178\000\062\000\
\\060\000\158\000\176\000\015\000\
\\033\000\231\000\182\000\013\000\
\\118\000\017\000\018\000\019\000\
\\011\000\011\000\201\000\133\000\
\\181\000\119\000\130\000\147\000\
\\146\000\152\000\148\000\153\000\
\\109\000\031\000\127\000\020\000\
\\019\000\014\000\010\000\021\000\
\\070\000\021\000\135\000\132\000\
\\229\000\229\000\022\000\149\000\
\\155\000\115\000\019\000\186\000\
\\102\000\136\000\013\000\023\000\
\\024\000\231\000\019\000\232\000\
\\032\000\157\000\154\000\012\000\
\\054\000\124\000\105\000\025\000\
\\026\000\021\000\121\000\038\000\
\\013\000\055\000\145\000\151\000\
\\150\000\156\000\013\000\144\000\
\\013\000\235\000\021\000\234\000\
\\185\000\141\000\013\000\013\000\
\\193\000\192\000\013\000\013\000\
\\013\000\013\000\160\000\190\000\
\\179\000\013\000\013\000\161\000\
\\056\000\021\000\021\000\131\000\
\\117\000\027\000\205\000\114\000\
\\113\000\072\000\237\000\236\000\
\\013\000\083\000\013\000\087\000\
\\202\000\110\000\111\000\112\000\
\\074\000\071\000\005\000\049\000\
\\219\000\050\000\213\000\013\000\
\\159\000\221\000\224\000\223\000\
\\007\000\041\000\175\000\013\000\
\\013\000\013\000\028\000\013\000\
\\006\000\040\000\039\000\230\000\
\\081\000\225\000\226\000\230\000\
\\079\000\120\000\108\000\008\000\
\\013\000\013\000\103\000\104\000\
\\095\000\129\000\128\000\116\000\
\\076\000\096\000\231\000\231\000\
\\099\000\034\000\035\000\089\000\
\\013\000\013\000\069\000\125\000\
\\126\000\106\000\107\000\078\000\
\\077\000\051\000\052\000\122\000\
\\123\000\093\000\092\000\134\000\
\\143\000\204\000\188\000\194\000\
\\189\000\187\000\203\000\177\000\
\\180\000\162\000\015\000\015\000\
\\233\000\042\000\043\000\019\000\
\\084\000\036\000\088\000\239\000\
\\009\000\013\000\021\000\013\000\
\\013\000\169\000\231\000\165\000\
\\231\000\053\000\172\000\000\000\
\\207\000\013\000\195\000\013\000\
\\044\000\045\000\046\000\013\000\
\\047\000\013\000\168\000\167\000\
\\082\000\227\000\228\000\080\000\
\\013\000\013\000\064\000\001\000\
\\097\000\098\000\100\000\101\000\
\\090\000\091\000\170\000\166\000\
\\029\000\137\000\057\000\184\000\
\\183\000\073\000\037\000\085\000\
\\075\000\013\000\013\000\215\000\
\\222\000\210\000\212\000\220\000\
\\214\000\171\000\013\000\013\000\
\\004\000\209\000\208\000\199\000\
\\196\000\197\000\048\000\198\000\
\\211\000\065\000\002\000\013\000\
\\030\000\139\000\015\000\086\000\
\\238\000\216\000\003\000\013\000\
\\173\000\174\000\206\000\200\000\
\\013\000\066\000\094\000\138\000\
\\013\000\217\000\067\000\140\000\
\\218\000\016\000"
val gotoT =
"\
\\002\000\014\000\003\000\013\000\004\000\012\000\005\000\011\000\
\\006\000\010\000\007\000\009\000\009\000\008\000\010\000\007\000\
\\015\000\006\000\020\000\005\000\023\000\004\000\024\000\003\000\
\\025\000\002\000\026\000\045\001\030\000\001\000\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\083\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\019\000\082\000\030\000\001\000\000\000\
\\019\000\089\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\099\000\003\000\013\000\006\000\010\000\007\000\098\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\008\000\104\000\009\000\103\000\000\000\
\\000\000\
\\017\000\108\000\000\000\
\\000\000\
\\003\000\084\000\006\000\110\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\027\000\113\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\117\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\019\000\116\000\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\119\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\019\000\118\000\030\000\001\000\000\000\
\\019\000\120\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\019\000\123\000\000\000\
\\000\000\
\\000\000\
\\027\000\125\000\000\000\
\\001\000\133\000\003\000\132\000\007\000\131\000\009\000\008\000\
\\010\000\007\000\011\000\130\000\012\000\129\000\013\000\128\000\
\\014\000\127\000\016\000\126\000\000\000\
\\002\000\138\000\003\000\084\000\004\000\137\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\029\000\136\000\030\000\001\000\000\000\
\\001\000\133\000\011\000\130\000\012\000\145\000\016\000\144\000\000\000\
\\000\000\
\\001\000\133\000\011\000\130\000\012\000\146\000\016\000\144\000\000\000\
\\000\000\
\\000\000\
\\001\000\149\000\018\000\148\000\019\000\147\000\000\000\
\\001\000\149\000\018\000\152\000\019\000\151\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\027\000\154\000\000\000\
\\003\000\132\000\007\000\155\000\009\000\008\000\010\000\007\000\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\160\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\017\000\163\000\000\000\
\\027\000\164\000\000\000\
\\017\000\165\000\000\000\
\\019\000\168\000\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\171\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\133\000\011\000\130\000\012\000\182\000\013\000\128\000\
\\014\000\181\000\016\000\126\000\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\186\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\188\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\002\000\099\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\001\000\133\000\011\000\130\000\012\000\129\000\013\000\128\000\
\\014\000\127\000\016\000\126\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\189\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\002\000\190\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\191\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\002\000\192\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\002\000\193\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\003\000\084\000\006\000\194\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\002\000\195\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\003\000\084\000\006\000\196\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\008\000\197\000\009\000\103\000\000\000\
\\000\000\
\\001\000\133\000\011\000\130\000\012\000\129\000\016\000\144\000\000\000\
\\001\000\133\000\011\000\130\000\012\000\182\000\016\000\144\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\204\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\206\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\132\000\007\000\208\000\009\000\008\000\010\000\007\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\219\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\021\000\218\000\022\000\217\000\030\000\001\000\000\000\
\\003\000\132\000\007\000\098\000\009\000\008\000\010\000\007\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\224\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\225\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\226\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\228\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\149\000\018\000\232\000\000\000\
\\001\000\233\000\000\000\
\\000\000\
\\000\000\
\\001\000\149\000\018\000\235\000\000\000\
\\001\000\233\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\238\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\002\000\239\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\017\000\240\000\000\000\
\\017\000\241\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\244\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\245\000\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\008\000\249\000\009\000\103\000\000\000\
\\008\000\250\000\009\000\103\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\027\000\253\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\028\000\000\001\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\003\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\001\000\004\001\000\000\
\\002\000\005\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\002\000\006\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\017\000\007\001\000\000\
\\000\000\
\\017\000\008\001\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\002\000\012\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\002\000\014\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\029\000\013\001\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\018\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\002\000\020\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\001\000\233\000\000\000\
\\000\000\
\\000\000\
\\001\000\233\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\021\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\002\000\022\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\027\000\028\001\000\000\
\\002\000\014\000\003\000\084\000\004\000\029\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\002\000\030\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\219\000\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\021\000\218\000\022\000\032\001\030\000\001\000\000\000\
\\002\000\033\001\003\000\084\000\006\000\010\000\009\000\008\000\
\\010\000\007\000\030\000\001\000\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\037\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\008\000\039\001\009\000\103\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\002\000\014\000\003\000\084\000\004\000\041\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\003\000\084\000\006\000\100\000\009\000\008\000\010\000\007\000\
\\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\042\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\014\000\003\000\084\000\004\000\044\001\006\000\010\000\
\\009\000\008\000\010\000\007\000\030\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 302
val numrules = 176
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = size s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = MLWorks.Internal.Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(MLWorks.Internal.Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (MLWorks.Internal.Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => MLWorks.Internal.Array.sub(memo,(j-2))
end
val gotoT=MLWorks.Internal.Array.arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=MLWorks.Internal.Array.arrayoflist(actionRows) in fn i=>MLWorks.Internal.Array.sub(a,i) end
in MLWorks.Internal.Array.arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = Pos.pos
type arg = string
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit ->  unit
 | STRING of unit ->  (string) | RELINT of unit ->  (int)
 | INT of unit ->  (int) | ID of unit ->  (string)
 | TUPLE of unit ->  ( ( (cnstr_c list) * cnstr_c ) )
 | TPL_BOD of unit ->  ( ( cnstr_c list ) )
 | SorI_LST of unit ->  (string list)
 | STRINGorID of unit ->  (string)
 | NUMCMD1 of unit ->  ( ( int -> cnstr_c -> unit ) )
 | NUMCMD0 of unit ->  ( ( int -> unit ) )
 | REDS of unit ->  ( ( cnstr_c*cnstr_c )  list)
 | RED of unit ->  (cnstr_c*cnstr_c) | REDUCTION of unit ->  (cnstr_c)
 | RELGOAL of unit ->  (int) | INTROST of unit ->  (string list)
 | IDLST of unit ->  (string list) | IDLIST of unit ->  (string list)
 | DNSLBIND of unit ->  ( ( (visSort * (string list) * cnstr_c) * (string list) ) )
 | DNBIND of unit ->  ( ( visSort * (string list) * cnstr_c ) )
 | DLSLBIND of unit ->  ( ( (visSort * (string list) * cnstr_c) * (string list) ) )
 | DLBIND of unit ->  ( ( visSort * (string list) * cnstr_c ) )
 | DEFN of unit ->  (binder_c) | DECL of unit ->  (binder_c)
 | CTXTL of unit ->  (ctxt_c) | CTXTT of unit ->  (ctxt_c)
 | CNSTR of unit ->  (cnstr_c) | CAST of unit ->  (cnstr_c)
 | BIND of unit ->  (binder_c) | APPLN of unit ->  (cnstr_c)
 | ANONID of unit ->  (string)
end
type svalue = MlyValue.svalue
type result = unit
end
structure EC=
struct
open LrTable
val is_keyword =
fn _ => false
val preferred_insert =
fn _ => false
val preferred_subst =
fn  _ => nil
val noShift = 
fn (T 87) => true | (T 27) => true | _ => false
val showTerminal =
fn (T 0) => "ALLE"
  | (T 1) => "ALLI"
  | (T 2) => "ANDE"
  | (T 3) => "ANDI"
  | (T 4) => "AND"
  | (T 5) => "ARROW"
  | (T 6) => "BACKSLASH"
  | (T 7) => "BAR"
  | (T 8) => "CD"
  | (T 9) => "CLAIM"
  | (T 10) => "COLON"
  | (T 11) => "CONFIG"
  | (T 12) => "CONTRACT"
  | (T 13) => "COMMA"
  | (T 14) => "CTXT"
  | (T 15) => "CHOICE"
  | (T 16) => "DEQ"
  | (T 17) => "DOLLARSQ"
  | (T 18) => "DISCHARGE"
  | (T 19) => "DISCHARGEKEEP"
  | (T 20) => "DNF"
  | (T 21) => "DOT"
  | (T 22) => "DOT1"
  | (T 23) => "DOT2"
  | (T 24) => "DECLS"
  | (T 25) => "ECHO"
  | (T 26) => "ELIM"
  | (T 27) => "EOF"
  | (T 28) => "EQUL"
  | (T 29) => "EQUIV"
  | (T 30) => "EXE"
  | (T 31) => "EXI"
  | (T 32) => "EXPALL"
  | (T 33) => "EXPAND"
  | (T 34) => "EXPORT"
  | (T 35) => "FREEZE"
  | (T 36) => "FORGET"
  | (T 37) => "FORGETMARK"
  | (T 38) => "FROM"
  | (T 39) => "GEN"
  | (T 40) => "GOAL"
  | (T 41) => "HASH"
  | (T 42) => "HELP"
  | (T 43) => "HNF"
  | (T 44) => "ID"
  | (T 45) => "INCLUDE"
  | (T 46) => "IMMED"
  | (T 47) => "IMPE"
  | (T 48) => "IMPI"
  | (T 49) => "INIT"
  | (T 50) => "INT"
  | (T 51) => "INTROS"
  | (T 52) => "iNTROS"
  | (T 53) => "IMPORT"
  | (T 54) => "KILLREF"
  | (T 55) => "LOGIC"
  | (T 56) => "LCBR"
  | (T 57) => "LINE"
  | (T 58) => "LPTBR"
  | (T 59) => "LRBR"
  | (T 60) => "LSQBR"
  | (T 61) => "LOAD"
  | (T 62) => "MODULE"
  | (T 63) => "MARKS"
  | (T 64) => "NEXT"
  | (T 65) => "NORMAL"
  | (T 66) => "NOTE"
  | (T 67) => "NOTI"
  | (T 68) => "OR"
  | (T 69) => "ORE"
  | (T 70) => "ORIL"
  | (T 71) => "ORIR"
  | (T 72) => "PRF"
  | (T 73) => "PRINTTIMER"
  | (T 74) => "PROP"
  | (T 75) => "PWD"
  | (T 76) => "QM"
  | (T 77) => "QREPL"
  | (T 78) => "RCBR"
  | (T 79) => "REFINE"
  | (T 80) => "RELINT"
  | (T 81) => "RPTBR"
  | (T 82) => "RRBR"
  | (T 83) => "RSQBR"
  | (T 84) => "RELOAD"
  | (T 85) => "SAVE"
  | (T 86) => "DOLLARSAVE"
  | (T 87) => "SEMICOLON"
  | (T 88) => "SLASHS"
  | (T 89) => "STARTTIMER"
  | (T 90) => "STRING"
  | (T 91) => "TILDE"
  | (T 92) => "TREG"
  | (T 93) => "TYPE"
  | (T 94) => "TYPEOF"
  | (T 95) => "UNDERSCORE"
  | (T 96) => "UNFREEZE"
  | (T 97) => "UNDO"
  | (T 98) => "INDUCTIVE"
  | (T 99) => "NOREDS"
  | (T 100) => "PARAMS"
  | (T 101) => "CONSTRS"
  | (T 102) => "VREG"
  | _ => "bogus-term"
val errtermvalue= fn x =>
let open Header in
fn _ => MlyValue.VOID
end x
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 6
) :: (T 7) :: (T 8) :: (T 9) :: (T 10) :: (T 11) :: (T 12) :: (T 13)
 :: (T 14) :: (T 15) :: (T 16) :: (T 17) :: (T 18) :: (T 19) :: (T 20)
 :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 25) :: (T 26) :: (T 27)
 :: (T 28) :: (T 29) :: (T 30) :: (T 31) :: (T 32) :: (T 33) :: (T 34)
 :: (T 35) :: (T 36) :: (T 37) :: (T 38) :: (T 39) :: (T 40) :: (T 41)
 :: (T 42) :: (T 43) :: (T 45) :: (T 46) :: (T 47) :: (T 48) :: (T 49)
 :: (T 51) :: (T 52) :: (T 53) :: (T 54) :: (T 55) :: (T 56) :: (T 57)
 :: (T 58) :: (T 59) :: (T 60) :: (T 61) :: (T 62) :: (T 63) :: (T 64)
 :: (T 65) :: (T 66) :: (T 67) :: (T 68) :: (T 69) :: (T 70) :: (T 71)
 :: (T 72) :: (T 73) :: (T 74) :: (T 75) :: (T 76) :: (T 77) :: (T 78)
 :: (T 79) :: (T 81) :: (T 82) :: (T 83) :: (T 84) :: (T 85) :: (T 86)
 :: (T 87) :: (T 88) :: (T 89) :: (T 91) :: (T 92) :: (T 93) :: (T 94)
 :: (T 95) :: (T 96) :: (T 97) :: (T 98) :: (T 99) :: (T 100) :: (T 
101) :: (T 102) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = fn x => (
 let open Header
 in
  fn (i392,defaultPos,stack,
    (filename):arg) =>
  case (i392,stack)
  of (0,(_,(MlyValue.ntVOID EXPRSN1,EXPRSN1left,EXPRSN1right))::rest671)
   => let val result=MlyValue.ntVOID(fn _ => (let val EXPRSN1=EXPRSN1 ()
   in ( ) end
  ;()))
   in (LrTable.NT 25,(result,EXPRSN1left,EXPRSN1right),rest671) end
  | (1,(_,(MlyValue.CTXTT CTXTT1,CTXTT1left,CTXTT1right))::rest671) => 
  let val result=MlyValue.ntVOID(fn _ => (let val CTXTT as CTXTT1=CTXTT1
   ()
   in ( EvalCxt CTXTT ) end
  ;()))
   in (LrTable.NT 14,(result,CTXTT1left,CTXTT1right),rest671) end
  | (2,(_,(MlyValue.CAST CAST1,CAST1left,CAST1right))::rest671) => let 
  val result=MlyValue.ntVOID(fn _ => (let val CAST as CAST1=CAST1 ()
   in ( Eval CAST ) end
  ;()))
   in (LrTable.NT 14,(result,CAST1left,CAST1right),rest671) end
  | (3,(_,(MlyValue.REDUCTION REDUCTION1,REDUCTION1left,REDUCTION1right)
  )::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val 
  REDUCTION as REDUCTION1=REDUCTION1 ()
   in ( EvalRed REDUCTION ) end
  ;()))
   in (LrTable.NT 14,(result,REDUCTION1left,REDUCTION1right),rest671)
   end
  | (4,(_,(MlyValue.ntVOID CMD1,CMD1left,CMD1right))::rest671) => let 
  val result=MlyValue.ntVOID(fn _ => (let val CMD1=CMD1 ()
   in ( ) end
  ;()))
   in (LrTable.NT 14,(result,CMD1left,CMD1right),rest671) end
  | (5,(_,(MlyValue.ntVOID NUMCMD1,NUMCMD1left,NUMCMD1right))::rest671)
   => let val result=MlyValue.ntVOID(fn _ => (let val NUMCMD1=NUMCMD1 ()
   in ( ) end
  ;()))
   in (LrTable.NT 14,(result,NUMCMD1left,NUMCMD1right),rest671) end
  | (6,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.ID ID1,
  ID1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (let 
  val ID as ID1=ID1 ()
  val CAST as CAST1=CAST1 ()
   in ( evalCxt (Let,Def,Global,[],[ID],CAST) ) end
  ;()))
   in (LrTable.NT 14,(result,ID1left,CAST1right),rest671) end
  | (7,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.CTXTT 
  CTXTT1,_,_))::(_,(MlyValue.ID ID1,ID1left,_))::rest671) => let val 
  result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
  val CTXTT as CTXTT1=CTXTT1 ()
  val CAST as CAST1=CAST1 ()
   in (
   evalCxt (Let,Def,Global,[],[ID],
                                                  Ctxt_c (CTXTT,CAST)) 
  ) end
  ;()))
   in (LrTable.NT 14,(result,ID1left,CAST1right),rest671) end
  | (8,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.APPLN 
  APPLN1,_,_))::_::(_,(MlyValue.ID ID1,ID1left,_))::rest671) => let val 
  result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
  val APPLN as APPLN1=APPLN1 ()
  val CAST as CAST1=CAST1 ()
   in (
   evalCxt (Let,Def,Global,[],[ID],
                                                  Cast_c (CAST,APPLN)) 
  ) end
  ;()))
   in (LrTable.NT 14,(result,ID1left,CAST1right),rest671) end
  | (9,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.APPLN 
  APPLN1,_,_))::_::(_,(MlyValue.CTXTT CTXTT1,_,_))::(_,(MlyValue.ID ID1,
  ID1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (let 
  val ID as ID1=ID1 ()
  val CTXTT as CTXTT1=CTXTT1 ()
  val APPLN as APPLN1=APPLN1 ()
  val CAST as CAST1=CAST1 ()
   in (
   evalCxt (Let,Def,Global,[],[ID],Ctxt_c 
                                                  (CTXTT,Cast_c (CAST,APPLN))) 
  ) end
  ;()))
   in (LrTable.NT 14,(result,ID1left,CAST1right),rest671) end
  | (10,rest671) => let val result=MlyValue.ntVOID(fn _ => ( ))
   in (LrTable.NT 14,(result,defaultPos,defaultPos),rest671) end
  | (11,(_,(MlyValue.STRING STRING1,_,STRING1right))::(_,(_,ECHO1left,_)
  )::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val STRING
   as STRING1=STRING1 ()
   in ( message ("-- "^STRING^" --") ) end
  ;()))
   in (LrTable.NT 4,(result,ECHO1left,STRING1right),rest671) end
  | (12,(_,(_,LINE1left,LINE1right))::rest671) => let val result=
  MlyValue.ntVOID(fn _ => ( line () ))
   in (LrTable.NT 4,(result,LINE1left,LINE1right),rest671) end
  | (13,(_,(MlyValue.STRINGorID STRINGorID1,_,STRINGorID1right))::(_,(_,
  LOAD1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
  let val STRINGorID as STRINGorID1=STRINGorID1 ()
   in ( Load STRINGorID ) end
  ;()))
   in (LrTable.NT 4,(result,LOAD1left,STRINGorID1right),rest671) end
  | (14,(_,(MlyValue.STRINGorID STRINGorID1,_,STRINGorID1right))::(_,(_,
  RELOAD1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
  let val STRINGorID as STRINGorID1=STRINGorID1 ()
   in ( ReloadFrom STRINGorID STRINGorID ) end
  ;()))
   in (LrTable.NT 4,(result,RELOAD1left,STRINGorID1right),rest671) end
  | (15,(_,(MlyValue.STRINGorID STRINGorID2,_,STRINGorID2right))::_::(_,
  (MlyValue.STRINGorID STRINGorID1,_,_))::(_,(_,RELOAD1left,_))::rest671
  ) => let val result=MlyValue.ntVOID(fn _ => (let val STRINGorID1=
  STRINGorID1 ()
  val STRINGorID2=STRINGorID2 ()
   in ( ReloadFrom STRINGorID1 STRINGorID2 ) end
  ;()))
   in (LrTable.NT 4,(result,RELOAD1left,STRINGorID2right),rest671) end
  | (16,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,MODULE1left,_))::rest671
  ) => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
   in ( ModuleImport ID filename [] ) end
  ;()))
   in (LrTable.NT 4,(result,MODULE1left,ID1right),rest671) end
  | (17,(_,(MlyValue.SorI_LST SorI_LST1,_,SorI_LST1right))::_::(_,(
  MlyValue.ID ID1,_,_))::(_,(_,MODULE1left,_))::rest671) => let val 
  result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
  val SorI_LST as SorI_LST1=SorI_LST1 ()
   in ( ModuleImport ID filename SorI_LST ) end
  ;()))
   in (LrTable.NT 4,(result,MODULE1left,SorI_LST1right),rest671) end
  | (18,(_,(MlyValue.STRINGorID STRINGorID1,_,STRINGorID1right))::(_,(_,
  EXPORT1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
  let val STRINGorID as STRINGorID1=STRINGorID1 ()
   in ignore( (* exportML STRINGorID *) true ) end
  ;()))
   in (LrTable.NT 4,(result,EXPORT1left,STRINGorID1right),rest671) end
  | (19,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,DISCHARGE1left,_))::
  rest671) => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=
  ID1 ()
  in ( Discharge ID ) end
  ;()))
   in (LrTable.NT 4,(result,DISCHARGE1left,ID1right),rest671) end
  | (20,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,DISCHARGEKEEP1left,_))::
  rest671) => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=
  ID1 ()
   in ( DischargeKeep ID ) end
  ;()))
   in (LrTable.NT 4,(result,DISCHARGEKEEP1left,ID1right),rest671) end
  | (21,(_,(MlyValue.INTROST INTROST1,_,INTROST1right))::(_,(_,
  INTROS1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
  let val INTROST as INTROST1=INTROST1 ()
   in ( Intros (~9999) true INTROST ) end
  ;()))
   in (LrTable.NT 4,(result,INTROS1left,INTROST1right),rest671) end
  | (22,(_,(MlyValue.INTROST INTROST1,_,INTROST1right))::(_,(
MlyValue.RELGOAL RELGOAL1,_,_))::(_,(_,INTROS1left,_))::rest671) => 
let val result=MlyValue.ntVOID(fn _ => (let val RELGOAL as RELGOAL1=
RELGOAL1 ()
val INTROST as INTROST1=INTROST1 ()
 in ( Intros RELGOAL true INTROST ) end
;()))
 in (LrTable.NT 4,(result,INTROS1left,INTROST1right),rest671) end
| (23,(_,(MlyValue.INTROST INTROST1,_,INTROST1right))::(_,(_,
iNTROS1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
let val INTROST as INTROST1=INTROST1 ()
 in ( Intros (~9999) false INTROST ) end
;()))
 in (LrTable.NT 4,(result,iNTROS1left,INTROST1right),rest671) end
| (24,(_,(MlyValue.INTROST INTROST1,_,INTROST1right))::(_,(
MlyValue.RELGOAL RELGOAL1,_,_))::(_,(_,iNTROS1left,_))::rest671) => 
let val result=MlyValue.ntVOID(fn _ => (let val RELGOAL as RELGOAL1=
RELGOAL1 ()
val INTROST as INTROST1=INTROST1 ()
 in ( Intros RELGOAL false INTROST ) end
;()))
 in (LrTable.NT 4,(result,iNTROS1left,INTROST1right),rest671) end
| (25,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(_,REFINE1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( Refine (~9999) 0 CAST ) end
;()))
 in (LrTable.NT 4,(result,REFINE1left,CAST1right),rest671) end
| (26,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(MlyValue.RELGOAL 
RELGOAL1,_,_))::(_,(_,REFINE1left,_))::rest671) => let val result=
MlyValue.ntVOID(fn _ => (let val RELGOAL as RELGOAL1=RELGOAL1 ()
val CAST as CAST1=CAST1 ()
 in ( Refine RELGOAL 0 CAST ) end
;()))
 in (LrTable.NT 4,(result,REFINE1left,CAST1right),rest671) end
| (27,(_,(MlyValue.INT INT1,_,INT1right))::_::(_,(MlyValue.CAST CAST1,
_,_))::(_,(_,REFINE1left,_))::rest671) => let val result=
MlyValue.ntVOID(fn _ => (let val CAST as CAST1=CAST1 ()
val INT as INT1=INT1 ()
 in ( Refine (~9999) INT CAST ) end
;()))
 in (LrTable.NT 4,(result,REFINE1left,INT1right),rest671) end
| (28,(_,(MlyValue.INT INT1,_,INT1right))::_::(_,(MlyValue.CAST CAST1,
_,_))::(_,(MlyValue.RELGOAL RELGOAL1,_,_))::(_,(_,REFINE1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val RELGOAL
 as RELGOAL1=RELGOAL1 ()
val CAST as CAST1=CAST1 ()
val INT as INT1=INT1 ()
 in ( Refine RELGOAL INT CAST ) end
;()))
 in (LrTable.NT 4,(result,REFINE1left,INT1right),rest671) end
| (29,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(_,QREPL1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( replace (~9999) CAST ) end
;()))
 in (LrTable.NT 4,(result,QREPL1left,CAST1right),rest671) end
| (30,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(MlyValue.RELGOAL 
RELGOAL1,_,_))::(_,(_,QREPL1left,_))::rest671) => let val result=
MlyValue.ntVOID(fn _ => (let val RELGOAL as RELGOAL1=RELGOAL1 ()
val CAST as CAST1=CAST1 ()
 in ( replace RELGOAL CAST ) end
;()))
 in (LrTable.NT 4,(result,QREPL1left,CAST1right),rest671) end
| (31,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(_,EQUIV1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( Equiv CAST ) end
;()))
 in (LrTable.NT 4,(result,EQUIV1left,CAST1right),rest671) end
| (32,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(_,EQUIV1left,_))
::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( V_Equiv CAST ) end
;()))
 in (LrTable.NT 4,(result,EQUIV1left,CAST1right),rest671) end
| (33,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(_,EQUIV1left,_))
::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( T_Equiv CAST ) end
;()))
 in (LrTable.NT 4,(result,EQUIV1left,CAST1right),rest671) end
| (34,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(_,CLAIM1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( Claim CAST ) end
;()))
 in (LrTable.NT 4,(result,CLAIM1left,CAST1right),rest671) end
| (35,(_,(_,_,QREPL1right))::(_,(_,CONFIG1left,_))::rest671) => let 
val result=MlyValue.ntVOID(fn _ => ( Config_Qrepl ("","","") ))
 in (LrTable.NT 4,(result,CONFIG1left,QREPL1right),rest671) end
| (36,(_,(MlyValue.ID ID3,_,ID3right))::(_,(MlyValue.ID ID2,_,_))::(_,
(MlyValue.ID ID1,_,_))::_::(_,(_,CONFIG1left,_))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => (let val ID1=ID1 ()
val ID2=ID2 ()
val ID3=ID3 ()
 in ( Config_Qrepl (ID1,ID2,ID3) ) end
;()))
 in (LrTable.NT 4,(result,CONFIG1left,ID3right),rest671) end
| (37,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(_,GOAL1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val CAST as 
CAST1=CAST1 ()
 in ( Goal CAST ) end
;()))
 in (LrTable.NT 4,(result,GOAL1left,CAST1right),rest671) end
| (38,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::(_,(_,EXPAND1left,_))
::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val IDLST
 as IDLST1=IDLST1 ()
 in ( Expand IDLST ) end
;()))
 in (LrTable.NT 4,(result,EXPAND1left,IDLST1right),rest671) end
| (39,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::_::(_,(_,EXPAND1left,
_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val IDLST
 as IDLST1=IDLST1 ()
 in ( V_Expand IDLST ) end
;()))
 in (LrTable.NT 4,(result,EXPAND1left,IDLST1right),rest671) end
| (40,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::_::(_,(_,EXPAND1left,
_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val IDLST
 as IDLST1=IDLST1 ()
 in ( T_Expand IDLST ) end
;()))
 in (LrTable.NT 4,(result,EXPAND1left,IDLST1right),rest671) end
| (41,(_,(MlyValue.RELGOAL RELGOAL1,_,RELGOAL1right))::(_,(_,
EXPALL1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
let val RELGOAL as RELGOAL1=RELGOAL1 ()
 in ( ExpAll RELGOAL ) end
;()))
 in (LrTable.NT 4,(result,EXPALL1left,RELGOAL1right),rest671) end
| (42,(_,(MlyValue.INT INT1,_,INT1right))::_::(_,(_,EXPALL1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val INT as 
INT1=INT1 ()
 in ( V_ExpAll INT ) end
;()))
 in (LrTable.NT 4,(result,EXPALL1left,INT1right),rest671) end
| (43,(_,(MlyValue.INT INT1,_,INT1right))::_::(_,(_,EXPALL1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val INT as 
INT1=INT1 ()
 in ( T_ExpAll INT ) end
;()))
 in (LrTable.NT 4,(result,EXPALL1left,INT1right),rest671) end
| (44,(_,(_,HNF1left,HNF1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( Hnf() ))
 in (LrTable.NT 4,(result,HNF1left,HNF1right),rest671) end
| (45,(_,(_,_,VREG1right))::(_,(_,HNF1left,_))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => ( V_Hnf() ))
 in (LrTable.NT 4,(result,HNF1left,VREG1right),rest671) end
| (46,(_,(_,_,TREG1right))::(_,(_,HNF1left,_))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => ( T_Hnf() ))
 in (LrTable.NT 4,(result,HNF1left,TREG1right),rest671) end
| (47,(_,(_,DNF1left,DNF1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( Dnf() ))
 in (LrTable.NT 4,(result,DNF1left,DNF1right),rest671) end
| (48,(_,(_,_,VREG1right))::(_,(_,DNF1left,_))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => ( V_Dnf() ))
 in (LrTable.NT 4,(result,DNF1left,VREG1right),rest671) end
| (49,(_,(_,_,TREG1right))::(_,(_,DNF1left,_))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => ( T_Dnf() ))
 in (LrTable.NT 4,(result,DNF1left,TREG1right),rest671) end
| (50,(_,(MlyValue.STRINGorID STRINGorID1,_,STRINGorID1right))::(_,(_,
INCLUDE1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (
let val STRINGorID as STRINGorID1=STRINGorID1 ()
 in ( Include STRINGorID ) end
;()))
 in (LrTable.NT 4,(result,INCLUDE1left,STRINGorID1right),rest671) end
| (51,(_,(_,NORMAL1left,NORMAL1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( Normal () ))
 in (LrTable.NT 4,(result,NORMAL1left,NORMAL1right),rest671) end
| (52,(_,(_,_,VREG1right))::(_,(_,NORMAL1left,_))::rest671) => let 
val result=MlyValue.ntVOID(fn _ => ( V_Normal () ))
 in (LrTable.NT 4,(result,NORMAL1left,VREG1right),rest671) end
| (53,(_,(_,_,TREG1right))::(_,(_,NORMAL1left,_))::rest671) => let 
val result=MlyValue.ntVOID(fn _ => ( T_Normal () ))
 in (LrTable.NT 4,(result,NORMAL1left,TREG1right),rest671) end
| (54,(_,(MlyValue.RELGOAL RELGOAL1,_,RELGOAL1right))::(_,(_,NEXT1left
,_))::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val 
RELGOAL as RELGOAL1=RELGOAL1 ()
 in ( Next RELGOAL ) end
;()))
 in (LrTable.NT 4,(result,NEXT1left,RELGOAL1right),rest671) end
| (55,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,SAVE1left,_))::rest671)
 => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
 in ( Save ID Global ) end
;()))
 in (LrTable.NT 4,(result,SAVE1left,ID1right),rest671) end
| (56,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,DOLLARSAVE1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=
ID1 ()
 in ( Save ID Local ) end
;()))
 in (LrTable.NT 4,(result,DOLLARSAVE1left,ID1right),rest671) end
| (57,(_,(_,IMMED1left,IMMED1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( Immed [] ))
 in (LrTable.NT 4,(result,IMMED1left,IMMED1right),rest671) end
| (58,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::(_,(_,FREEZE1left,_))
::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val IDLST
 as IDLST1=IDLST1 ()
 in ignore( Freeze IDLST ) end
;()))
 in (LrTable.NT 4,(result,FREEZE1left,IDLST1right),rest671) end
| (59,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::(_,(_,UNFREEZE1left,_
))::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val IDLST
 as IDLST1=IDLST1 ()
 in ignore( Unfreeze IDLST ) end
;()))
 in (LrTable.NT 4,(result,UNFREEZE1left,IDLST1right),rest671) end
| (60,(_,(_,STARTTIMER1left,STARTTIMER1right))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => ( (*StartTimer*)() ))
 in (LrTable.NT 4,(result,STARTTIMER1left,STARTTIMER1right),rest671)
 end
| (61,(_,(_,PRINTTIMER1left,PRINTTIMER1right))::rest671) => let val 
result=MlyValue.ntVOID(fn _ => ( (*PrintTimer*)() ))
 in (LrTable.NT 4,(result,PRINTTIMER1left,PRINTTIMER1right),rest671)
 end
| (62,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,INIT1left,_))::rest671)
 => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
 in (
 case ID of
                                         "LF"   => (Init LF;DefsAsDeltas())
                                       | "PCC"  => (Init PCC;DefsAsDeltas())
                                       | "XCC"  => (Init XCC;DefsAsDeltas())
                                       | "XCC'" => (Init XCC;DefsAsMacros())
                                       | _ => failwith
                                           "LF, PCC, XCC or XCC' expected" 
) end
;()))
 in (LrTable.NT 4,(result,INIT1left,ID1right),rest671) end
| (63,(_,(_,CTXT1left,CTXT1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( prt_context_dpth 999999 ElideDfns ))
 in (LrTable.NT 4,(result,CTXT1left,CTXT1right),rest671) end
| (64,(_,(MlyValue.INT INT1,_,INT1right))::(_,(_,CTXT1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val INT as 
INT1=INT1 ()
 in ( prt_context_dpth INT ElideDfns ) end
;()))
 in (LrTable.NT 4,(result,CTXT1left,INT1right),rest671) end
| (65,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,CTXT1left,_))::rest671)
 => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
 in ( prt_context_nam ID ElideDfns ) end
;()))
 in (LrTable.NT 4,(result,CTXT1left,ID1right),rest671) end
| (66,(_,(_,DECLS1left,DECLS1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( prt_context_dpth 999999 OmitDfns ))
 in (LrTable.NT 4,(result,DECLS1left,DECLS1right),rest671) end
| (67,(_,(MlyValue.INT INT1,_,INT1right))::(_,(_,DECLS1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val INT as 
INT1=INT1 ()
 in ( prt_context_dpth INT OmitDfns ) end
;()))
 in (LrTable.NT 4,(result,DECLS1left,INT1right),rest671) end
| (68,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,DECLS1left,_))::rest671)
 => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
 in ( prt_context_nam ID OmitDfns ) end
;()))
 in (LrTable.NT 4,(result,DECLS1left,ID1right),rest671) end
| (69,(_,(_,MARKS1left,MARKS1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( prt_context_dpth 999999 Marks ))
 in (LrTable.NT 4,(result,MARKS1left,MARKS1right),rest671) end
| (70,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,FORGET1left,_))::rest671
) => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=ID1 ()
 in ( Forget ID ) end
;()))
 in (LrTable.NT 4,(result,FORGET1left,ID1right),rest671) end
| (71,(_,(MlyValue.ID ID1,_,ID1right))::(_,(_,FORGETMARK1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val ID as ID1=
ID1 ()
 in ( ForgetMrk ID ) end
;()))
 in (LrTable.NT 4,(result,FORGETMARK1left,ID1right),rest671) end
| (72,(_,(_,PRF1left,PRF1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( PR () ))
 in (LrTable.NT 4,(result,PRF1left,PRF1right),rest671) end
| (73,(_,(MlyValue.INT INT1,_,INT1right))::(_,(_,UNDO1left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val INT as 
INT1=INT1 ()
 in ( UNDO INT ) end
;()))
 in (LrTable.NT 4,(result,UNDO1left,INT1right),rest671) end
| (74,(_,(_,KILLREF1left,KILLREF1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( KillRef () ))
 in (LrTable.NT 4,(result,KILLREF1left,KILLREF1right),rest671) end
| (75,(_,(_,PWD1left,PWD1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( message(getwd()) ))
 in (LrTable.NT 4,(result,PWD1left,PWD1right),rest671) end
| (76,(_,(MlyValue.STRING STRING1,_,STRING1right))::(_,(_,CD1left,_))
::rest671) => let val result=MlyValue.ntVOID(fn _ => (let val STRING
 as STRING1=STRING1 ()
 in (

                   setwd STRING
	             handle NotDirectory =>
	               message("Error: cannot find directory "^STRING);
                    message(getwd()) 
) end
;()))
 in (LrTable.NT 4,(result,CD1left,STRING1right),rest671) end
| (77,(_,(_,LOGIC1left,LOGIC1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => (

                  case theory()
		    of lf     => message"No impredicative logic for LF"
		     | xtndCC => (killRef(); (!legoStringParser) logicPreludeXCC)
		     | pureCC => (killRef(); (!legoStringParser) logicPreludePCC) 
))
 in (LrTable.NT 4,(result,LOGIC1left,LOGIC1right),rest671) end
| (78,(_,(_,HELP1left,HELP1right))::rest671) => let val result=
MlyValue.ntVOID(fn _ => ( help() ))
 in (LrTable.NT 4,(result,HELP1left,HELP1right),rest671) end
| (79,(_,(MlyValue.CTXTL CTXTL2,_,CTXTL2right))::_::(_,(MlyValue.CTXTL
 CTXTL1,_,_))::(_,(_,INDUCTIVE1left,_))::rest671) => let val result=
MlyValue.ntVOID(fn _ => (let val CTXTL1=CTXTL1 ()
val CTXTL2=CTXTL2 ()
 in ( inductive_datatype [] CTXTL1 CTXTL2 false ) end
;()))
 in (LrTable.NT 4,(result,INDUCTIVE1left,CTXTL2right),rest671) end
| (80,(_,(MlyValue.CTXTL CTXTL3,_,CTXTL3right))::_::(_,(MlyValue.CTXTL
 CTXTL2,_,_))::_::(_,(MlyValue.CTXTL CTXTL1,_,_))::(_,(_,
INDUCTIVE1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _
 => (let val CTXTL1=CTXTL1 ()
val CTXTL2=CTXTL2 ()
val CTXTL3=CTXTL3 ()
 in ( inductive_datatype CTXTL2 CTXTL1 CTXTL3 false ) end
;()))
 in (LrTable.NT 4,(result,INDUCTIVE1left,CTXTL3right),rest671) end
| (81,(_,(_,_,NOREDS1right))::(_,(MlyValue.CTXTL CTXTL2,_,_))::_::(_,(
MlyValue.CTXTL CTXTL1,_,_))::(_,(_,INDUCTIVE1left,_))::rest671) => 
let val result=MlyValue.ntVOID(fn _ => (let val CTXTL1=CTXTL1 ()
val CTXTL2=CTXTL2 ()
 in ( inductive_datatype [] CTXTL1 CTXTL2 true ) end
;()))
 in (LrTable.NT 4,(result,INDUCTIVE1left,NOREDS1right),rest671) end
| (82,(_,(_,_,NOREDS1right))::(_,(MlyValue.CTXTL CTXTL3,_,_))::_::(_,(
MlyValue.CTXTL CTXTL2,_,_))::_::(_,(MlyValue.CTXTL CTXTL1,_,_))::(_,(_
,INDUCTIVE1left,_))::rest671) => let val result=MlyValue.ntVOID(fn _
 => (let val CTXTL1=CTXTL1 ()
val CTXTL2=CTXTL2 ()
val CTXTL3=CTXTL3 ()
 in ( inductive_datatype CTXTL2 CTXTL1 CTXTL3 true ) end
;()))
 in (LrTable.NT 4,(result,INDUCTIVE1left,NOREDS1right),rest671) end
| (83,(_,(MlyValue.RELGOAL RELGOAL1,_,RELGOAL1right))::(_,(
MlyValue.NUMCMD0 NUMCMD01,NUMCMD01left,_))::rest671) => let val result
=MlyValue.ntVOID(fn _ => (let val NUMCMD0 as NUMCMD01=NUMCMD01 ()
val RELGOAL as RELGOAL1=RELGOAL1 ()
 in ( NUMCMD0 RELGOAL ) end
;()))
 in (LrTable.NT 22,(result,NUMCMD01left,RELGOAL1right),rest671) end
| (84,(_,(MlyValue.NUMCMD0 NUMCMD01,NUMCMD01left,NUMCMD01right))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val NUMCMD0
 as NUMCMD01=NUMCMD01 ()
 in ( NUMCMD0 (~9999) ) end
;()))
 in (LrTable.NT 22,(result,NUMCMD01left,NUMCMD01right),rest671) end
| (85,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(MlyValue.RELGOAL 
RELGOAL1,_,_))::(_,(MlyValue.NUMCMD1 NUMCMD11,NUMCMD11left,_))::
rest671) => let val result=MlyValue.ntVOID(fn _ => (let val NUMCMD1
 as NUMCMD11=NUMCMD11 ()
val RELGOAL as RELGOAL1=RELGOAL1 ()
val CAST as CAST1=CAST1 ()
 in ( NUMCMD1 RELGOAL CAST ) end
;()))
 in (LrTable.NT 22,(result,NUMCMD11left,CAST1right),rest671) end
| (86,(_,(MlyValue.CAST CAST1,_,CAST1right))::(_,(MlyValue.NUMCMD1 
NUMCMD11,NUMCMD11left,_))::rest671) => let val result=MlyValue.ntVOID(
fn _ => (let val NUMCMD1 as NUMCMD11=NUMCMD11 ()
val CAST as CAST1=CAST1 ()
 in ( NUMCMD1 (~9999) CAST ) end
;()))
 in (LrTable.NT 22,(result,NUMCMD11left,CAST1right),rest671) end
| (87,(_,(_,ANDI1left,ANDI1right))::rest671) => let val result=
MlyValue.NUMCMD0(fn _ => ( AndIntro ))
 in (LrTable.NT 23,(result,ANDI1left,ANDI1right),rest671) end
| (88,(_,(_,ORIL1left,ORIL1right))::rest671) => let val result=
MlyValue.NUMCMD0(fn _ => ( OrIntroL ))
 in (LrTable.NT 23,(result,ORIL1left,ORIL1right),rest671) end
| (89,(_,(_,ORIR1left,ORIR1right))::rest671) => let val result=
MlyValue.NUMCMD0(fn _ => ( OrIntroR ))
 in (LrTable.NT 23,(result,ORIR1left,ORIR1right),rest671) end
| (90,(_,(_,NOTI1left,NOTI1right))::rest671) => let val result=
MlyValue.NUMCMD0(fn _ => ( NotIntro ))
 in (LrTable.NT 23,(result,NOTI1left,NOTI1right),rest671) end
| (91,(_,(_,IMPI1left,IMPI1right))::rest671) => let val result=
MlyValue.NUMCMD0(fn _ => ( AllIntro ))
 in (LrTable.NT 23,(result,IMPI1left,IMPI1right),rest671) end
| (92,(_,(_,ALLI1left,ALLI1right))::rest671) => let val result=
MlyValue.NUMCMD0(fn _ => ( AllIntro ))
 in (LrTable.NT 23,(result,ALLI1left,ALLI1right),rest671) end
| (93,(_,(_,ANDE1left,ANDE1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( AndElim ))
 in (LrTable.NT 24,(result,ANDE1left,ANDE1right),rest671) end
| (94,(_,(_,ORE1left,ORE1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( OrElim ))
 in (LrTable.NT 24,(result,ORE1left,ORE1right),rest671) end
| (95,(_,(_,NOTE1left,NOTE1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( NotElim ))
 in (LrTable.NT 24,(result,NOTE1left,NOTE1right),rest671) end
| (96,(_,(_,EXE1left,EXE1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( ExElim ))
 in (LrTable.NT 24,(result,EXE1left,EXE1right),rest671) end
| (97,(_,(_,IMPE1left,IMPE1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( AllElim ))
 in (LrTable.NT 24,(result,IMPE1left,IMPE1right),rest671) end
| (98,(_,(_,ALLE1left,ALLE1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( AllElim ))
 in (LrTable.NT 24,(result,ALLE1left,ALLE1right),rest671) end
| (99,(_,(_,EXI1left,EXI1right))::rest671) => let val result=
MlyValue.NUMCMD1(fn _ => ( ExIntro ))
 in (LrTable.NT 24,(result,EXI1left,EXI1right),rest671) end
| (100,(_,(MlyValue.BIND BIND1,BIND1left,BIND1right))::rest671) => 
let val result=MlyValue.CTXTT(fn _ => let val BIND as BIND1=BIND1 ()
 in ( [BIND] ) end
)
 in (LrTable.NT 6,(result,BIND1left,BIND1right),rest671) end
| (101,(_,(MlyValue.CTXTT CTXTT1,_,CTXTT1right))::(_,(MlyValue.BIND 
BIND1,BIND1left,_))::rest671) => let val result=MlyValue.CTXTT(fn _
 => let val BIND as BIND1=BIND1 ()
val CTXTT as CTXTT1=CTXTT1 ()
 in ( BIND::CTXTT ) end
)
 in (LrTable.NT 6,(result,BIND1left,CTXTT1right),rest671) end
| (102,(_,(MlyValue.DECL DECL1,DECL1left,DECL1right))::rest671) => 
let val result=MlyValue.CTXTL(fn _ => let val DECL as DECL1=DECL1 ()
 in ( [DECL] ) end
)
 in (LrTable.NT 7,(result,DECL1left,DECL1right),rest671) end
| (103,(_,(MlyValue.CTXTL CTXTL1,_,CTXTL1right))::(_,(MlyValue.DECL 
DECL1,DECL1left,_))::rest671) => let val result=MlyValue.CTXTL(fn _
 => let val DECL as DECL1=DECL1 ()
val CTXTL as CTXTL1=CTXTL1 ()
 in ( DECL::CTXTL ) end
)
 in (LrTable.NT 7,(result,DECL1left,CTXTL1right),rest671) end
| (104,(_,(MlyValue.DECL DECL1,DECL1left,DECL1right))::rest671) => 
let val result=MlyValue.BIND(fn _ => let val DECL as DECL1=DECL1 ()
 in ( DECL ) end
)
 in (LrTable.NT 2,(result,DECL1left,DECL1right),rest671) end
| (105,(_,(MlyValue.DEFN DEFN1,DEFN1left,DEFN1right))::rest671) => 
let val result=MlyValue.BIND(fn _ => let val DEFN as DEFN1=DEFN1 ()
 in ( DEFN ) end
)
 in (LrTable.NT 2,(result,DEFN1left,DEFN1right),rest671) end
| (106,(_,(_,_,RSQBR1right))::(_,(MlyValue.DLSLBIND DLSLBIND1,_,_))::(
_,(_,LSQBR1left,_))::rest671) => let val result=MlyValue.DECL(fn _ => 
let val DLSLBIND as DLSLBIND1=DLSLBIND1 ()
 in (
 let val ((x,y,z),w) = DLSLBIND 
                                        in (Lda,x,Local,w,y,z) end 
) end
)
 in (LrTable.NT 8,(result,LSQBR1left,RSQBR1right),rest671) end
| (107,(_,(_,_,RSQBR1right))::(_,(MlyValue.DLSLBIND DLSLBIND1,_,_))::(
_,(_,DOLLARSQ1left,_))::rest671) => let val result=MlyValue.DECL(fn _
 => let val DLSLBIND as DLSLBIND1=DLSLBIND1 ()
 in (
 let val ((x,y,z),w) = DLSLBIND
                                        in (Lda,x,Global,w,y,z) end 
) end
)
 in (LrTable.NT 8,(result,DOLLARSQ1left,RSQBR1right),rest671) end
| (108,(_,(_,_,RCBR1right))::(_,(MlyValue.DLSLBIND DLSLBIND1,_,_))::(_
,(_,LCBR1left,_))::rest671) => let val result=MlyValue.DECL(fn _ => 
let val DLSLBIND as DLSLBIND1=DLSLBIND1 ()
 in (
 let val ((x,y,z),w) = DLSLBIND
                                        in (Pi,x,Local,w,y,z) end 
) end
)
 in (LrTable.NT 8,(result,LCBR1left,RCBR1right),rest671) end
| (109,(_,(_,_,RPTBR1right))::(_,(MlyValue.DLSLBIND DLSLBIND1,_,_))::(
_,(_,LPTBR1left,_))::rest671) => let val result=MlyValue.DECL(fn _ => 
let val DLSLBIND as DLSLBIND1=DLSLBIND1 ()
 in (
 let val ((x,y,z),w) = DLSLBIND
                                        in (Sig,x,Local,w,y,z) end 
) end
)
 in (LrTable.NT 8,(result,LPTBR1left,RPTBR1right),rest671) end
| (110,(_,(_,_,RSQBR1right))::(_,(MlyValue.DNSLBIND DNSLBIND1,_,_))::(
_,(_,LSQBR1left,_))::rest671) => let val result=MlyValue.DEFN(fn _ => 
let val DNSLBIND as DNSLBIND1=DNSLBIND1 ()
 in (
 let val ((x,y,z),w) = DNSLBIND 
                                        in (Let,x,Global,w,y,z) end 
) end
)
 in (LrTable.NT 9,(result,LSQBR1left,RSQBR1right),rest671) end
| (111,(_,(_,_,RSQBR1right))::(_,(MlyValue.DNSLBIND DNSLBIND1,_,_))::(
_,(_,DOLLARSQ1left,_))::rest671) => let val result=MlyValue.DEFN(fn _
 => let val DNSLBIND as DNSLBIND1=DNSLBIND1 ()
 in (
 let val ((x,y,z),w) = DNSLBIND 
                                        in (Let,x,Local,w,y,z) end 
) end
)
 in (LrTable.NT 9,(result,DOLLARSQ1left,RSQBR1right),rest671) end
| (112,(_,(_,_,RSQBR1right))::(_,(MlyValue.REDS REDS1,_,_))::(_,(
MlyValue.CTXTT CTXTT1,_,_))::(_,(_,LSQBR1left,_))::rest671) => let 
val result=MlyValue.REDUCTION(fn _ => let val CTXTT as CTXTT1=CTXTT1 
()
val REDS as REDS1=REDS1 ()
 in ( Red_c(CTXTT,REDS) ) end
)
 in (LrTable.NT 19,(result,LSQBR1left,RSQBR1right),rest671) end
| (113,(_,(MlyValue.RED RED1,RED1left,RED1right))::rest671) => let 
val result=MlyValue.REDS(fn _ => let val RED as RED1=RED1 ()
 in ( [RED] ) end
)
 in (LrTable.NT 21,(result,RED1left,RED1right),rest671) end
| (114,(_,(MlyValue.REDS REDS1,_,REDS1right))::_::(_,(MlyValue.RED 
RED1,RED1left,_))::rest671) => let val result=MlyValue.REDS(fn _ => 
let val RED as RED1=RED1 ()
val REDS as REDS1=REDS1 ()
 in ( RED::REDS ) end
)
 in (LrTable.NT 21,(result,RED1left,REDS1right),rest671) end
| (115,(_,(MlyValue.APPLN APPLN2,_,APPLN2right))::_::(_,(
MlyValue.APPLN APPLN1,APPLN1left,_))::rest671) => let val result=
MlyValue.RED(fn _ => let val APPLN1=APPLN1 ()
val APPLN2=APPLN2 ()
 in ( (APPLN1,APPLN2) ) end
)
 in (LrTable.NT 20,(result,APPLN1left,APPLN2right),rest671) end
| (116,(_,(MlyValue.APPLN APPLN1,APPLN1left,APPLN1right))::rest671)
 => let val result=MlyValue.CAST(fn _ => let val APPLN as APPLN1=
APPLN1 ()
 in ( APPLN ) end
)
 in (LrTable.NT 3,(result,APPLN1left,APPLN1right),rest671) end
| (117,(_,(MlyValue.APPLN APPLN2,_,APPLN2right))::_::(_,(
MlyValue.APPLN APPLN1,APPLN1left,_))::rest671) => let val result=
MlyValue.CAST(fn _ => let val APPLN1=APPLN1 ()
val APPLN2=APPLN2 ()
 in ( Cast_c (APPLN1,APPLN2) ) end
)
 in (LrTable.NT 3,(result,APPLN1left,APPLN2right),rest671) end
| (118,(_,(MlyValue.CNSTR CNSTR1,CNSTR1left,CNSTR1right))::rest671)
 => let val result=MlyValue.APPLN(fn _ => let val CNSTR as CNSTR1=
CNSTR1 ()
 in ( CNSTR ) end
)
 in (LrTable.NT 1,(result,CNSTR1left,CNSTR1right),rest671) end
| (119,(_,(MlyValue.CNSTR CNSTR1,_,CNSTR1right))::(_,(MlyValue.APPLN 
APPLN1,APPLN1left,_))::rest671) => let val result=MlyValue.APPLN(fn _
 => let val APPLN as APPLN1=APPLN1 ()
val CNSTR as CNSTR1=CNSTR1 ()
 in ( App_c (ShowNorm,APPLN,CNSTR) ) end
)
 in (LrTable.NT 1,(result,APPLN1left,CNSTR1right),rest671) end
| (120,(_,(MlyValue.CNSTR CNSTR1,_,CNSTR1right))::_::(_,(
MlyValue.APPLN APPLN1,APPLN1left,_))::rest671) => let val result=
MlyValue.APPLN(fn _ => let val APPLN as APPLN1=APPLN1 ()
val CNSTR as CNSTR1=CNSTR1 ()
 in ( App_c (ShowForce,APPLN,CNSTR) ) end
)
 in (LrTable.NT 1,(result,APPLN1left,CNSTR1right),rest671) end
| (121,(_,(_,PROP1left,PROP1right))::rest671) => let val result=
MlyValue.CNSTR(fn _ => ( Prop_c ))
 in (LrTable.NT 5,(result,PROP1left,PROP1right),rest671) end
| (122,(_,(_,TYPE1left,TYPE1right))::rest671) => let val result=
MlyValue.CNSTR(fn _ => (
 case theory()
               of lf => Prop_c
                | pureCC => failwith"'Type' not in the language of PCC"
                | _  => Type_c "" 
))
 in (LrTable.NT 5,(result,TYPE1left,TYPE1right),rest671) end
| (123,(_,(_,_,RRBR1right))::(_,(MlyValue.ID ID1,_,_))::_::(_,(_,
TYPE1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val ID as ID1=ID1 ()
 in (
 case theory()
               of lf => failwith"'Type(.)' not in the language of LF"
                | pureCC => failwith"'Type' not in the language of PCC"
	        | _ => Type_c ID 
) end
)
 in (LrTable.NT 5,(result,TYPE1left,RRBR1right),rest671) end
| (124,(_,(_,_,RRBR1right))::(_,(MlyValue.INT INT1,_,_))::_::(_,(_,
TYPE1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val INT as INT1=INT1 ()
 in (
 case theory()
               of lf => failwith"'Type(.)' not in the language of LF"
                | pureCC => failwith"'Type' not in the language of PCC"
	        | _ => TypeAbs_c INT 
) end
)
 in (LrTable.NT 5,(result,TYPE1left,RRBR1right),rest671) end
| (125,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.CNSTR(fn _ => let val ID as ID1=ID1 ()
 in ( Ref_c ID ) end
)
 in (LrTable.NT 5,(result,ID1left,ID1right),rest671) end
| (126,(_,(MlyValue.APPLN APPLN1,_,APPLN1right))::_::(_,(
MlyValue.CNSTR CNSTR1,CNSTR1left,_))::rest671) => let val result=
MlyValue.CNSTR(fn _ => let val CNSTR as CNSTR1=CNSTR1 ()
val APPLN as APPLN1=APPLN1 ()
 in (Bind_c ((Pi,Vis,Local,[],[""],CNSTR),APPLN)) end
)
 in (LrTable.NT 5,(result,CNSTR1left,APPLN1right),rest671) end
| (127,(_,(MlyValue.APPLN APPLN1,_,APPLN1right))::_::(_,(
MlyValue.CNSTR CNSTR1,CNSTR1left,_))::rest671) => let val result=
MlyValue.CNSTR(fn _ => let val CNSTR as CNSTR1=CNSTR1 ()
val APPLN as APPLN1=APPLN1 ()
 in (Bind_c ((Sig,Vis,Local,[],[""],CNSTR),APPLN)) end
)
 in (LrTable.NT 5,(result,CNSTR1left,APPLN1right),rest671) end
| (128,(_,(MlyValue.APPLN APPLN1,_,APPLN1right))::_::(_,(
MlyValue.CNSTR CNSTR1,CNSTR1left,_))::rest671) => let val result=
MlyValue.CNSTR(fn _ => let val CNSTR as CNSTR1=CNSTR1 ()
val APPLN as APPLN1=APPLN1 ()
 in (Bind_c ((Lda,Vis,Local,[],[""],CNSTR),APPLN)) end
)
 in (LrTable.NT 5,(result,CNSTR1left,APPLN1right),rest671) end
| (129,(_,(MlyValue.APPLN APPLN1,_,APPLN1right))::(_,(MlyValue.BIND 
BIND1,BIND1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _
 => let val BIND as BIND1=BIND1 ()
val APPLN as APPLN1=APPLN1 ()
 in ( Bind_c (BIND,APPLN) ) end
)
 in (LrTable.NT 5,(result,BIND1left,APPLN1right),rest671) end
| (130,(_,(MlyValue.TUPLE TUPLE1,TUPLE1left,TUPLE1right))::rest671)
 => let val result=MlyValue.CNSTR(fn _ => let val TUPLE as TUPLE1=
TUPLE1 ()
 in ( Tuple_c TUPLE ) end
)
 in (LrTable.NT 5,(result,TUPLE1left,TUPLE1right),rest671) end
| (131,(_,(_,_,DOT11right))::(_,(MlyValue.CNSTR CNSTR1,CNSTR1left,_))
::rest671) => let val result=MlyValue.CNSTR(fn _ => let val CNSTR as 
CNSTR1=CNSTR1 ()
 in ( Proj_c (Fst,CNSTR) ) end
)
 in (LrTable.NT 5,(result,CNSTR1left,DOT11right),rest671) end
| (132,(_,(_,_,DOT21right))::(_,(MlyValue.CNSTR CNSTR1,CNSTR1left,_))
::rest671) => let val result=MlyValue.CNSTR(fn _ => let val CNSTR as 
CNSTR1=CNSTR1 ()
 in ( Proj_c (Snd,CNSTR) ) end
)
 in (LrTable.NT 5,(result,CNSTR1left,DOT21right),rest671) end
| (133,(_,(MlyValue.CNSTR CNSTR2,_,CNSTR2right))::_::(_,(
MlyValue.CNSTR CNSTR1,CNSTR1left,_))::rest671) => let val result=
MlyValue.CNSTR(fn _ => let val CNSTR1=CNSTR1 ()
val CNSTR2=CNSTR2 ()
 in ( App_c (ShowNorm,CNSTR2,CNSTR1) ) end
)
 in (LrTable.NT 5,(result,CNSTR1left,CNSTR2right),rest671) end
| (134,(_,(_,_,RRBR1right))::(_,(MlyValue.CAST CAST1,_,_))::(_,(_,
LRBR1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val CAST as CAST1=CAST1 ()
 in ( CAST ) end
)
 in (LrTable.NT 5,(result,LRBR1left,RRBR1right),rest671) end
| (135,(_,(_,_,RRBR1right))::(_,(MlyValue.CAST CAST1,_,_))::_::(_,(_,
LRBR1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val CAST as CAST1=CAST1 ()
 in ( Normal_c CAST ) end
)
 in (LrTable.NT 5,(result,LRBR1left,RRBR1right),rest671) end
| (136,(_,(_,_,RRBR1right))::(_,(MlyValue.CAST CAST1,_,_))::_::(_,(_,
LRBR1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val CAST as CAST1=CAST1 ()
 in ( Hnf_c CAST ) end
)
 in (LrTable.NT 5,(result,LRBR1left,RRBR1right),rest671) end
| (137,(_,(_,_,RRBR1right))::(_,(MlyValue.CAST CAST1,_,_))::_::(_,(_,
LRBR1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val CAST as CAST1=CAST1 ()
 in ( Dnf_c CAST ) end
)
 in (LrTable.NT 5,(result,LRBR1left,RRBR1right),rest671) end
| (138,(_,(_,_,RRBR1right))::(_,(MlyValue.CAST CAST1,_,_))::_::(_,(_,
LRBR1left,_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let 
val CAST as CAST1=CAST1 ()
 in ( TypeOf_c CAST ) end
)
 in (LrTable.NT 5,(result,LRBR1left,RRBR1right),rest671) end
| (139,(_,(_,_,RRBR1right))::(_,(MlyValue.CAST CAST1,_,_))::(_,(
MlyValue.ID ID1,_,_))::_::(_,(_,LRBR1left,_))::rest671) => let val 
result=MlyValue.CNSTR(fn _ => let val ID as ID1=ID1 ()
val CAST as CAST1=CAST1 ()
 in ( Gen_c (CAST,ID) ) end
)
 in (LrTable.NT 5,(result,LRBR1left,RRBR1right),rest671) end
| (140,(_,(_,QM1left,QM1right))::rest671) => let val result=
MlyValue.CNSTR(fn _ => ( NewVar_c ))
 in (LrTable.NT 5,(result,QM1left,QM1right),rest671) end
| (141,(_,(MlyValue.RELGOAL RELGOAL1,_,RELGOAL1right))::(_,(_,QM1left,
_))::rest671) => let val result=MlyValue.CNSTR(fn _ => let val RELGOAL
 as RELGOAL1=RELGOAL1 ()
 in ( Var_c RELGOAL ) end
)
 in (LrTable.NT 5,(result,QM1left,RELGOAL1right),rest671) end
| (142,(_,(MlyValue.CNSTR CNSTR2,_,CNSTR2right))::_::(_,(
MlyValue.CNSTR CNSTR1,CNSTR1left,_))::rest671) => let val result=
MlyValue.CNSTR(fn _ => let val CNSTR1=CNSTR1 ()
val CNSTR2=CNSTR2 ()
 in (
 App_c
             (ShowNorm,App_c (ShowNorm,Ref_c "and",CNSTR1),CNSTR2) 
) end
)
 in (LrTable.NT 5,(result,CNSTR1left,CNSTR2right),rest671) end
| (143,(_,(MlyValue.CNSTR CNSTR2,_,CNSTR2right))::_::(_,(
MlyValue.CNSTR CNSTR1,CNSTR1left,_))::rest671) => let val result=
MlyValue.CNSTR(fn _ => let val CNSTR1=CNSTR1 ()
val CNSTR2=CNSTR2 ()
 in (
 App_c 
             (ShowNorm,App_c (ShowNorm,Ref_c "or",CNSTR1),CNSTR2) 
) end
)
 in (LrTable.NT 5,(result,CNSTR1left,CNSTR2right),rest671) end
| (144,(_,(MlyValue.CNSTR CNSTR1,_,CNSTR1right))::(_,(_,TILDE1left,_))
::rest671) => let val result=MlyValue.CNSTR(fn _ => let val CNSTR as 
CNSTR1=CNSTR1 ()
 in ( App_c (ShowNorm,Ref_c "not",CNSTR) ) end
)
 in (LrTable.NT 5,(result,TILDE1left,CNSTR1right),rest671) end
| (145,(_,(_,_,RRBR1right))::(_,(MlyValue.APPLN APPLN1,_,_))::_::(_,(
MlyValue.TPL_BOD TPL_BOD1,_,_))::(_,(_,LRBR1left,_))::rest671) => let 
val result=MlyValue.TUPLE(fn _ => let val TPL_BOD as TPL_BOD1=TPL_BOD1
 ()
val APPLN as APPLN1=APPLN1 ()
 in ( (TPL_BOD,APPLN) ) end
)
 in (LrTable.NT 29,(result,LRBR1left,RRBR1right),rest671) end
| (146,(_,(_,_,RRBR1right))::(_,(MlyValue.TPL_BOD TPL_BOD1,_,_))::(_,(
_,LRBR1left,_))::rest671) => let val result=MlyValue.TUPLE(fn _ => 
let val TPL_BOD as TPL_BOD1=TPL_BOD1 ()
 in ( (TPL_BOD,Bot_c) ) end
)
 in (LrTable.NT 29,(result,LRBR1left,RRBR1right),rest671) end
| (147,(_,(MlyValue.APPLN APPLN2,_,APPLN2right))::_::(_,(
MlyValue.APPLN APPLN1,APPLN1left,_))::rest671) => let val result=
MlyValue.TPL_BOD(fn _ => let val APPLN1=APPLN1 ()
val APPLN2=APPLN2 ()
 in ( [APPLN1,APPLN2] ) end
)
 in (LrTable.NT 28,(result,APPLN1left,APPLN2right),rest671) end
| (148,(_,(MlyValue.TPL_BOD TPL_BOD1,_,TPL_BOD1right))::_::(_,(
MlyValue.APPLN APPLN1,APPLN1left,_))::rest671) => let val result=
MlyValue.TPL_BOD(fn _ => let val APPLN as APPLN1=APPLN1 ()
val TPL_BOD as TPL_BOD1=TPL_BOD1 ()
 in ( APPLN::TPL_BOD ) end
)
 in (LrTable.NT 28,(result,APPLN1left,TPL_BOD1right),rest671) end
| (149,(_,(MlyValue.APPLN APPLN1,_,APPLN1right))::_::(_,(
MlyValue.IDLIST IDLIST1,IDLIST1left,_))::rest671) => let val result=
MlyValue.DLBIND(fn _ => let val IDLIST as IDLIST1=IDLIST1 ()
val APPLN as APPLN1=APPLN1 ()
 in ( (Vis,IDLIST,APPLN) ) end
)
 in (LrTable.NT 10,(result,IDLIST1left,APPLN1right),rest671) end
| (150,(_,(MlyValue.APPLN APPLN1,_,APPLN1right))::_::(_,(
MlyValue.IDLIST IDLIST1,IDLIST1left,_))::rest671) => let val result=
MlyValue.DLBIND(fn _ => let val IDLIST as IDLIST1=IDLIST1 ()
val APPLN as APPLN1=APPLN1 ()
 in ( (Hid,IDLIST,APPLN) ) end
)
 in (LrTable.NT 10,(result,IDLIST1left,APPLN1right),rest671) end
| (151,(_,(MlyValue.DLBIND DLBIND1,DLBIND1left,DLBIND1right))::rest671
) => let val result=MlyValue.DLSLBIND(fn _ => let val DLBIND as 
DLBIND1=DLBIND1 ()
 in ( (DLBIND,[]) ) end
)
 in (LrTable.NT 11,(result,DLBIND1left,DLBIND1right),rest671) end
| (152,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::_::(_,(
MlyValue.DLBIND DLBIND1,DLBIND1left,_))::rest671) => let val result=
MlyValue.DLSLBIND(fn _ => let val DLBIND as DLBIND1=DLBIND1 ()
val IDLST as IDLST1=IDLST1 ()
 in ( (DLBIND,IDLST) ) end
)
 in (LrTable.NT 11,(result,DLBIND1left,IDLST1right),rest671) end
| (153,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.IDLIST 
IDLIST1,IDLIST1left,_))::rest671) => let val result=MlyValue.DNBIND(
fn _ => let val IDLIST as IDLIST1=IDLIST1 ()
val CAST as CAST1=CAST1 ()
 in ( (Def,IDLIST,CAST) ) end
)
 in (LrTable.NT 12,(result,IDLIST1left,CAST1right),rest671) end
| (154,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.CTXTT 
CTXTT1,_,_))::(_,(MlyValue.IDLIST IDLIST1,IDLIST1left,_))::rest671)
 => let val result=MlyValue.DNBIND(fn _ => let val IDLIST as IDLIST1=
IDLIST1 ()
val CTXTT as CTXTT1=CTXTT1 ()
val CAST as CAST1=CAST1 ()
 in ( (Def,IDLIST,Ctxt_c (CTXTT,CAST)) ) end
)
 in (LrTable.NT 12,(result,IDLIST1left,CAST1right),rest671) end
| (155,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.APPLN 
APPLN1,_,_))::_::(_,(MlyValue.IDLIST IDLIST1,IDLIST1left,_))::rest671)
 => let val result=MlyValue.DNBIND(fn _ => let val IDLIST as IDLIST1=
IDLIST1 ()
val APPLN as APPLN1=APPLN1 ()
val CAST as CAST1=CAST1 ()
 in ( (Def,IDLIST,Cast_c (CAST,APPLN)) ) end
)
 in (LrTable.NT 12,(result,IDLIST1left,CAST1right),rest671) end
| (156,(_,(MlyValue.CAST CAST1,_,CAST1right))::_::(_,(MlyValue.APPLN 
APPLN1,_,_))::_::(_,(MlyValue.CTXTT CTXTT1,_,_))::(_,(MlyValue.IDLIST 
IDLIST1,IDLIST1left,_))::rest671) => let val result=MlyValue.DNBIND(
fn _ => let val IDLIST as IDLIST1=IDLIST1 ()
val CTXTT as CTXTT1=CTXTT1 ()
val APPLN as APPLN1=APPLN1 ()
val CAST as CAST1=CAST1 ()
 in (
 (Def,IDLIST,
                                          Ctxt_c (CTXTT,Cast_c (CAST,APPLN))) 
) end
)
 in (LrTable.NT 12,(result,IDLIST1left,CAST1right),rest671) end
| (157,(_,(MlyValue.DNBIND DNBIND1,DNBIND1left,DNBIND1right))::rest671
) => let val result=MlyValue.DNSLBIND(fn _ => let val DNBIND as 
DNBIND1=DNBIND1 ()
 in ( (DNBIND,[]) ) end
)
 in (LrTable.NT 13,(result,DNBIND1left,DNBIND1right),rest671) end
| (158,(_,(MlyValue.IDLST IDLST1,_,IDLST1right))::_::(_,(
MlyValue.DNBIND DNBIND1,DNBIND1left,_))::rest671) => let val result=
MlyValue.DNSLBIND(fn _ => let val DNBIND as DNBIND1=DNBIND1 ()
val IDLST as IDLST1=IDLST1 ()
 in ( (DNBIND,IDLST) ) end
)
 in (LrTable.NT 13,(result,DNBIND1left,IDLST1right),rest671) end
| (159,(_,(MlyValue.ANONID ANONID1,ANONID1left,ANONID1right))::rest671
) => let val result=MlyValue.IDLIST(fn _ => let val ANONID as ANONID1=
ANONID1 ()
 in ( [ANONID] ) end
)
 in (LrTable.NT 15,(result,ANONID1left,ANONID1right),rest671) end
| (160,(_,(MlyValue.ANONID ANONID1,_,ANONID1right))::_::(_,(
MlyValue.IDLIST IDLIST1,IDLIST1left,_))::rest671) => let val result=
MlyValue.IDLIST(fn _ => let val IDLIST as IDLIST1=IDLIST1 ()
val ANONID as ANONID1=ANONID1 ()
 in ( IDLIST @ [ANONID] ) end
)
 in (LrTable.NT 15,(result,IDLIST1left,ANONID1right),rest671) end
| (161,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.ANONID(fn _ => let val ID as ID1=ID1 ()
 in ( ID ) end
)
 in (LrTable.NT 0,(result,ID1left,ID1right),rest671) end
| (162,(_,(_,UNDERSCORE1left,UNDERSCORE1right))::rest671) => let val 
result=MlyValue.ANONID(fn _ => ( "" ))
 in (LrTable.NT 0,(result,UNDERSCORE1left,UNDERSCORE1right),rest671)
 end
| (163,(_,(MlyValue.ANONID ANONID1,ANONID1left,ANONID1right))::rest671
) => let val result=MlyValue.INTROST(fn _ => let val ANONID as ANONID1
=ANONID1 ()
 in ( [ANONID] ) end
)
 in (LrTable.NT 17,(result,ANONID1left,ANONID1right),rest671) end
| (164,(_,(_,HASH1left,HASH1right))::rest671) => let val result=
MlyValue.INTROST(fn _ => ( ["#"] ))
 in (LrTable.NT 17,(result,HASH1left,HASH1right),rest671) end
| (165,(_,(MlyValue.ANONID ANONID1,_,ANONID1right))::(_,(
MlyValue.INTROST INTROST1,INTROST1left,_))::rest671) => let val result
=MlyValue.INTROST(fn _ => let val INTROST as INTROST1=INTROST1 ()
val ANONID as ANONID1=ANONID1 ()
 in ( INTROST @ [ANONID] ) end
)
 in (LrTable.NT 17,(result,INTROST1left,ANONID1right),rest671) end
| (166,(_,(_,_,HASH1right))::(_,(MlyValue.INTROST INTROST1,
INTROST1left,_))::rest671) => let val result=MlyValue.INTROST(fn _ => 
let val INTROST as INTROST1=INTROST1 ()
 in ( INTROST @ ["#"] ) end
)
 in (LrTable.NT 17,(result,INTROST1left,HASH1right),rest671) end
| (167,rest671) => let val result=MlyValue.INTROST(fn _ => ( [] ))
 in (LrTable.NT 17,(result,defaultPos,defaultPos),rest671) end
| (168,rest671) => let val result=MlyValue.IDLST(fn _ => ( [] ))
 in (LrTable.NT 16,(result,defaultPos,defaultPos),rest671) end
| (169,(_,(MlyValue.ID ID1,_,ID1right))::(_,(MlyValue.IDLST IDLST1,
IDLST1left,_))::rest671) => let val result=MlyValue.IDLST(fn _ => let 
val IDLST as IDLST1=IDLST1 ()
val ID as ID1=ID1 ()
 in ( IDLST @ [ID] ) end
)
 in (LrTable.NT 16,(result,IDLST1left,ID1right),rest671) end
| (170,(_,(MlyValue.INT INT1,INT1left,INT1right))::rest671) => let 
val result=MlyValue.RELGOAL(fn _ => let val INT as INT1=INT1 ()
 in ( INT ) end
)
 in (LrTable.NT 18,(result,INT1left,INT1right),rest671) end
| (171,(_,(MlyValue.RELINT RELINT1,RELINT1left,RELINT1right))::rest671
) => let val result=MlyValue.RELGOAL(fn _ => let val RELINT as RELINT1
=RELINT1 ()
 in ( fst (goal_plusn RELINT) ) end
)
 in (LrTable.NT 18,(result,RELINT1left,RELINT1right),rest671) end
| (172,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.STRINGorID(fn _ => let val ID as ID1=ID1 ()
 in ( ID ) end
)
 in (LrTable.NT 26,(result,ID1left,ID1right),rest671) end
| (173,(_,(MlyValue.STRING STRING1,STRING1left,STRING1right))::rest671
) => let val result=MlyValue.STRINGorID(fn _ => let val STRING as 
STRING1=STRING1 ()
 in ( STRING ) end
)
 in (LrTable.NT 26,(result,STRING1left,STRING1right),rest671) end
| (174,(_,(MlyValue.STRINGorID STRINGorID1,_,STRINGorID1right))::(_,(
MlyValue.SorI_LST SorI_LST1,SorI_LST1left,_))::rest671) => let val 
result=MlyValue.SorI_LST(fn _ => let val SorI_LST as SorI_LST1=
SorI_LST1 ()
val STRINGorID as STRINGorID1=STRINGorID1 ()
 in ( SorI_LST @ [STRINGorID] ) end
)
 in (LrTable.NT 27,(result,SorI_LST1left,STRINGorID1right),rest671)
 end
| (175,rest671) => let val result=MlyValue.SorI_LST(fn _ => ( [] ))
 in (LrTable.NT 27,(result,defaultPos,defaultPos),rest671) end
| _ => raise (mlyAction i392)
end) x
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.ntVOID x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a ()
end
end
structure Tokens : Lego_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun ALLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun ALLI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun BACKSLASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun CD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun CLAIM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun CONFIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun CONTRACT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun CTXT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun CHOICE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun DEQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun DOLLARSQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun DISCHARGE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun DISCHARGEKEEP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun DNF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT1 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT2 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun DECLS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun ECHO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun ELIM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUIV (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun EXE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun EXI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun EXPALL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun EXPAND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun EXPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun FREEZE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun FORGET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun FORGETMARK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun FROM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun GEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun GOAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun HELP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun HNF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.ID (fn () => i),p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun IMMED (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun INIT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.INT (fn () => i),p1,p2))
fun INTROS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun iNTROS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun KILLREF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun LOGIC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun LCBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun LINE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun LPTBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun LRBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun LSQBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun LOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun MODULE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun MARKS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun NEXT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun NORMAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID,p1,p2))
fun NOTE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
fun NOTI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID,p1,p2))
fun OR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
fun ORE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69,(
ParserData.MlyValue.VOID,p1,p2))
fun ORIL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(
ParserData.MlyValue.VOID,p1,p2))
fun ORIR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(
ParserData.MlyValue.VOID,p1,p2))
fun PRF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(
ParserData.MlyValue.VOID,p1,p2))
fun PRINTTIMER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 73,(
ParserData.MlyValue.VOID,p1,p2))
fun PROP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 74,(
ParserData.MlyValue.VOID,p1,p2))
fun PWD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 75,(
ParserData.MlyValue.VOID,p1,p2))
fun QM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 76,(
ParserData.MlyValue.VOID,p1,p2))
fun QREPL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 77,(
ParserData.MlyValue.VOID,p1,p2))
fun RCBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 78,(
ParserData.MlyValue.VOID,p1,p2))
fun REFINE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 79,(
ParserData.MlyValue.VOID,p1,p2))
fun RELINT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 80,(
ParserData.MlyValue.RELINT (fn () => i),p1,p2))
fun RPTBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 81,(
ParserData.MlyValue.VOID,p1,p2))
fun RRBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 82,(
ParserData.MlyValue.VOID,p1,p2))
fun RSQBR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 83,(
ParserData.MlyValue.VOID,p1,p2))
fun RELOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 84,(
ParserData.MlyValue.VOID,p1,p2))
fun SAVE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 85,(
ParserData.MlyValue.VOID,p1,p2))
fun DOLLARSAVE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 86,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 87,(
ParserData.MlyValue.VOID,p1,p2))
fun SLASHS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 88,(
ParserData.MlyValue.VOID,p1,p2))
fun STARTTIMER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 89,(
ParserData.MlyValue.VOID,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 90,(
ParserData.MlyValue.STRING (fn () => i),p1,p2))
fun TILDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 91,(
ParserData.MlyValue.VOID,p1,p2))
fun TREG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 92,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 93,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPEOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 94,(
ParserData.MlyValue.VOID,p1,p2))
fun UNDERSCORE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 95,(
ParserData.MlyValue.VOID,p1,p2))
fun UNFREEZE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 96,(
ParserData.MlyValue.VOID,p1,p2))
fun UNDO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 97,(
ParserData.MlyValue.VOID,p1,p2))
fun INDUCTIVE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 98,(
ParserData.MlyValue.VOID,p1,p2))
fun NOREDS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 99,(
ParserData.MlyValue.VOID,p1,p2))
fun PARAMS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 100,(
ParserData.MlyValue.VOID,p1,p2))
fun CONSTRS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 101,(
ParserData.MlyValue.VOID,p1,p2))
fun VREG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 102,(
ParserData.MlyValue.VOID,p1,p2))
end
end
