
(*
 * Lambda-Calculus Optimisation: lambdaoptimiser
 * Main Control Module
 *
 * Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *)

require "lambdatypes";
require "../main/options";

signature LAMBDAOPTIMISER = 
  sig
    structure LambdaTypes : LAMBDATYPES
    structure Options : OPTIONS
    val optimise : Options.options -> LambdaTypes.LambdaExp -> LambdaTypes.LambdaExp
    val simple_beta_reduce : LambdaTypes.LambdaExp -> LambdaTypes.LambdaExp
  end;

(*
$Log: lambdaoptimiser.sml,v $
Revision 1.22  1995/05/12 15:11:29  matthew
Removing redundant controls

Revision 1.21  1993/05/18  10:55:11  jont
Added a ref to control maximum size of expression for which we
optimise until done

Revision 1.20  1993/05/11  12:38:07  jont
Made optimise take the full Options.options

Revision 1.19  1993/03/04  12:56:33  matthew
Options & Info changes

Revision 1.18  1993/02/01  17:59:27  matthew
Added sharing constraints

Revision 1.17  1992/11/26  19:41:45  daveb
Changes to make show_id_class and show_eq_info part of Info structure
instead of references.

Revision 1.16  1992/07/24  13:35:46  clive
Modified to use the new hashtables

Revision 1.15  1992/07/03  07:48:38  davida
Added check validity switch.

Revision 1.14  1991/10/22  14:20:09  davidt
Replaced impossible exception with Crash.impossible calls.

Revision 1.13  91/09/16  11:20:01  davida
Added turn_on_all, turn_off_all.

Revision 1.12  91/09/13  12:25:10  davida
Removed report switch, added timing.

Revision 1.11  91/09/11  12:10:31  davida
Added new display flags

Revision 1.10  91/09/10  14:52:14  davida
Removed redundant heuristic parameter

Revision 1.9  91/09/09  15:21:29  davida
New restructured sources.

Revision 1.8  91/09/04  11:14:21  davida
Added simple beta reduce function for export.

Revision 1.7  91/08/22  12:44:34  davida
Removed test-output flags from signature.  These
are no-longer refs, so that the debug code can be
left in, but we can compile a release version of
the compiler and a debug version: release version
will have dead code removed, hopefully.

Revision 1.6  91/08/06  15:09:32  davida
Removed sub-structure Set.

Revision 1.5  91/08/02  10:02:49  davida
Removed superfluous argument from top-level optimise
function, at last!

Revision 1.4  91/07/30  12:54:33  davida
Added diagnostic-output switches.

Revision 1.3  91/07/15  16:13:10  davida
Updated for new module LambdaSub

Revision 1.2  91/07/10  13:49:45  davida
Now has correct set of requires(!)

Revision 1.1  91/07/08  16:02:23  davida
Initial revision

*)

