(*
 *
 * $Log: elf_lex.sml,v $
 * Revision 1.2  1998/06/03 12:26:24  jont
 * Automatic checkin:
 * changed attribute _comment to ' * '
 *
 *
 *)
functor ElfLexFun(include sig
                    structure Tokens: Elf_TOKENS
		    structure Interface: INTERFACE
                  end where type Interface.pos = int) : LEXER=
   struct
    structure UserDeclarations =
      struct
(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)

structure Tokens = Tokens
structure Interface = Interface
open Interface

type pos = Interface.pos
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult= (svalue,pos) token

val comLevel = ref 0
fun eofAt (lpos,rpos) =
    ( if !comLevel > 0
         then ( comLevel := 0 ; 
	        error ("unclosed comment %{", (lpos, rpos)) )
	 else  () ;
      Tokens.EOF(lpos,rpos) )
fun eof () = (* last position will be inaccurate! *)
	     let val lastpos = Interface.last_newline () + 1
	      in eofAt(lastpos,lastpos) end

fun makeInt (s : string) =
    (revfold (fn (c,a) => a*10 + (ord c - ord("0"))) (explode s) 0)
fun stripquotes (s : string) = substring(s,1,size(s) - 2)

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\009\009\009\009\009\009\009\009\009\068\070\009\068\009\009\009\
\\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\
\\068\010\009\010\010\044\010\039\038\037\010\010\010\035\034\010\
\\032\032\032\032\032\032\032\032\032\032\031\010\029\010\010\010\
\\010\028\028\028\028\028\028\028\028\028\028\028\028\028\028\028\
\\028\028\028\028\028\028\028\028\028\028\028\027\010\026\010\024\
\\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\
\\010\010\010\019\015\010\010\010\010\010\010\014\010\012\010\009\
\\009"
val s3 =
"\071\071\071\071\071\071\071\071\071\071\074\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\072\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071"
val s5 =
"\075\075\075\075\075\075\075\075\075\075\081\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\078\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\075\
\\075\075\075\075\075\075\075\075\075\075\075\075\075\076\075\075\
\\075"
val s7 =
"\082\082\082\082\082\082\082\082\082\114\116\082\114\082\082\082\
\\082\082\082\082\082\082\082\082\082\082\082\082\082\082\082\082\
\\114\083\082\083\083\112\083\107\082\082\083\083\083\083\082\083\
\\105\105\105\105\105\105\105\105\105\105\082\083\083\083\083\083\
\\083\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\082\083\082\083\103\
\\083\083\083\083\083\083\083\083\083\083\083\083\099\083\095\083\
\\083\083\090\085\083\083\083\083\083\083\083\082\083\082\083\082\
\\082"
val s10 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\016\011\000\011\000\011\000\
\\000"
val s16 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\017\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\018\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\020\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\021\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\022\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\023\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s24 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\025\000\025\025\000\025\025\000\000\025\025\025\025\000\025\
\\025\025\025\025\025\025\025\025\025\025\000\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\025\000\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\025\000\025\000\
\\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\030\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\033\033\033\033\033\033\033\033\033\033\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\036\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\040\000\040\000\000\000\040\040\040\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\040\040\040\040\040\
\\040\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\000\040\000\040\042\
\\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\000\040\000\040\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\040\000\040\041\000\000\040\040\040\040\000\040\
\\040\040\040\040\040\040\040\040\040\040\000\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\000\040\000\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\000\040\000\040\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\042\000\042\042\000\042\043\000\000\042\042\042\042\000\042\
\\042\042\042\042\042\042\042\042\042\042\000\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\000\042\000\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\000\042\000\042\000\
\\000"
val s44 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\067\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\062\000\000\000\000\058\000\
\\046\000\000\000\000\000\000\000\000\000\000\045\000\000\000\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\052\
\\000\000\047\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\049\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\050\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\051\000\000\000\000\000\000\000\
\\000"
val s52 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\053\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\054\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s54 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\055\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\056\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\057\000\000\000\000\000\000\000\
\\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\059\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\060\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\061\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s62 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\063\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\064\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\065\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s65 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\066\000\000\000\000\000\000\000\
\\000"
val s68 =
"\000\000\000\000\000\000\000\000\000\069\000\000\069\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\069\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s72 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\073\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s76 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\077\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s78 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\080\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\079\000\000\000\000\
\\000"
val s83 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s85 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\086\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s86 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\087\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s87 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\088\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s88 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\089\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s90 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\091\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s91 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\092\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s92 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\093\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s93 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\094\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s95 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\096\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s96 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\097\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s97 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\098\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s99 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\100\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s100 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\101\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s101 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\084\000\084\084\000\084\084\000\000\084\084\084\084\000\084\
\\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\000\084\000\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\102\084\084\084\084\084\084\000\084\000\084\000\
\\000"
val s103 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\104\000\104\104\000\104\104\000\000\104\104\104\104\000\104\
\\104\104\104\104\104\104\104\104\104\104\000\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\000\104\000\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\000\104\000\104\000\
\\000"
val s105 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\106\106\106\106\106\106\106\106\106\106\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s107 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\108\000\108\108\000\108\000\000\000\108\108\108\108\000\108\
\\000\000\000\000\000\000\000\000\000\000\000\108\108\108\108\108\
\\108\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\000\108\000\108\110\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\000\108\000\108\000\
\\000"
val s108 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\108\000\108\108\000\108\109\000\000\108\108\108\108\000\108\
\\108\108\108\108\108\108\108\108\108\108\000\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\000\108\000\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\000\108\000\108\000\
\\000"
val s110 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\110\000\110\110\000\110\111\000\000\110\110\110\110\000\110\
\\110\110\110\110\110\110\110\110\110\110\000\110\110\110\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\000\110\000\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\000\110\000\110\000\
\\000"
val s112 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\113\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s114 =
"\000\000\000\000\000\000\000\000\000\115\000\000\115\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\115\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [(N 2)], trans = s1},
{fin = [(N 2)], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [(N 143)], trans = s7},
{fin = [(N 143)], trans = s7},
{fin = [(N 120)], trans = s0},
{fin = [(N 89),(N 120)], trans = s10},
{fin = [(N 89)], trans = s10},
{fin = [(N 25),(N 120)], trans = s12},
{fin = [(N 77)], trans = s0},
{fin = [(N 23),(N 120)], trans = s0},
{fin = [(N 89),(N 120)], trans = s15},
{fin = [(N 89)], trans = s16},
{fin = [(N 89)], trans = s17},
{fin = [(N 41),(N 89)], trans = s10},
{fin = [(N 89),(N 120)], trans = s19},
{fin = [(N 89)], trans = s20},
{fin = [(N 89)], trans = s21},
{fin = [(N 89)], trans = s22},
{fin = [(N 36),(N 89)], trans = s10},
{fin = [(N 30),(N 96),(N 120)], trans = s24},
{fin = [(N 96)], trans = s24},
{fin = [(N 21),(N 120)], trans = s0},
{fin = [(N 19),(N 120)], trans = s0},
{fin = [(N 96),(N 120)], trans = s24},
{fin = [(N 89),(N 120)], trans = s29},
{fin = [(N 9),(N 89)], trans = s10},
{fin = [(N 11),(N 120)], trans = s0},
{fin = [(N 99),(N 120)], trans = s32},
{fin = [(N 99)], trans = s32},
{fin = [(N 13),(N 120)], trans = s0},
{fin = [(N 89),(N 120)], trans = s35},
{fin = [(N 28),(N 89)], trans = s10},
{fin = [(N 17),(N 120)], trans = s0},
{fin = [(N 15),(N 120)], trans = s0},
{fin = [(N 120)], trans = s39},
{fin = [], trans = s40},
{fin = [(N 118)], trans = s40},
{fin = [], trans = s42},
{fin = [(N 118)], trans = s42},
{fin = [(N 6),(N 120)], trans = s44},
{fin = [(N 74)], trans = s0},
{fin = [], trans = s46},
{fin = [], trans = s47},
{fin = [], trans = s48},
{fin = [], trans = s49},
{fin = [], trans = s50},
{fin = [(N 56)], trans = s0},
{fin = [], trans = s52},
{fin = [], trans = s53},
{fin = [], trans = s54},
{fin = [], trans = s55},
{fin = [], trans = s56},
{fin = [(N 65)], trans = s0},
{fin = [], trans = s58},
{fin = [], trans = s59},
{fin = [], trans = s60},
{fin = [(N 71)], trans = s0},
{fin = [], trans = s62},
{fin = [], trans = s63},
{fin = [], trans = s64},
{fin = [], trans = s65},
{fin = [(N 48)], trans = s0},
{fin = [(N 80)], trans = s0},
{fin = [(N 2),(N 120)], trans = s68},
{fin = [(N 2)], trans = s68},
{fin = [(N 4)], trans = s0},
{fin = [(N 127)], trans = s0},
{fin = [(N 127)], trans = s72},
{fin = [(N 123)], trans = s0},
{fin = [(N 125)], trans = s0},
{fin = [(N 140)], trans = s0},
{fin = [(N 140)], trans = s76},
{fin = [(N 133)], trans = s0},
{fin = [(N 140)], trans = s78},
{fin = [(N 130)], trans = s0},
{fin = [(N 136)], trans = s0},
{fin = [(N 138)], trans = s0},
{fin = [(N 212)], trans = s0},
{fin = [(N 184),(N 212)], trans = s83},
{fin = [(N 184)], trans = s83},
{fin = [(N 184),(N 212)], trans = s85},
{fin = [(N 184)], trans = s86},
{fin = [(N 184)], trans = s87},
{fin = [(N 184)], trans = s88},
{fin = [(N 156),(N 184)], trans = s83},
{fin = [(N 184),(N 212)], trans = s90},
{fin = [(N 184)], trans = s91},
{fin = [(N 184)], trans = s92},
{fin = [(N 184)], trans = s93},
{fin = [(N 167),(N 184)], trans = s83},
{fin = [(N 184),(N 212)], trans = s95},
{fin = [(N 184)], trans = s96},
{fin = [(N 184)], trans = s97},
{fin = [(N 172),(N 184)], trans = s83},
{fin = [(N 184),(N 212)], trans = s99},
{fin = [(N 184)], trans = s100},
{fin = [(N 184)], trans = s101},
{fin = [(N 161),(N 184)], trans = s83},
{fin = [(N 191),(N 212)], trans = s103},
{fin = [(N 191)], trans = s103},
{fin = [(N 175),(N 212)], trans = s105},
{fin = [(N 175)], trans = s105},
{fin = [(N 212)], trans = s107},
{fin = [], trans = s108},
{fin = [(N 210)], trans = s108},
{fin = [], trans = s110},
{fin = [(N 210)], trans = s110},
{fin = [(N 147),(N 212)], trans = s112},
{fin = [(N 150)], trans = s0},
{fin = [(N 143),(N 212)], trans = s114},
{fin = [(N 143)], trans = s114},
{fin = [(N 145)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT = STARTSTATE 3;
val DCOMMENT = STARTSTATE 5;
val INITIAL = STARTSTATE 1;
val PRAGMA = STARTSTATE 7;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  11 => (Tokens.COLON(yypos,yypos+1))
| 118 => (Tokens.QUID (stripquotes(yytext),yypos,yypos+size yytext))
| 120 => (error ("ignoring illegal character" ^ yytext,
			   (yypos,yypos+1)); continue())
| 123 => (eofAt (yypos,yypos+2))
| 125 => (next_line(yypos); YYBEGIN INITIAL; continue())
| 127 => (continue())
| 13 => (Tokens.DOT(yypos,yypos+1))
| 130 => (comLevel := !comLevel+1; continue())
| 133 => (comLevel := !comLevel-1;
		    if !comLevel=0 then YYBEGIN INITIAL else ();
		    continue())
| 136 => (eofAt (yypos,yypos+2))
| 138 => (next_line(yypos); continue())
| 140 => (continue())
| 143 => (continue())
| 145 => (next_line(yypos); YYBEGIN INITIAL;
		    Tokens.EOFPRAGMA(yypos,yypos+1))
| 147 => (YYBEGIN COMMENT; Tokens.EOFPRAGMA(yypos,yypos+1))
| 15 => (Tokens.LPAREN(yypos,yypos+1))
| 150 => (eofAt (yypos,yypos+2))
| 156 => (Tokens.SIGMA(yypos,yypos+5))
| 161 => (Tokens.LEFT(yypos,yypos+4))
| 167 => (Tokens.RIGHT(yypos,yypos+5))
| 17 => (Tokens.RPAREN(yypos,yypos+1))
| 172 => (Tokens.NONE_(yypos,yypos+4))
| 175 => (Tokens.NUM(makeInt(yytext),yypos,yypos+size yytext))
| 184 => (Tokens.LCID(yytext,yypos,yypos+size yytext))
| 19 => (Tokens.LBRACKET(yypos,yypos+1))
| 191 => (Tokens.UCID(yytext,yypos,yypos+size yytext))
| 2 => (continue())
| 21 => (Tokens.RBRACKET(yypos,yypos+1))
| 210 => (Tokens.QUID(stripquotes(yytext),yypos,yypos+size yytext))
| 212 => (error ("ignoring illegal character " ^ yytext
			   ^ " in pragma", (yypos, yypos+1)); continue())
| 23 => (Tokens.LBRACE(yypos,yypos+1))
| 25 => (Tokens.RBRACE(yypos,yypos+1))
| 28 => (Tokens.ARROW(yypos,yypos+2))
| 30 => (Tokens.UNDERSCORE(yypos,yypos+1))
| 36 => (Tokens.SIGMA(yypos,yypos+5))
| 4 => (next_line(yypos); continue())
| 41 => (Tokens.TYPE(yypos,yypos+4))
| 48 => (YYBEGIN PRAGMA ; Tokens.INFIX(yypos,yypos+6))
| 56 => (YYBEGIN PRAGMA ; Tokens.PREFIX(yypos,yypos+7))
| 6 => (YYBEGIN COMMENT; continue())
| 65 => (YYBEGIN PRAGMA ; Tokens.POSTFIX(yypos,yypos+8))
| 71 => (YYBEGIN PRAGMA; Tokens.NAME(yypos,yypos+5))
| 74 => (YYBEGIN DCOMMENT; comLevel := 1; continue())
| 77 => (error ("unmatched close comment }%", (yypos, yypos+2));
		    continue())
| 80 => (eofAt (yypos,yypos+2))
| 89 => (Tokens.LCID (yytext,yypos,yypos+size yytext))
| 9 => (Tokens.BACKARROW(yypos,yypos+2))
| 96 => (Tokens.UCID (yytext,yypos,yypos+size yytext))
| 99 => (Tokens.LCID (yytext,yypos,yypos+size yytext))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
