(* Copyright 2013 Ravenbrook Limited <http://www.ravenbrook.com/>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file should be generated by a stub-generator from <dirent.h>
 * The current version has been written by hand.
 *
 * Revision Log
 * ------------
 * $Log: __dirent.sml,v $
 * Revision 1.2  1997/07/03 10:08:04  stephenb
 * Automatic checkin:
 * changed attribute _comment to ' *  '
 *
 *)


require "$.basis.__word";
require "$.foreign.__mlworks_dynamic_library";
require "$.foreign.__mlworks_c_interface";
require "dirent";
require "__dirent_stub";


structure Dirent : DIRENT =
  struct
    structure C' = MLWorksCInterface

    type c_char = C'.Char.char
    type c_ushort = C'.Ushort.word
    type c_int = C'.Int.int
    type c_long = C'.Long.int
    type c_ulong = C'.Ulong.word
    type 'a c_ptr = 'a C'.ptr


    fun scale'' offset addr = C'.next (addr, offset)

    (* Types *)

    datatype DIR = DIR of C'.void c_ptr

    datatype struct'dirent = STRUCT'DIRENT of C'.void c_ptr

    type off_t = c_long

    (* Hidden utility functions *)
      
    fun DIR'toRep' (DIR addr) = addr

    fun struct'dirent'toRep' (STRUCT'DIRENT addr) = addr

    (* timespec utilities *)

    val DIR'size' = 0w24
    val DIR'addr' = C'.fromVoidPtr o DIR'toRep'

    (* DIR field addresses *)

    val DIR'dd_fd'addr : DIR -> c_int c_ptr = 
      C'.fromVoidPtr o scale'' 0w0 o DIR'toRep'

    val DIR'dd_loc'addr : DIR -> c_long c_ptr = 
      C'.fromVoidPtr o scale'' 0w4 o DIR'toRep'

    val DIR'dd_size'addr : DIR -> c_long c_ptr = 
      C'.fromVoidPtr o scale'' 0w8 o DIR'toRep'

    val DIR'dd_bsize'addr : DIR -> c_long c_ptr = 
      C'.fromVoidPtr o scale'' 0w12 o DIR'toRep'

    val DIR'dd_off'addr : DIR -> c_long c_ptr = 
      C'.fromVoidPtr o scale'' 0w16 o DIR'toRep'

    val DIR'dd_buff'addr : DIR -> c_char c_ptr c_ptr = 
      C'.fromVoidPtr o scale'' 0w20 o DIR'toRep'


    (* DIR field values *)

    val DIR'dd_fd : DIR -> c_int = 
      C'.IntPtr.! o DIR'dd_fd'addr
    
    val DIR'dd_loc : DIR -> c_long = 
      C'.LongPtr.! o DIR'dd_loc'addr

    val DIR'dd_size : DIR -> c_long = 
      C'.LongPtr.! o DIR'dd_size'addr

    val DIR'dd_bsize : DIR -> c_long = 
      C'.LongPtr.! o DIR'dd_bsize'addr

    val DIR'dd_off : DIR -> c_long = 
      C'.LongPtr.! o DIR'dd_off'addr

    val DIR'dd_buff : DIR -> c_char c_ptr = 
      C'.PtrPtr.! o DIR'dd_buff'addr


    (* struct'dirent utilities *)

    val struct'dirent'size' = 0w14 + 0w256
    val struct'dirent'addr' = C'.fromVoidPtr o struct'dirent'toRep'


    (* struct'dirent field addresses *)

    val struct'dirent'd_off'addr : struct'dirent -> off_t c_ptr = 
      C'.fromVoidPtr o scale'' 0w0 o struct'dirent'toRep'

    val struct'dirent'd_fileno'addr : struct'dirent -> c_ulong c_ptr = 
      C'.fromVoidPtr o scale'' 0w4 o struct'dirent'toRep'

    val struct'dirent'd_reclen'addr : struct'dirent -> c_ushort c_ptr = 
      C'.fromVoidPtr o scale'' 0w8 o struct'dirent'toRep'

    val struct'dirent'd_namlen'addr : struct'dirent -> c_ushort c_ptr = 
      C'.fromVoidPtr o scale'' 0w10 o struct'dirent'toRep'

    val struct'dirent'd_name'addr : struct'dirent -> c_char c_ptr = 
      C'.fromVoidPtr o scale'' 0w12 o struct'dirent'toRep'


    (* struct'dirent field values *)

    val struct'dirent'd_off : struct'dirent -> c_long = 
      C'.LongPtr.! o struct'dirent'd_off'addr

    val struct'dirent'd_fileno : struct'dirent -> c_ulong = 
      C'.UlongPtr.! o struct'dirent'd_fileno'addr

    val struct'dirent'd_reclen : struct'dirent -> c_ushort = 
      C'.UshortPtr.! o struct'dirent'd_reclen'addr

    val struct'dirent'd_namlen : struct'dirent -> c_ushort = 
      C'.UshortPtr.! o struct'dirent'd_namlen'addr

    val struct'dirent'd_name : struct'dirent -> c_char c_ptr = 
      struct'dirent'd_name'addr


    val opendir : c_char c_ptr -> DIR c_ptr =
      MLWorksDynamicLibrary.bind "dirent_opendir"

    val readdir : DIR c_ptr -> struct'dirent c_ptr =
      MLWorksDynamicLibrary.bind "dirent_readdir"

    val telldir : DIR c_ptr -> c_long =
      MLWorksDynamicLibrary.bind "dirent_telldir"

    val seekdir : DIR c_ptr * c_long -> unit =
      MLWorksDynamicLibrary.bind "dirent_seekdir"

    val rewinddir : DIR c_ptr -> unit =
      MLWorksDynamicLibrary.bind "dirent_rewinddir"

    val closedir : DIR c_ptr -> unit =
      MLWorksDynamicLibrary.bind "dirent_closedir"

  end
